/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.AbstractBuildListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.PrefsInitializer;

public class ArchivesUIBuildListener
extends AbstractBuildListener {
    public void error(final IArchiveNode node, IStatus[] multi) {
        final MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.archives.core", 0, ArchivesUIMessages.BuildError, null);
        int i = 0;
        while (i < multi.length) {
            ms.add(multi[i]);
            ++i;
        }
        if (ms.getSeverity() == 0) {
            return;
        }
        if (PrefsInitializer.getBoolean("showBuildErrorDialog")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialogWithPreference ed = new ErrorDialogWithPreference(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ArchivesUIMessages.BuildError, NLS.bind((String)ArchivesUIMessages.BuildError2, (Object)(node == null ? node : node.toString())), (IStatus)ms, 4);
                    ed.open();
                }
            });
        } else {
            ArchivesCore.getInstance().getLogger().log((IStatus)ms);
        }
    }

    public static class ErrorDialogWithPreference
    extends ErrorDialog {
        private Button checkbox;

        public ErrorDialogWithPreference(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void okPressed() {
            if (this.checkbox.getSelection()) {
                PrefsInitializer.setBoolean("showBuildErrorDialog", false);
            }
            super.okPressed();
        }

        protected Control createMessageArea(Composite parent) {
            FormData fd;
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4));
            composite.setLayout((Layout)new FormLayout());
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                this.addAccessibleListeners(this.imageLabel, image);
                fd = new FormData();
                fd.left = new FormAttachment(0, 5);
                fd.top = new FormAttachment(0, 5);
                this.imageLabel.setLayoutData((Object)fd);
            }
            if (this.message != null) {
                this.messageLabel = new Label(composite, this.getMessageLabelStyle());
                this.messageLabel.setText(this.message);
                fd = new FormData();
                fd.top = new FormAttachment(0, 5);
                fd.left = image == null ? new FormAttachment(0, 5) : new FormAttachment((Control)this.imageLabel, 5);
                this.messageLabel.setLayoutData((Object)fd);
            }
            this.checkbox = new Button(composite, 32);
            this.checkbox.setText(ArchivesUIMessages.DoNotShowThisAgain);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.messageLabel, 5);
            fd.left = new FormAttachment(0, 5);
            fd.right = new FormAttachment(0, 300);
            this.checkbox.setLayoutData((Object)fd);
            return parent;
        }

        private void addAccessibleListeners(Label label, final Image image) {
            label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent event) {
                    String accessibleMessage = ErrorDialogWithPreference.this.getAccessibleMessageFor(image);
                    if (accessibleMessage == null) {
                        return;
                    }
                    event.result = accessibleMessage;
                }
            });
        }

        private String getAccessibleMessageFor(Image image) {
            if (image.equals((Object)this.getErrorImage())) {
                return JFaceResources.getString((String)"error");
            }
            if (image.equals((Object)this.getWarningImage())) {
                return JFaceResources.getString((String)"warning");
            }
            if (image.equals((Object)this.getInfoImage())) {
                return JFaceResources.getString((String)"info");
            }
            if (image.equals((Object)this.getQuestionImage())) {
                return JFaceResources.getString((String)"question");
            }
            return null;
        }
    }
}

