/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.ide.eclipse.archives.ui.actions.INodeActionDelegate;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeContribution
implements Comparable<NodeContribution> {
    private static final String ID = "id";
    private static final String LABEL = "label";
    private static final String ICON = "icon";
    private static final String WEIGHT = "weight";
    private static final String CLASS = "class";
    private String id;
    private String label;
    private INodeActionDelegate actionDelegate;
    private ImageDescriptor icon;
    private int weight;

    public NodeContribution(IConfigurationElement element) {
        String weightString;
        URL iconURL;
        this.id = element.getAttribute(ID);
        this.label = element.getAttribute(LABEL);
        try {
            this.actionDelegate = (INodeActionDelegate)element.createExecutableExtension(CLASS);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        String iconPath = element.getAttribute(ICON);
        String pluginId = element.getDeclaringExtension().getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL uRL = iconURL = iconPath == null ? null : FileLocator.find((Bundle)bundle, (IPath)new Path(iconPath), null);
        if (iconURL != null) {
            this.icon = ImageDescriptor.createFromURL((URL)iconURL);
        }
        this.weight = Integer.parseInt((weightString = element.getAttribute(WEIGHT)) == null ? new Integer(100).toString() : weightString);
    }

    @Override
    public int compareTo(NodeContribution o) {
        NodeContribution other = o;
        if (this.weight < other.getWeight()) {
            return -1;
        }
        if (this.weight > other.getWeight()) {
            return 1;
        }
        if (this.weight == other.getWeight()) {
            return this.label.compareTo(other.getLabel());
        }
        return -1;
    }

    public INodeActionDelegate getActionDelegate() {
        return this.actionDelegate;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public int getWeight() {
        return this.weight;
    }
}

