/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.project.ProjectUtils;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;

public class DisableHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        final Object e = selection.getFirstElement();
        if (e instanceof IProject) {
            String pName = ((IProject)e).getName();
            final String jobName = NLS.bind((String)ArchivesUIMessages.DisableProjectArchivesJob, (Object)pName);
            new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)jobName, (int)300);
                    CoreException ce = null;
                    try {
                        SubMonitor deletionMonitor = progress.split(100);
                        IFile r = ((IProject)e).getFile(".packages");
                        if (r != null && r.exists()) {
                            r.delete(true, (IProgressMonitor)deletionMonitor);
                        }
                    }
                    catch (CoreException ce2) {
                        ce = ce2;
                    }
                    IPath loc = ((IProject)e).getLocation();
                    SubMonitor mon1 = progress.split(100);
                    ProjectUtils.removeProjectNature((IProject)((IProject)e), (String)"org.jboss.ide.eclipse.archives.core.archivesNature", (IProgressMonitor)mon1);
                    SubMonitor mon2 = progress.split(100);
                    ArchivesModel.instance().unregisterProject(loc, (IProgressMonitor)mon2);
                    return ce == null ? Status.OK_STATUS : new Status(4, "org.jboss.ide.eclipse.archives.core", "Unable to fully remove project archives support.");
                }
            }.schedule();
        }
        return null;
    }
}

