/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.core.resolvers.RuntimeVariableResolver;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;
import org.jboss.tools.foundation.core.expressions.IVariableResolver;

public class PathProviderResolutionUtil {
    public static IClasspathEntry getEntry(Entry entry) {
        return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath()).getClasspathEntry();
    }

    public static List<IClasspathEntry> convert(Collection<Entry> list) {
        ArrayList<IClasspathEntry> fin = new ArrayList<IClasspathEntry>();
        Iterator<Entry> i = list.iterator();
        while (i.hasNext()) {
            fin.add(PathProviderResolutionUtil.getEntry(i.next()));
        }
        return fin;
    }

    public static void addSinglePath(IPath p, ArrayList<Entry> list) {
        if (!p.toFile().exists()) {
            return;
        }
        list.add(new Entry(p, p.lastSegment(), p.toFile().length()));
    }

    public static IPath[] getAllPaths(IRuntime runtime, IRuntimePathProvider[] sets) {
        return PathProviderResolutionUtil.getAllPaths((IVariableResolver)new RuntimeVariableResolver(runtime), sets);
    }

    public static IPath[] getAllPaths(Map<String, String> map, IRuntimePathProvider[] sets) {
        return PathProviderResolutionUtil.getAllPaths((IVariableResolver)new ExpressionResolver.MapVariableResolver(map), sets);
    }

    public static IPath[] getAllPaths(IVariableResolver resolver, IRuntimePathProvider[] sets) {
        ArrayList<IPath> retval = new ArrayList<IPath>();
        int i = 0;
        while (i < sets.length) {
            sets[i].setVariableResolver(resolver);
            IPath[] absolute = sets[i].getAbsolutePaths();
            int j = 0;
            while (j < absolute.length) {
                if (!retval.contains(absolute[j])) {
                    retval.add(absolute[j]);
                }
                ++j;
            }
            ++i;
        }
        return retval.toArray(new IPath[retval.size()]);
    }

    public static IClasspathEntry[] getClasspathEntriesForResolvedPaths(IPath[] allPaths) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int i = 0;
        while (i < allPaths.length) {
            PathProviderResolutionUtil.addSinglePath(allPaths[i], entries);
            ++i;
        }
        List<IClasspathEntry> ret = PathProviderResolutionUtil.convert(entries);
        return ret.toArray(new IClasspathEntry[ret.size()]);
    }

    private static class Entry {
        private IPath path;
        private String name;
        private long length;

        public Entry(IPath path, String name, long length) {
            this.path = path;
            this.name = name;
            this.length = length;
        }

        public IPath getPath() {
            return this.path;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.length != other.length) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

