/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.descriptors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListenerManager;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;
import org.osgi.framework.Bundle;

public class XPathModel
extends UnitedServerListener {
    private static final String PROPERTIES = "properties";
    private static final String DEFAULT_PROPS_32 = "jboss.32.default.ports.properties";
    private static final String DEFAULT_PROPS_40 = "jboss.40.default.ports.properties";
    private static final String DEFAULT_PROPS_42 = "jboss.42.default.ports.properties";
    private static final String DEFAULT_PROPS_50 = "jboss.50.default.ports.properties";
    private static final String DEFAULT_PROPS_51 = "jboss.51.default.ports.properties";
    private static final String DEFAULT_PROPS_60 = "jboss.60.default.ports.properties";
    private static final String DEFAULT_PROPS_70 = "jboss.70.default.ports.properties";
    private static final String DEFAULT_PROPS_71 = "jboss.71.default.ports.properties";
    private static final String DEFAULT_PROPS_80 = "wildfly.80.default.ports.properties";
    private static final String DEFAULT_PROPS_EAP_43 = "jboss.eap.43.default.ports.properties";
    private static final String DEFAULT_PROPS_EAP_50 = "jboss.eap.50.default.ports.properties";
    public static final String EMPTY_STRING = "org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString";
    public static final String PORTS_CATEGORY_NAME = Messages.Ports;
    private static final String DELIMITER = ",";
    private static final String CATEGORY_LIST = "org.jboss.ide.eclipse.as.core.model.descriptor.Categories";
    private static XPathModel instance;
    protected HashMap<String, ArrayList<XPathCategory>> serverToCategories = new HashMap();
    private static HashMap<String, URL> rtToPortsFile;
    private static final String ATTRIBUTE_SUFFIX = "_ATTRIBUTE";
    private static final String FILE_SUFFIX = "_FILE";
    private static final String BASEDIR_SUFFIX = "_BASEDIR";
    public Properties namespaceMap = null;

    static {
        rtToPortsFile = new HashMap();
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.32", XPathModel.getURLFor(DEFAULT_PROPS_32));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.40", XPathModel.getURLFor(DEFAULT_PROPS_40));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.42", XPathModel.getURLFor(DEFAULT_PROPS_42));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.50", XPathModel.getURLFor(DEFAULT_PROPS_50));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.51", XPathModel.getURLFor(DEFAULT_PROPS_51));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.60", XPathModel.getURLFor(DEFAULT_PROPS_60));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.70", XPathModel.getURLFor(DEFAULT_PROPS_70));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.71", XPathModel.getURLFor(DEFAULT_PROPS_71));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.eap.43", XPathModel.getURLFor(DEFAULT_PROPS_EAP_43));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.eap.50", XPathModel.getURLFor(DEFAULT_PROPS_EAP_50));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.eap.60", XPathModel.getURLFor(DEFAULT_PROPS_71));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.eap.61", XPathModel.getURLFor(DEFAULT_PROPS_71));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.eap.70", XPathModel.getURLFor(DEFAULT_PROPS_80));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.eap.71", XPathModel.getURLFor(DEFAULT_PROPS_80));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.wildfly.80", XPathModel.getURLFor(DEFAULT_PROPS_80));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.wildfly.90", XPathModel.getURLFor(DEFAULT_PROPS_80));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.wildfly.100", XPathModel.getURLFor(DEFAULT_PROPS_80));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.wildfly.110", XPathModel.getURLFor(DEFAULT_PROPS_80));
    }

    public static XPathModel getDefault() {
        if (instance == null) {
            instance = new XPathModel();
        }
        return instance;
    }

    public void serverAdded(IServer server) {
        final IServer server2 = server;
        new Job(Messages.AddXPathDetailsJob){

            protected IStatus run(IProgressMonitor monitor) {
                if (server2 == null || server2.getRuntime() == null) {
                    return Status.OK_STATUS;
                }
                return XPathModel.this.handleAddJBossXPaths(server2, XPathModel.this.getQueryBaseDir(server2));
            }
        }.schedule();
    }

    private String getQueryBaseDir(IServer server) {
        ServerExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)server);
        if (props != null) {
            return props.getNewXPathDefaultRootFolder();
        }
        return "";
    }

    private IStatus handleAddJBossXPaths(IServer server2, String baseDir) {
        ArrayList<XPathCategory> defaults = XPathModel.loadDefaultPortQueries(server2, baseDir);
        this.setCategoryCollections(server2.getId(), defaults);
        this.save(server2);
        return Status.OK_STATUS;
    }

    private synchronized void setCategoryCollections(String id, ArrayList<XPathCategory> list) {
        this.serverToCategories.put(id, list);
    }

    public XPathQuery getQuery(IServer server, IPath path) {
        if (server == null || path == null || path.segmentCount() != 2) {
            return null;
        }
        XPathCategory cat = this.getCategory(server, path.segment(0));
        if (cat != null) {
            return cat.getQuery(path.segment(1));
        }
        return null;
    }

    protected synchronized ArrayList<XPathCategory> getCategoryCollection(IServer server) {
        if (this.serverToCategories.get(server.getId()) == null) {
            ArrayList<XPathCategory> val = new ArrayList<XPathCategory>(Arrays.asList(this.load(server)));
            this.serverToCategories.put(server.getId(), val);
        }
        return this.serverToCategories.get(server.getId());
    }

    public XPathCategory[] getCategories(IServer jbs) {
        ArrayList<XPathCategory> val = this.getCategoryCollection(jbs);
        return val.toArray(new XPathCategory[val.size()]);
    }

    public boolean containsCategory(IServer jbs, String name) {
        return this.getCategory(jbs, name) != null;
    }

    public XPathCategory getCategory(IServer jbs, String name) {
        ArrayList<XPathCategory> list = this.getCategoryCollection(jbs);
        for (XPathCategory c : list) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public XPathCategory addCategory(IServer jbs, String name) {
        if (!this.containsCategory(jbs, name)) {
            XPathCategory c = new XPathCategory(name, jbs);
            this.getCategoryCollection(jbs).add(c);
            return c;
        }
        return this.getCategory(jbs, name);
    }

    public void addCategory(IServer server, XPathCategory category) {
        if (!this.containsCategory(server, category.getName())) {
            this.getCategoryCollection(server).add(category);
        }
    }

    public void removeCategory(IServer server, String name) {
        ArrayList<XPathCategory> list = this.getCategoryCollection(server);
        Iterator<XPathCategory> i = list.iterator();
        while (i.hasNext()) {
            XPathCategory cat = i.next();
            if (!cat.getName().equals(name)) continue;
            i.remove();
            return;
        }
    }

    protected File getFile(IServer server) {
        return JBossServerCorePlugin.getServerStateLocation(server).append("xpaths.xml").toFile();
    }

    public synchronized void save(IServer server) {
        if (!this.serverToCategories.containsKey(server.getId())) {
            return;
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)"xpaths");
        XPathCategory[] categories = this.getCategories(server);
        int i = 0;
        while (i < categories.length) {
            XMLMemento child = (XMLMemento)memento.createChild("category");
            this.saveCategory(categories[i], server, child);
            ++i;
        }
        File f = this.getFile(server);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        try {
            memento.save((OutputStream)new FileOutputStream(f));
        }
        catch (IOException ioe) {
            JBossServerCorePlugin.log("The XPath Model could not be saved", ioe);
        }
    }

    public void saveCategory(XPathCategory category, IServer server, XMLMemento memento) {
        memento.putString("name", category.getName());
        if (category.queriesLoaded()) {
            XPathQuery[] queries = category.getQueries();
            int i = 0;
            while (i < queries.length) {
                XMLMemento child = (XMLMemento)memento.createChild("query");
                this.saveQuery(queries[i], category, server, child);
                ++i;
            }
        }
    }

    private void saveQuery(XPathQuery query, XPathCategory category, IServer server, XMLMemento memento) {
        memento.putString("name", query.getName());
        memento.putString("dir", query.getBaseDir());
        memento.putString("filePattern", query.getFilePattern());
        memento.putString("xpathPattern", query.getXpathPattern());
        memento.putString("attribute", query.getAttribute());
    }

    private XPathCategory[] load(IServer server) {
        if (this.getFile(server).exists()) {
            return this.loadXML(server);
        }
        return this.load_LEGACY(server);
    }

    private XPathCategory[] loadXML(IServer server) {
        XPathCategory[] categories = null;
        try {
            File file = this.getFile(server);
            if (file != null && file.exists() && file.isFile()) {
                XMLMemento memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(file));
                IMemento[] categoryMementos = memento.getChildren("category");
                categories = new XPathCategory[categoryMementos.length];
                int i = 0;
                while (i < categoryMementos.length) {
                    categories[i] = new XPathCategory(server, categoryMementos[i]);
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            JBossServerCorePlugin.log(ioe);
        }
        return categories == null ? new XPathCategory[]{} : categories;
    }

    private XPathCategory[] load_LEGACY(IServer server) {
        ServerAttributeHelper helper = ServerAttributeHelper.createHelper((IServer)server);
        String list = helper.getAttribute(CATEGORY_LIST, null);
        if (list == null) {
            return new XPathCategory[0];
        }
        String[] byName = list.split(DELIMITER);
        XPathCategory[] cats = new XPathCategory[byName.length];
        int i = 0;
        while (i < byName.length) {
            cats[i] = new XPathCategory(byName[i], server);
            ++i;
        }
        return cats;
    }

    public static void addServerTypeToURLMapping(String serverType, URL mapping) {
        if (!rtToPortsFile.containsKey(serverType)) {
            rtToPortsFile.put(serverType, mapping);
        }
    }

    public static URL getUrlFromServerType(String serverType) {
        return rtToPortsFile.get(serverType);
    }

    private static URL getURLFor(String props) {
        IPath properties = new Path(PROPERTIES).append(props);
        URL url = FileLocator.find((Bundle)JBossServerCorePlugin.getDefault().getBundle(), (IPath)properties, null);
        return url;
    }

    public static ArrayList<XPathCategory> loadDefaultPortQueries(IServer server, String baseDir) {
        URL url;
        ArrayList<XPathCategory> retVal = new ArrayList<XPathCategory>();
        IRuntimeType rtt = server.getRuntime().getRuntimeType();
        URL uRL = url = rtt == null ? null : rtToPortsFile.get(rtt.getId());
        if (url != null) {
            try {
                XPathCategory ports = new XPathCategory(PORTS_CATEGORY_NAME, server);
                XPathModel.addQueriesToCategoryFromDefaultFile(server, ports, baseDir, url);
                retVal.add(ports);
            }
            catch (IOException e) {
                JBossServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", Messages.XPathLoadFailure, (Throwable)e));
            }
        }
        return retVal;
    }

    public static void addQueriesToCategoryFromDefaultFile(IServer server, XPathCategory category, String baseDir, URL url) throws IOException {
        Properties pr = new Properties();
        pr.load(url.openStream());
        for (String string : pr.keySet()) {
            if (string.endsWith(ATTRIBUTE_SUFFIX) || string.endsWith(FILE_SUFFIX) || string.endsWith(BASEDIR_SUFFIX)) continue;
            String xpath = pr.getProperty(string);
            String attributeName = pr.getProperty(String.valueOf(string) + ATTRIBUTE_SUFFIX);
            String file = pr.getProperty(String.valueOf(string) + FILE_SUFFIX);
            String tmpBasedir = pr.getProperty(String.valueOf(string) + BASEDIR_SUFFIX);
            XPathQuery query = new XPathQuery(server, string.replace('_', ' '), tmpBasedir == null ? baseDir : tmpBasedir, file, xpath, attributeName);
            category.addQuery(query);
        }
    }

    public Properties getNamespaceMap() {
        if (this.namespaceMap == null) {
            this.loadNamespaceMap();
        }
        return (Properties)this.namespaceMap.clone();
    }

    protected void loadNamespaceMap() {
        URL url;
        IPath p = new Path(PROPERTIES).append("namespaceMap.properties");
        if (p != null && (url = FileLocator.find((Bundle)JBossServerCorePlugin.getDefault().getBundle(), (IPath)p, null)) != null) {
            Properties pr = new Properties();
            try {
                pr.load(url.openStream());
                this.namespaceMap = pr;
                return;
            }
            catch (IOException ioe) {
                JBossServerCorePlugin.log(ioe);
            }
        }
        this.namespaceMap = new Properties();
    }

    public void setNamespaceMap(Properties map) {
        this.namespaceMap = map;
    }

    public static XPathFileResult.XPathResultNode getResultNode(Object data) {
        XPathFileResult item;
        if (data instanceof XPathFileResult.XPathResultNode) {
            return (XPathFileResult.XPathResultNode)data;
        }
        if (data instanceof XPathFileResult && ((XPathFileResult)data).getChildren().length == 1) {
            return ((XPathFileResult)data).getChildren()[0];
        }
        if (data instanceof XPathQuery && ((XPathQuery)data).getResults().length == 1 && (item = ((XPathQuery)data).getResults()[0]).getChildren().length == 1) {
            return item.getChildren()[0];
        }
        return null;
    }

    public static XPathFileResult.XPathResultNode[] getResultNodes(XPathQuery query) {
        ArrayList<XPathFileResult.XPathResultNode> l = new ArrayList<XPathFileResult.XPathResultNode>();
        XPathFileResult[] files = query.getResults();
        int i = 0;
        while (i < files.length) {
            l.addAll(Arrays.asList(files[i].getChildren()));
            ++i;
        }
        return l.toArray(new XPathFileResult.XPathResultNode[l.size()]);
    }

    public boolean canHandleServer(IServer server) {
        return UnitedServerListenerManager.isJBossServer((IServer)server);
    }

    public boolean canHandleRuntime(IRuntime runtime) {
        return this.findAllServersForRuntime(runtime).length > 0;
    }

    public void serverChanged(IServer server) {
        this.clearCache(server);
    }

    public void runtimeChanged(IRuntime runtime) {
        IServer[] relevent = this.findAllServersForRuntime(runtime);
        int i = 0;
        while (i < relevent.length) {
            this.clearCache(relevent[i]);
            ++i;
        }
    }

    protected IServer[] findAllServersForRuntime(IRuntime rt) {
        if (rt == null) {
            return new IServer[0];
        }
        ArrayList<IServer> ret = new ArrayList<IServer>();
        IServer[] all = ServerCore.getServers();
        int i = 0;
        while (i < all.length) {
            if (rt.equals(all[i].getRuntime())) {
                ret.add(all[i]);
            }
            ++i;
        }
        return ret.toArray(new IServer[ret.size()]);
    }

    public void clearCache(IServer server) {
        XPathCategory[] cats = this.getCategories(server);
        int i = 0;
        while (i < cats.length) {
            cats[i].clearCache();
            ++i;
        }
    }
}

