/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.polling;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller2;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;

public class WebPortPoller
implements IServerStatePoller2 {
    public static final String WEB_POLLER_ID = "org.jboss.ide.eclipse.as.core.runtime.server.WebPoller";
    private IServer server;
    private IServerStatePollerType type;
    private boolean canceled;
    private boolean done;
    private boolean state;
    private boolean expectedState;

    public void beginPolling(IServer server, boolean expectedState) {
        this.server = server;
        this.done = false;
        this.canceled = false;
        this.expectedState = expectedState;
        this.state = !expectedState;
        this.launchThread();
    }

    protected void launchThread() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                WebPortPoller.this.pollerRun();
            }
        }, "Web Poller");
        t.start();
    }

    private synchronized void setStateInternal(boolean done, boolean state) {
        this.done = done;
        this.state = state;
    }

    private void pollerRun() {
        this.setStateInternal(false, this.state);
        String url = WebPortPoller.getURL(this.getServer());
        while (!this.canceled && !this.done) {
            boolean up = WebPortPoller.onePing(url);
            if (up == this.expectedState) {
                this.setStateInternal(true, this.expectedState);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static String getURL(IServer server) {
        IJBossServer jbs = ServerConverter.getJBossServer((IServer)server);
        int port = jbs.getJBossWebPort();
        return ServerUtil.createSafeURLString("http", server.getHost(), port, null);
    }

    public static boolean onePing(IServer server) {
        return WebPortPoller.onePing(WebPortPoller.getURL(server));
    }

    private static boolean onePing(String url) {
        URLConnection conn = null;
        try {
            URL pingUrl = new URL(url);
            conn = pingUrl.openConnection();
            ((HttpURLConnection)conn).getResponseCode();
            return true;
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        catch (MalformedURLException e) {
            Status s = new Status(4, "org.jboss.ide.eclipse.as.core", e.getMessage(), (Throwable)e);
            JBossServerCorePlugin.log((IStatus)s);
        }
        catch (IOException e) {
            return false;
        }
        finally {
            if (conn != null) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
        return false;
    }

    public IServerStatePollerType getPollerType() {
        return this.type;
    }

    public void setPollerType(IServerStatePollerType type) {
        this.type = type;
    }

    public IServer getServer() {
        return this.server;
    }

    public synchronized boolean isComplete() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        return this.done;
    }

    public synchronized boolean getState() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        return this.state;
    }

    public void cleanup() {
    }

    public List<String> getRequiredProperties() {
        return new ArrayList<String>();
    }

    public void provideCredentials(Properties properties) {
    }

    public synchronized void cancel(int type) {
        this.canceled = true;
    }

    public int getTimeoutBehavior() {
        return 2;
    }

    public IStatus getCurrentStateSynchronous(IServer server) {
        String url = WebPortPoller.getURL(server);
        boolean b = WebPortPoller.onePing(url);
        Status s = b ? new Status(0, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.WebPollerServerFound, (Object)url)) : new Status(1, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.WebPollerServerNotFound, (Object)url));
        return s;
    }
}

