/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.IMultiModuleURLProvider;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.ServerNamingUtility;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerTCPIPMonitorUtil;
import org.jboss.tools.as.core.server.controllable.subsystems.internal.XPathsPortsController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;

public class DeployableServer
extends ServerDelegate
implements IDeployableServer,
IMultiModuleURLProvider {
    protected Pattern defaultFilePattern = Pattern.compile(this.getDefaultModuleRestartPattern(), 2);

    protected void initialize() {
    }

    public void setDefaults(IProgressMonitor monitor) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.IGNORE_LAUNCH_COMMANDS", true);
        IRuntime rt = this.getServer().getRuntime();
        String name = rt != null ? ServerNamingUtility.getDefaultServerName(rt) : ServerNamingUtility.getNextShortServerName(this.getServer().getServerType());
        this.getServerWorkingCopy().setName(name);
    }

    public void newServerDetailsChanged(IProgressMonitor monitor) {
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
    }

    public void configurationChanged() {
    }

    public boolean isUseProjectSpecificSchedulingRuleOnPublish() {
        return true;
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        return Status.OK_STATUS;
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        IStatus status = this.canModifyModules(new IModule[]{module}, null);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        IModule[] parents = ServerModelUtilities.getParentModules((IServer)this.getServer(), (IModule)module);
        if (parents.length > 0) {
            return parents;
        }
        return new IModule[]{module};
    }

    public IModule[] getChildModules(IModule[] module) {
        return ServerModelUtilities.getChildModules((IModule[])module);
    }

    public ServerPort[] getServerPorts() {
        return new ServerPort[0];
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public String getDeployFolder() {
        return ServerUtil.makeGlobal(this.getServer().getRuntime(), (IPath)new Path(this.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", ""))).toString();
    }

    public void setDeployFolder(String folder) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", ServerUtil.makeRelative(this.getServer().getRuntime(), (IPath)new Path(folder)).toString());
    }

    public String getTempDeployFolder() {
        return ServerUtil.makeGlobal(this.getServer().getRuntime(), (IPath)new Path(this.getAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", ""))).toString();
    }

    public void setTempDeployFolder(String folder) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", ServerUtil.makeRelative(this.getServer().getRuntime(), (IPath)new Path(folder)).toString());
    }

    public void setDeployLocationType(String type) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", type);
    }

    public String getDeployLocationType() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "custom");
    }

    public void setZipWTPDeployments(boolean val) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", val);
    }

    public boolean zipsWTPDeployments() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false);
    }

    public String getDefaultModuleRestartPattern() {
        return "\\.jar$";
    }

    public void setRestartFilePattern(String filepattern) {
        this.setAttribute("org.jboss.tools.as.restartFilePattern", filepattern);
    }

    public Pattern getRestartFilePattern() {
        return this.getCompiledRestartPattern();
    }

    private Pattern getCompiledRestartPattern() {
        String currentPattern = this.getAttribute("org.jboss.tools.as.restartFilePattern", null);
        try {
            return currentPattern == null ? this.defaultFilePattern : Pattern.compile(currentPattern, 2);
        }
        catch (PatternSyntaxException pse) {
            JBossServerCorePlugin.log("Could not set restart file pattern to: " + currentPattern, pse);
            return this.defaultFilePattern;
        }
    }

    public ServerAttributeHelper getAttributeHelper() {
        IServerWorkingCopy copy = this.getServerWorkingCopy();
        if (copy == null) {
            copy = this.getServer().createWorkingCopy();
        }
        return new ServerAttributeHelper(this.getServer(), copy);
    }

    public String getConfigDirectory() {
        return this.getDeployFolder();
    }

    public IJBossServerRuntime getRuntime() {
        return RuntimeUtils.getJBossServerRuntime((IServerAttributes)this.getServer());
    }

    public boolean hasJMXProvider() {
        return false;
    }

    public int getPublicWebPort() {
        return this.getWebPort();
    }

    protected int getWebPort() {
        int ret = new XPathsPortsController(){

            public IServer getServer() {
                return DeployableServer.this.getServer();
            }

            @Override
            protected boolean automaticallyDetect(String attributeKey, String detectKey) {
                return false;
            }
        }.findPort(101, 8080);
        return ret;
    }

    public URL getModuleRootURL(IModule module) {
        return DeployableServer.getModuleRootURL(module, this.getServer().getHost(), this.getWebPort(), null);
    }

    public URL getModuleRootURL(IModule[] module) {
        if (module.length == 2) {
            String contextRoot = WebUtilities.getServerContextRoot((IProject)module[1].getProject(), (IProject)module[0].getProject());
            return DeployableServer.getModuleRootURL(module[1], this.getServer().getHost(), this.getWebPort(), contextRoot);
        }
        return module.length > 0 ? this.getModuleRootURL(module[0]) : null;
    }

    public URL getModuleRootURL(IModule module, String contextRoot) {
        return DeployableServer.getModuleRootURL(module, this.getServer().getHost(), this.getWebPort(), contextRoot);
    }

    public static URL getModuleRootURL(IModule module, String host, int port, String contextRoot) {
        if (module == null || module.loadAdapter(IWebModule.class, null) == null) {
            return null;
        }
        IWebModule webModule = (IWebModule)module.loadAdapter(IWebModule.class, null);
        if (contextRoot == null) {
            contextRoot = webModule.getContextRoot();
        }
        if (!contextRoot.endsWith("/")) {
            contextRoot = String.valueOf(contextRoot) + "/";
        }
        String actualHost = ServerTCPIPMonitorUtil.getHostFor((String)host, (int)port);
        int actualPort = ServerTCPIPMonitorUtil.getPortFor((String)actualHost, (int)port);
        String url = null;
        url = actualPort == 80 ? ServerUtil.createSafeURLString("http", actualHost, contextRoot) : ServerUtil.createSafeURLString("http", actualHost, actualPort, contextRoot);
        try {
            return new URL(url);
        }
        catch (MalformedURLException murle) {
            return null;
        }
    }

    public IPath getDeploymentLocation(IModule[] module, boolean deep) {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.getServer());
        if (beh != null) {
            try {
                IModule[] iModuleArray;
                if (deep) {
                    iModuleArray = module;
                } else {
                    IModule[] iModuleArray2 = new IModule[1];
                    iModuleArray = iModuleArray2;
                    iModuleArray2[0] = module[0];
                }
                IModule[] moduleToTest = iModuleArray;
                IModuleDeployPathController controller = (IModuleDeployPathController)beh.getController("moduleDeployPath");
                IPath ret = controller.getDeployDirectory(moduleToTest);
                return ret;
            }
            catch (CoreException ce) {
                return null;
            }
        }
        return null;
    }

    public IPath getTempDeploymentLocation(IModule[] module, boolean deep) {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.getServer());
        if (beh != null) {
            try {
                IModule[] iModuleArray;
                if (deep) {
                    iModuleArray = module;
                } else {
                    IModule[] iModuleArray2 = new IModule[1];
                    iModuleArray = iModuleArray2;
                    iModuleArray2[0] = module[0];
                }
                IModule[] moduleToTest = iModuleArray;
                IModuleDeployPathController controller = (IModuleDeployPathController)beh.getController("moduleDeployPath");
                IPath ret = controller.getTemporaryDeployDirectory(moduleToTest).removeLastSegments(1);
                return ret;
            }
            catch (CoreException ce) {
                return null;
            }
        }
        return null;
    }
}

