/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.publishers.JSTPublisherXMLToucher;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;
import org.jboss.tools.jmx.core.IJMXRunnable;

public class JBossLT6ModuleStateVerifier
extends AbstractSubsystemController
implements IModuleStateController,
IServerModuleStateVerifier {
    private IDeploymentOptionsController deploymentOptions;
    private IModuleDeployPathController deployPathController;
    private IFilesystemController filesystemController;

    protected IDeploymentOptionsController getDeploymentOptions() throws CoreException {
        if (this.deploymentOptions == null) {
            this.deploymentOptions = (IDeploymentOptionsController)this.findDependencyFromBehavior("deploymentOptions");
        }
        return this.deploymentOptions;
    }

    protected IModuleDeployPathController getDeployPathController() throws CoreException {
        if (this.deployPathController == null) {
            HashMap<String, IDeploymentOptionsController> env = new HashMap<String, IDeploymentOptionsController>(this.getEnvironment());
            env.put("IModuleDeployPathController.DeploymentOptionsController", this.getDeploymentOptions());
            this.deployPathController = (IModuleDeployPathController)this.findDependency("moduleDeployPath", this.getServer().getServerType().getId(), env);
        }
        return this.deployPathController;
    }

    protected IFilesystemController getFilesystemController() throws CoreException {
        if (this.filesystemController == null) {
            this.filesystemController = (IFilesystemController)this.findDependencyFromBehavior("filesystem");
        }
        return this.filesystemController;
    }

    public boolean isModuleStarted(IServer server, IModule[] module, IProgressMonitor monitor) {
        return this.getModuleState(server, module, monitor) == 2;
    }

    public int getModuleState(final IServer server, final IModule[] module, final IProgressMonitor monitor) {
        boolean[] result;
        block6: {
            result = new boolean[]{false};
            IJMXRunnable r = new IJMXRunnable(){

                public void run(MBeanServerConnection connection) throws Exception {
                    result[0] = JBossLT6ModuleStateVerifier.this.checkDeploymentStarted(server, module, connection, monitor);
                }
            };
            ExtensionManager.IServerJMXRunner runner = ExtensionManager.getDefault().getJMXRunner();
            if (runner == null) {
                Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 0, "No JMX Runner found", null);
                ServerLogger.getDefault().log(server, (IStatus)status);
                return 0;
            }
            try {
                try {
                    runner.beginTransaction(server, (Object)this);
                    runner.run(server, r);
                }
                catch (CoreException jmxe) {
                    Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 0, Messages.JMXResumeScannerError, (Throwable)jmxe);
                    ServerLogger.getDefault().log(server, (IStatus)status);
                    runner.endTransaction(server, (Object)this);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                runner.endTransaction(server, (Object)this);
                throw throwable;
            }
            runner.endTransaction(server, (Object)this);
        }
        return result[0] ? 2 : 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitModuleStarted(IServer server, IModule[] module, int maxDelay) {
        final NullProgressMonitor monitor = new NullProgressMonitor();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ie) {
                    return;
                }
                NullProgressMonitor nullProgressMonitor = monitor;
                synchronized (nullProgressMonitor) {
                    monitor.setCanceled(false);
                }
            }
        };
        t.start();
        this.waitModuleStarted(server, module, (IProgressMonitor)monitor);
        NullProgressMonitor nullProgressMonitor = monitor;
        synchronized (nullProgressMonitor) {
            if (!monitor.isCanceled()) {
                t.interrupt();
            }
        }
    }

    public void waitModuleStarted(IServer server, IModule[] module, IProgressMonitor monitor) {
        this.waitJMX(server, module);
    }

    protected void waitJMX(final IServer server, final IModule[] module) {
        IJMXRunnable r = new IJMXRunnable(){

            public void run(MBeanServerConnection connection) throws Exception {
                JBossLT6ModuleStateVerifier.this.jmxWaitForDeploymentStarted(server, module, connection, null);
            }
        };
        ExtensionManager.IServerJMXRunner runner = ExtensionManager.getDefault().getJMXRunner();
        if (runner == null) {
            Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 0, "No JMX Runner found", null);
            ServerLogger.getDefault().log(server, (IStatus)status);
            return;
        }
        try {
            try {
                runner.beginTransaction(server, (Object)this);
                runner.run(server, r);
            }
            catch (CoreException jmxe) {
                Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 1107689472, Messages.JMXResumeScannerError, (Throwable)jmxe);
                ServerLogger.getDefault().log(server, (IStatus)status);
                runner.endTransaction(server, (Object)this);
            }
        }
        finally {
            runner.endTransaction(server, (Object)this);
        }
    }

    protected void jmxWaitForDeploymentStarted(IServer server, IModule[] module, MBeanServerConnection connection, IProgressMonitor monitor) throws Exception {
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        monitor.beginTask("Ensuring Deployments are Loaded", 10000);
        while (!monitor.isCanceled()) {
            boolean done = this.checkDeploymentStarted(server, module, connection, monitor);
            if (done) {
                monitor.done();
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected boolean checkDeploymentStarted(IServer server, IModule[] module, MBeanServerConnection connection, IProgressMonitor monitor) throws Exception {
        String typeId = module[module.length - 1].getModuleType().getId();
        if (typeId.equals("wst.web") || typeId.equals("jst.web")) {
            return this.checkWebModuleStarted(server, module, connection);
        }
        return true;
    }

    protected boolean checkWebModuleStarted(IServer server, IModule[] module, MBeanServerConnection connection) throws Exception {
        if (module.length > 1) {
            return this.checkNestedWebModuleStarted(server, module, connection);
        }
        return this.checkStandaloneWebModuleStarted(server, module, connection);
    }

    protected boolean checkNestedWebModuleStarted(IServer server, IModule[] module, MBeanServerConnection connection) throws Exception {
        String stateAttribute;
        String n = module[module.length - 1].getName();
        String mbeanName = "jboss.deployment:id=\"jboss.web.deployment:war=/" + n + "\",type=Component";
        Object result = this.getAttributeResult(connection, mbeanName, stateAttribute = "State");
        return result != null && result.toString().equals("DEPLOYED");
    }

    protected boolean checkStandaloneWebModuleStarted(IServer server, IModule[] module, MBeanServerConnection connection) throws Exception {
        String stateAttribute;
        String n = module[module.length - 1].getName();
        String mbeanName = "jboss.web:J2EEApplication=none,J2EEServer=none,j2eeType=WebModule,name=//localhost/" + n;
        Object result = this.getAttributeResult(connection, mbeanName, stateAttribute = "state");
        return result != null && result instanceof Integer && (Integer)result == 1;
    }

    protected Object getAttributeResult(MBeanServerConnection connection, String mbeanName, String stateAttribute) throws Exception {
        ObjectName on = new ObjectName(mbeanName);
        try {
            return connection.getAttribute(on, stateAttribute);
        }
        catch (InstanceNotFoundException infe) {
            return false;
        }
    }

    public boolean canRestartModule(IModule[] module) {
        return module.length == 1 && module[0] != null;
    }

    public int startModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        return this.getServer().getModuleState(module);
    }

    public int stopModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        return this.getServer().getModuleState(module);
    }

    private IPath getModuleDeployRoot(IModule[] module) throws CoreException {
        IDeploymentOptionsController opts = this.getDeploymentOptions();
        IModuleDeployPathController depPath = this.getDeployPathController();
        return new RemotePath(depPath.getDeployDirectory(module).toOSString(), opts.getPathSeparatorCharacter());
    }

    public int restartModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (!this.canRestartModule(module)) {
            return this.getServer().getModuleState(module);
        }
        IPath archiveDestination = this.getModuleDeployRoot(module);
        IFilesystemController controller = this.getFilesystemController();
        if (ServerModelUtilities.isBinaryModule((IModule)module[module.length - 1]) || this.getDeploymentOptions().prefersZippedDeployments()) {
            controller.touchResource(archiveDestination, monitor);
        } else {
            JSTPublisherXMLToucher.getInstance().touch(archiveDestination, module[0], controller);
        }
        return 2;
    }

    public int getModuleState(IModule[] module, IProgressMonitor monitor) {
        return this.getModuleState(this.getServer(), module, monitor);
    }

    public boolean isModuleStarted(IModule[] module, IProgressMonitor monitor) {
        return this.isModuleStarted(this.getServer(), module, monitor);
    }

    public void waitModuleStarted(IModule[] module, IProgressMonitor monitor) {
        this.waitModuleStarted(this.getServer(), module, monitor);
    }

    public void waitModuleStarted(IModule[] module, int maxDelay) {
        this.waitModuleStarted(this.getServer(), module, maxDelay);
    }
}

