/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.extendedproperties;

import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IDefaultLaunchArguments;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.IServerModeDetails;
import org.jboss.ide.eclipse.as.core.util.IJBossRuntimeConstants;
import org.jboss.ide.eclipse.as.core.util.JavaUtils;
import org.jboss.ide.eclipse.as.core.util.PortalUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;

public class JBossDefaultLaunchArguments
implements IDefaultLaunchArguments,
IJBossRuntimeConstants {
    protected IServer server;
    protected IRuntime runtime;
    private IPath serverHome;

    public JBossDefaultLaunchArguments(IServer s) {
        this(s.getRuntime());
        this.server = s;
    }

    public JBossDefaultLaunchArguments(IRuntime rt) {
        this.runtime = rt;
    }

    private void setServerHome(IPath path) {
        this.serverHome = path;
    }

    protected IPath getServerHome() {
        if (this.serverHome != null) {
            return this.serverHome;
        }
        if (this.server != null) {
            IServerModeDetails det = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)this.server, IServerModeDetails.class);
            String homeDir = det.getProperty("PROP_SERVER_HOME");
            return new Path(homeDir);
        }
        return this.getLocalRuntimeHomeDirectory();
    }

    protected IRuntime getRuntime() {
        return this.server == null ? this.runtime : this.server.getRuntime();
    }

    protected IJBossServerRuntime getJBossRuntime() {
        IRuntime rt = this.getRuntime();
        return rt == null ? null : (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, null);
    }

    public String getStartDefaultProgramArgs() {
        String s1 = "--configuration=" + this.getJBossRuntime().getJBossConfiguration() + " ";
        if (PortalUtil.getServerPortalType((IJBossServerRuntime)this.getJBossRuntime()) == PortalUtil.TYPE_GATE_IN) {
            s1 = String.valueOf(s1) + " -Dexo.conf.dir.name=gatein";
        }
        return s1;
    }

    public String getStartDefaultVMArgs() {
        return String.valueOf(this.getProgramNameArgs()) + this.getServerFlagArgs() + "-Djava.awt.headless=true " + this.getMemoryArgs() + this.getJavaFlags() + this.getJBossJavaFlags();
    }

    protected String getProgramNameArgs() {
        String name = this.server == null ? this.runtime.getName() : this.server.getName();
        String ret = "\"-Dprogram.name=JBossTools: " + name + "\"" + " ";
        return ret;
    }

    protected String getServerFlagArgs() {
        if (this.getJBossRuntime() != null && JavaUtils.supportsServerMode((IVMInstall)this.getJBossRuntime().getVM())) {
            return "-server ";
        }
        return new String();
    }

    protected boolean isLinux() {
        return Platform.getOS().equals("linux");
    }

    protected String getJavaFlags() {
        return this.getJavaFlags(this.isLinux());
    }

    protected String getJavaFlags(boolean includeIPVersionFlag) {
        String ret = new String();
        if (includeIPVersionFlag) {
            ret = String.valueOf(ret) + "-Djava.net.preferIPv4Stack=" + !this.isIP6() + " ";
        }
        ret = String.valueOf(ret) + "-Dsun.rmi.dgc.client.gcInterval=3600000 ";
        ret = String.valueOf(ret) + "-Dsun.rmi.dgc.server.gcInterval=3600000 ";
        return ret;
    }

    protected boolean isIP6() {
        return ServerUtil.matchesIP6t(this.server.getHost());
    }

    protected String getJBossJavaFlags() {
        IPath serverHome = this.getServerHome();
        String ret = "\"-Djava.endorsed.dirs=" + serverHome.append("lib").append("endorsed").toOSString() + "\"" + " ";
        if (serverHome.append("bin").append("native").toFile().exists()) {
            ret = String.valueOf(ret) + "-Djava.library.path=\"" + serverHome.append("bin").append("native").toOSString() + "\"" + " ";
        }
        return ret;
    }

    protected IPath getLocalRuntimeHomeDirectory() {
        IRuntime rt = this.runtime == null ? this.server.getRuntime() : this.runtime;
        return rt.getLocation();
    }

    protected String getMemoryArgs() {
        return "-Xms256m -Xmx512m -XX:MaxPermSize=256m ";
    }

    public HashMap<String, String> getDefaultRunEnvVars() {
        HashMap<String, String> envVars = new HashMap<String, String>(1);
        envVars.put("PATH", "native" + System.getProperty("path.separator") + "${env_var:PATH}");
        return envVars;
    }

    public String getStartDefaultProgramArgs(IPath serverHome) {
        this.setServerHome(serverHome);
        return this.getStartDefaultProgramArgs();
    }

    public String getStartDefaultVMArgs(IPath serverHome) {
        this.setServerHome(serverHome);
        return this.getStartDefaultVMArgs();
    }

    protected String getShutdownServerUrl() {
        IJBossServer jbs = ServerConverter.getJBossServer((IServer)this.server);
        return String.valueOf(jbs.getHost()) + ":" + jbs.getJNDIPort();
    }

    protected boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public String getDefaultStopArgs() {
        IJBossServer jbs = ServerConverter.getJBossServer((IServer)this.server);
        String username = jbs.getUsername();
        String pw = jbs.getPassword();
        String serverUrl = this.getShutdownServerUrl();
        StringBuffer sb = new StringBuffer();
        sb.append("-S");
        sb.append(" ");
        sb.append("-s");
        sb.append(" ");
        sb.append(serverUrl);
        sb.append(" ");
        if (!this.isEmpty(username)) {
            sb.append("-u");
            sb.append(" ");
            sb.append(username);
            sb.append(" ");
        }
        if (!this.isEmpty(pw)) {
            sb.append("-p");
            sb.append(" ");
            sb.append(pw);
            sb.append(" ");
        }
        return sb.toString();
    }
}

