/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.JBossLaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class LaunchConfigUtils {
    public static void addJREEntry(IVMInstall vmInstall, List<IRuntimeClasspathEntry> cp) {
        IRuntimeClasspathEntry got = LaunchConfigUtils.getJREEntry(vmInstall);
        if (got != null) {
            cp.add(got);
        }
    }

    public static IRuntimeClasspathEntry getJREEntry(IVMInstall vmInstall) {
        if (vmInstall != null) {
            try {
                String name = vmInstall.getName();
                String installTypeId = vmInstall.getVMInstallType().getId();
                IRuntimeClasspathEntry jreEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(installTypeId).append(name), (int)2);
                return jreEntry;
            }
            catch (CoreException e) {
                Status s = new Status(4, "org.jboss.ide.eclipse.as.core", Messages.LaunchConfigJREError, (Throwable)e);
                JBossServerCorePlugin.getDefault().getLog().log((IStatus)s);
            }
        }
        return null;
    }

    public static void addToolsJar(IVMInstall vmInstall, List<IRuntimeClasspathEntry> cp) {
        File f = vmInstall.getInstallLocation();
        File c1 = new File(f, "lib");
        File c2 = new File(c1, "tools.jar");
        if (c2.exists()) {
            LaunchConfigUtils.addCPEntry((IPath)new Path(c2.getAbsolutePath()), cp);
        }
    }

    public static void addCPEntry(IPath path, List<IRuntimeClasspathEntry> list) {
        list.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
    }

    public static void addCPEntry(String serverHome, String relative, ArrayList<IRuntimeClasspathEntry> list) {
        LaunchConfigUtils.addCPEntry((IPath)new Path(serverHome), relative, list);
    }

    public static void addCPEntry(IPath serverHome, String relative, ArrayList<IRuntimeClasspathEntry> list) {
        LaunchConfigUtils.addCPEntry(serverHome.append(relative), list);
    }

    public static List<String> toStrings(List<IRuntimeClasspathEntry> cp) throws CoreException {
        Iterator<IRuntimeClasspathEntry> cpi = cp.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (cpi.hasNext()) {
            IRuntimeClasspathEntry entry = cpi.next();
            list.add(entry.getMemento());
        }
        return list;
    }

    public static String classpathUserClassesToString(ILaunchConfiguration config) throws CoreException {
        StringBuilder builder = new StringBuilder();
        List<String> classpath = new JBossLaunchConfigProperties().getClasspath(config);
        for (String entry : classpath) {
            IRuntimeClasspathEntry runtimeEntry = JavaRuntime.newRuntimeClasspathEntry((String)entry);
            int classpathProperty = runtimeEntry.getClasspathProperty();
            if (classpathProperty != 3) continue;
            builder.append(runtimeEntry.getLocation());
            builder.append(" ");
        }
        return builder.toString();
    }

    public static IRuntimeClasspathEntry getRunJarRuntimeCPEntry(IServer server) throws CoreException {
        IPath containerPath = new Path("org.jboss.ide.eclipse.as.core.server.launch.runJarContainer").append(server.getName());
        return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)containerPath, (int)3);
    }

    public static IRuntimeClasspathEntry getModulesClasspathEntry(JBossServer server) throws CoreException {
        return LaunchConfigUtils.getModulesClasspathEntry(server.getServer());
    }

    public static IRuntimeClasspathEntry getModulesClasspathEntry(IServer server) throws CoreException {
        return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)LaunchConfigUtils.getModulesPath(server));
    }

    public static IPath getModulesPath(IServer server) throws CoreException {
        IPath runtimeLocation = server.getRuntime().getLocation();
        return runtimeLocation.append("jboss-modules.jar");
    }

    public static void addDirectory(String serverHome, List<IRuntimeClasspathEntry> classpath, String dirName) {
        String libPath = String.valueOf(serverHome) + File.separator + dirName;
        File libDir = new File(libPath);
        File[] libs = libDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.endsWith(".jar");
            }
        });
        if (libs == null) {
            return;
        }
        int i = 0;
        while (i < libs.length) {
            classpath.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(String.valueOf(libPath) + File.separator + libs[i].getName())));
            ++i;
        }
    }

    public static ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(String name, String type) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigType = launchManager.getLaunchConfigurationType(type);
        String launchName = launchManager.generateLaunchConfigurationName(name);
        return launchConfigType.newInstance(null, launchName);
    }

    public static IServer checkedGetServer(ILaunchConfiguration launchConfig) throws CoreException {
        String serverId = new JBossLaunchConfigProperties().getServerId(launchConfig);
        return ServerConverter.findServer((String)serverId);
    }
}

