/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;

public class ServerNamingUtility {
    public static String getNextShortServerName(IServerType type) {
        if (type.getId().startsWith("org.jboss.ide.eclipse.as.eap.")) {
            String name = type.getName();
            String base = name.replace("JBoss Enterprise Application Platform", "JBoss EAP");
            return ServerNamingUtility.getDefaultServerName(base);
        }
        return ServerNamingUtility.getDefaultServerName(type.getName());
    }

    public static String getDefaultServerName(IRuntime rt) {
        IRuntimeType rtt;
        String runtimeName = rt.getName();
        String base = null;
        base = runtimeName == null || runtimeName.equals("") ? NLS.bind((String)Messages.serverVersionName, (Object)((rtt = rt.getRuntimeType()) == null ? null : rtt.getVersion())) : NLS.bind((String)Messages.serverName, (Object)runtimeName);
        return ServerNamingUtility.getDefaultServerName(base);
    }

    public static String getDefaultServerName(String base) {
        if (ServerUtil.findServer(base) == null) {
            return base;
        }
        int i = 2;
        while (ServerUtil.findServer(NLS.bind((String)Messages.serverCountName, (Object)base, (Object)i)) != null) {
            ++i;
        }
        return NLS.bind((String)Messages.serverCountName, (Object)base, (Object)i);
    }
}

