/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.internal.modules;

import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.wst.server.core.IModule;
import org.jboss.tools.as.core.internal.modules.DeploymentModulePrefs;
import org.jboss.tools.as.core.internal.modules.DeploymentTypePrefs;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;

public class DeploymentPreferences {
    private static final String LOCAL_PUBLISH_METHOD = "local";
    private static final String DEPLOYMENT = "deployment";
    private static final String PROPERTY = "property";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private HashMap<String, DeploymentTypePrefs> children = new HashMap();
    private XMLMemento memento;

    public DeploymentPreferences(InputStream is) {
        if (is != null) {
            this.memento = XMLMemento.createReadRoot((InputStream)is);
            String[] deploymentTypes = this.memento.getChildNames();
            int i = 0;
            while (i < deploymentTypes.length) {
                this.children.put(deploymentTypes[i], new DeploymentTypePrefs(this.memento.getChild(deploymentTypes[i])));
                ++i;
            }
        } else {
            this.memento = XMLMemento.createWriteRoot((String)DEPLOYMENT);
        }
    }

    public DeploymentTypePrefs getOrCreatePreferences() {
        return this.getOrCreatePreferences(LOCAL_PUBLISH_METHOD);
    }

    private DeploymentTypePrefs getOrCreatePreferences(String deploymentType) {
        if (this.children.get(deploymentType) == null) {
            this.children.put(deploymentType, new DeploymentTypePrefs(this.memento.createChild(deploymentType)));
        }
        return this.children.get(deploymentType);
    }

    protected XMLMemento getMemento() {
        return this.memento;
    }

    public String getProperty(String key) {
        IMemento[] children = this.memento.getChildren(PROPERTY);
        int i = 0;
        while (i < children.length) {
            if (key.equals(children[i].getString(KEY))) {
                return children[i].getString(VALUE);
            }
            ++i;
        }
        return null;
    }

    public void setProperty(String key, String val) {
        IMemento[] children = this.memento.getChildren(PROPERTY);
        int i = 0;
        while (i < children.length) {
            if (key.equals(children[i].getString(KEY))) {
                children[i].putString(KEY, key);
                children[i].putString(VALUE, val);
                return;
            }
            ++i;
        }
        IMemento child = this.memento.createChild(PROPERTY);
        child.putString(KEY, key);
        child.putString(VALUE, val);
    }

    public void setModulePreferenceValue(IModule module, String key, String val) {
        DeploymentModulePrefs modPrefs = this.getOrCreatePreferences().getOrCreateModulePrefs(module);
        modPrefs.setProperty(key, val);
    }
}

