/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.internal.modules;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferences;

public class DeploymentPreferencesLoader {
    public static final String DEPLOYMENT_PREFERENCES_KEY = "org.jboss.ide.eclipse.as.core.util.deploymentPreferenceKey";

    public static DeploymentPreferences loadPreferencesFromServer(IServerAttributes server) {
        String xml = server.getAttribute(DEPLOYMENT_PREFERENCES_KEY, null);
        ByteArrayInputStream bis = null;
        if (xml != null) {
            bis = new ByteArrayInputStream(xml.getBytes());
        }
        return new DeploymentPreferences(bis);
    }

    public static void savePreferences(OutputStream os, DeploymentPreferences prefs) throws IOException {
        prefs.getMemento().save(os);
    }

    public static void savePreferencesToServerWorkingCopy(ServerAttributeHelper helper, DeploymentPreferences prefs) {
        DeploymentPreferencesLoader.savePreferencesToServerWorkingCopy(helper.getWorkingCopy(), prefs);
    }

    public static void savePreferencesToServerWorkingCopy(IServerWorkingCopy wc, DeploymentPreferences prefs) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeploymentPreferencesLoader.savePreferences(bos, prefs);
            String asXML = new String(bos.toByteArray());
            wc.setAttribute(DEPLOYMENT_PREFERENCES_KEY, asXML);
        }
        catch (IOException ioe) {
            JBossServerCorePlugin.log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Could not save module deployment preferences to server " + wc.getOriginal().getName(), (Throwable)ioe));
        }
    }
}

