/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferences;
import org.jboss.tools.as.core.internal.modules.DeploymentPreferencesLoader;
import org.jboss.tools.as.core.internal.modules.ModuleDeploymentPrefsUtil;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;

public class ModuleDeployPathController
extends AbstractSubsystemController
implements IModuleDeployPathController {
    private IDeploymentOptionsController options;

    private IDeploymentOptionsController getDeploymentOptions() {
        if (this.options == null) {
            this.options = (IDeploymentOptionsController)this.getEnvironment().get("IModuleDeployPathController.DeploymentOptionsController");
            if (this.options == null) {
                try {
                    this.options = (IDeploymentOptionsController)this.findDependencyFromBehavior("deploymentOptions");
                }
                catch (CoreException ce) {
                    JBossServerCorePlugin.log(ce.getStatus());
                }
            }
        }
        return this.options;
    }

    protected String getDefaultDeployFolder() {
        IDeploymentOptionsController c;
        String ret = (String)this.getEnvironment().get("IModuleDeployPathController.DeployFolder");
        if (ret == null && (c = this.getDeploymentOptions()) != null) {
            return c.getDeploymentsRootFolder(true);
        }
        return ret;
    }

    protected String getDefaultTmpDeployFolder() {
        IDeploymentOptionsController c;
        String ret = (String)this.getEnvironment().get("IModuleDeployPathController.TmpDeployFolder");
        if (ret == null && (c = this.getDeploymentOptions()) != null) {
            return c.getDeploymentsTemporaryFolder(true);
        }
        return ret;
    }

    protected char getTargetSystemSeparator() {
        Character c = (Character)this.getEnvironment().get("PathHandling.TargetSystemSeparator");
        if (c == null) {
            IDeploymentOptionsController cont = this.getDeploymentOptions();
            if (cont == null) {
                return File.separatorChar;
            }
            return cont.getPathSeparatorCharacter();
        }
        return c.charValue();
    }

    @Override
    public String getOutputName(IModule[] module) {
        IServerAttributes server = this.getServerOrWC();
        IPath p = this.createModuleDeploymentPrefsUtil().getModuleNestedDeployPath(module, "/", server);
        return p.lastSegment();
    }

    protected ModuleDeploymentPrefsUtil createModuleDeploymentPrefsUtil() {
        return new ModuleDeploymentPrefsUtil();
    }

    @Override
    public IPath getDeployDirectory(IModule[] module) {
        return this.getDeployDirectory(module, this.isBinaryModule(module));
    }

    @Override
    public IPath getDeployDirectory(IModule[] module, boolean binary) {
        IServerAttributes server = this.getServerOrWC();
        IPath fullPath = this.createModuleDeploymentPrefsUtil().getModuleTreeDestinationFullPath(module, server, this.getDefaultDeployFolder(), this.getTargetSystemSeparator());
        if (!binary) {
            return fullPath;
        }
        return fullPath.removeLastSegments(1);
    }

    protected boolean isBinaryModule(IModule[] module) {
        return ServerModelUtilities.isBinaryModule((IModule[])module);
    }

    @Override
    public IPath getTemporaryDeployDirectory(IModule[] module) {
        IServerAttributes server = this.getServerOrWC();
        IPath fullPath = this.createModuleDeploymentPrefsUtil().getModuleTempDeployPath(module, server, this.getDefaultTmpDeployFolder(), this.getTargetSystemSeparator());
        return fullPath;
    }

    private void verifyWorkingCopy() throws IllegalStateException {
        IServerWorkingCopy wc = this.getWorkingCopy();
        if (wc == null) {
            throw new IllegalStateException("This controller requires a server working-copy.");
        }
    }

    @Override
    public void setOutputName(IModule module, String name) throws IllegalStateException {
        this.setModuleDeploymentPreference(module, "outputName", name);
    }

    @Override
    public void setDeployDirectory(IModule module, String directory) throws IllegalStateException {
        this.setModuleDeploymentPreference(module, "location", directory);
    }

    @Override
    public void setTemporaryDeployDirectory(IModule module, String directory) throws IllegalStateException {
        this.setModuleDeploymentPreference(module, "tempLocation", directory);
    }

    protected void setModuleDeploymentPreference(IModule module, String key, String val) {
        this.verifyWorkingCopy();
        DeploymentPreferences prefs = DeploymentPreferencesLoader.loadPreferencesFromServer(this.getServerOrWC());
        prefs.setModulePreferenceValue(module, key, val);
        DeploymentPreferencesLoader.savePreferencesToServerWorkingCopy(this.getWorkingCopy(), prefs);
    }

    @Override
    public String getDefaultSuffix(IModule module) {
        return ServerModelUtilities.getDefaultSuffixForModule((IModule)module);
    }

    public IStatus validate() {
        IStatus s = super.validate();
        if (!s.isOK()) {
            return s;
        }
        if (this.missingProperty("IModuleDeployPathController.DeploymentOptionsController")) {
            if (this.missingProperty("IModuleDeployPathController.DeployFolder")) {
                return this.invalid();
            }
            if (this.missingProperty("IModuleDeployPathController.TmpDeployFolder")) {
                return this.invalid();
            }
        }
        return Status.OK_STATUS;
    }

    private boolean missingProperty(String key) {
        return this.getEnvironment() == null || this.getEnvironment().get(key) == null;
    }

    private IStatus invalid() {
        return new Status(4, "org.jboss.ide.eclipse.as.core", "The controller is invalid and is missing required properties");
    }
}

