/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleRestartBehaviorController;

public class StandardModuleRestartBehaviorController
extends AbstractSubsystemController
implements IModuleRestartBehaviorController {
    public static final String PROPERTY_RESTART_FILE_PATTERN = "org.jboss.tools.as.restartFilePattern";
    public static final String PROPERTY_USE_DEFAULT_RESTART_PATTERN = "org.jboss.tools.as.useDefaultRestartFilePattern";
    public static final String RESTART_DEFAULT_FILE_PATTERN = "\\.jar$";
    protected static Pattern defaultRestartPattern = Pattern.compile(StandardModuleRestartBehaviorController.getDefaultModuleRestartPattern(), 2);
    private IDeploymentOptionsController deploymentOptions;
    private IModuleDeployPathController deployPathController;
    private Pattern restartFilePattern;

    private static String getDefaultModuleRestartPattern() {
        return RESTART_DEFAULT_FILE_PATTERN;
    }

    private boolean moduleRequiresRestart(IModule[] module) {
        try {
            IDeploymentOptionsController opts = this.getDeploymentOptions();
            IModuleDeployPathController depPath = this.getDeployPathController();
            RemotePath dest = new RemotePath(depPath.getDeployDirectory(module).toOSString(), opts.getPathSeparatorCharacter());
            IModule[] parentModule = this.getParentModule(module);
            String relativePath = null;
            if (parentModule != null) {
                IPath parentModuleDestPath = new RemotePath(depPath.getDeployDirectory(parentModule).toOSString(), opts.getPathSeparatorCharacter()).addTrailingSeparator();
                relativePath = dest.toOSString().substring(parentModuleDestPath.toOSString().length());
            } else {
                relativePath = dest.lastSegment();
            }
            return this.testPath(relativePath);
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.log(ce);
            return false;
        }
    }

    private IModule[] getParentModule(IModule[] current) {
        if (current.length > 1) {
            ArrayList<IModule> parent = new ArrayList<IModule>();
            parent.addAll(Arrays.asList(current));
            parent.remove(current[current.length - 1]);
            return parent.toArray(new IModule[parent.size()]);
        }
        return null;
    }

    @Override
    public boolean moduleRequiresRestart(IModule[] module, IModuleResource[] resourcesToTest) {
        this.loadPattern();
        if (module != null && this.moduleRequiresRestart(module)) {
            return true;
        }
        boolean matches = false;
        int i = 0;
        while (i < resourcesToTest.length && !matches) {
            matches |= this.testResource(resourcesToTest[i]);
            ++i;
        }
        return matches;
    }

    protected IDeploymentOptionsController getDeploymentOptions() throws CoreException {
        if (this.deploymentOptions == null) {
            this.deploymentOptions = (IDeploymentOptionsController)this.findDependencyFromBehavior("deploymentOptions");
        }
        return this.deploymentOptions;
    }

    protected IModuleDeployPathController getDeployPathController() throws CoreException {
        if (this.deployPathController == null) {
            HashMap<String, IDeploymentOptionsController> env = this.getEnvironment() == null ? new HashMap<String, IDeploymentOptionsController>() : new HashMap(this.getEnvironment());
            env.put("IModuleDeployPathController.DeploymentOptionsController", this.getDeploymentOptions());
            this.deployPathController = (IModuleDeployPathController)this.findDependency("moduleDeployPath", this.getServer().getServerType().getId(), env);
        }
        return this.deployPathController;
    }

    private boolean testResource(IModuleResource r) {
        boolean matches = false;
        if (r instanceof IModuleFolder) {
            IModuleResource[] children = ((IModuleFolder)r).members();
            int i = 0;
            while (i < children.length && !matches) {
                matches |= this.testResource(children[i]);
                ++i;
            }
        } else {
            IPath modRelativePath = r.getModuleRelativePath().append(r.getName());
            matches |= this.restartFilePattern.matcher(modRelativePath.toString()).find();
        }
        return matches;
    }

    private boolean testPath(String path) {
        return this.restartFilePattern.matcher(path).find();
    }

    @Override
    public boolean moduleRequiresRestart(IModule[] module, IModuleResourceDelta[] deltaToTest) {
        if (deltaToTest == null) {
            return false;
        }
        this.loadPattern();
        boolean matches = false;
        int i = 0;
        while (i < deltaToTest.length && !matches) {
            matches |= this.testDelta(deltaToTest[i]);
            ++i;
        }
        return matches;
    }

    private boolean testDelta(IModuleResourceDelta delta) {
        boolean matches = false;
        IModuleResource r = delta.getModuleResource();
        IPath modRelativePath = r.getModuleRelativePath().append(r.getName());
        String modRelativePathString = modRelativePath.toString();
        matches |= this.restartFilePattern.matcher(modRelativePathString).find();
        IModuleResourceDelta[] children = delta.getAffectedChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length && !matches) {
                matches |= this.testDelta(children[i]);
                ++i;
            }
        }
        return matches;
    }

    private void loadPattern() {
        if (this.restartFilePattern == null) {
            String currentPattern;
            String useDef = this.getServerOrWC().getAttribute(PROPERTY_USE_DEFAULT_RESTART_PATTERN, Boolean.TRUE.toString());
            if (!new Boolean(useDef).booleanValue() && (currentPattern = this.getModuleRestartPattern()) != null) {
                try {
                    this.restartFilePattern = Pattern.compile(currentPattern, 2);
                    return;
                }
                catch (PatternSyntaxException pse) {
                    JBossServerCorePlugin.log("Could not set restart file pattern to: " + currentPattern, pse);
                }
            }
            this.restartFilePattern = defaultRestartPattern;
        }
    }

    public void setModuleRestartPattern(String pattern) {
        this.getWorkingCopy().setAttribute(PROPERTY_RESTART_FILE_PATTERN, pattern);
    }

    public String getModuleRestartPattern() {
        return this.getServerOrWC().getAttribute(PROPERTY_RESTART_FILE_PATTERN, null);
    }
}

