/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.jmx.integration;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.sasl.SaslException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IJMXURLProvider;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.jmx.integration.JBossServerConnection;
import org.jboss.ide.eclipse.as.jmx.integration.JMXUtil;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.JMXException;

public class JBoss71ServerConnection
extends JBossServerConnection {
    private String user;
    private String pass;
    private Map<MBeanServerConnection, JMXConnector> connectionToConnector;

    public JBoss71ServerConnection(IServer server) {
        super(server);
    }

    @Override
    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"org.jboss.ide.eclipse.as.core.extensions.jmx.JBoss71ServerConnectionProvider");
    }

    @Override
    protected void initializeEnvironment(IServer s, String user, String pass) throws JMXUtil.CredentialException {
        this.user = user;
        this.pass = pass;
        if (this.connectionToConnector == null) {
            this.connectionToConnector = new HashMap<MBeanServerConnection, JMXConnector>();
        }
    }

    @Override
    protected boolean shouldUseDefaultCredentials() {
        return false;
    }

    protected String getUrl(IServer s) {
        JBossExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getJBossExtendedProperties((IServerAttributes)s);
        if (props != null && props instanceof IJMXURLProvider) {
            IJMXURLProvider p = (IJMXURLProvider)props;
            String url = p.getJMXUrl();
            return url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MBeanServerConnection createConnection(IServer s) throws Exception {
        String url = this.getUrl(s);
        if (url == null) {
            throw new JMXException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Unable to discover a jmx url for server " + s.getName()));
        }
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        if (this.user != null && this.pass != null) {
            environment.put("jmx.remote.credentials", new String[]{this.user, this.pass});
        }
        JMXConnector connector = null;
        try {
            connector = JMXConnectorFactory.connect(new JMXServiceURL(url), environment);
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            JBoss71ServerConnection jBoss71ServerConnection = this;
            synchronized (jBoss71ServerConnection) {
                this.connectionToConnector.put(connection, connector);
            }
            return connection;
        }
        catch (IOException ioe) {
            if (ioe instanceof SaslException) {
                Status stat = new Status(4, "org.jboss.ide.eclipse.as.core", "Authentication against the remote JBoss instance has failed. Please verify your management credentials in the server editor.", (Throwable)ioe);
                throw new JMXException((IStatus)stat);
            }
            Status stat = new Status(4, "org.jboss.ide.eclipse.as.core", "There was an error connecting to " + s.getName() + " via JMX.  Please ensure your server is up and exposes its management ports via the -Djboss.bind.address.management=yourwebsite.com launch arguments", (Throwable)ioe);
            throw new JMXException((IStatus)stat);
        }
        catch (RuntimeException re) {
            Status stat = new Status(4, "org.jboss.ide.eclipse.as.core", "Unable to reach JBoss instance. Please ensure your server is up and exposes its management ports via the -Djboss.bind.address.management=yourwebsite.com launch arguments", (Throwable)re);
            throw new JMXException((IStatus)stat);
        }
    }

    @Override
    protected void cleanupConnection(IServer server, MBeanServerConnection connection) {
        JMXConnector jmxc;
        super.cleanupConnection(server, connection);
        if (this.connectionToConnector != null && (jmxc = this.connectionToConnector.get(connection)) != null) {
            this.closeClientJoin(jmxc);
        }
    }

    @Override
    protected void connectViaJmxIfRequired(IServer server) {
        super.connectViaJmxIfRequired(server);
        if (this.connectionToConnector != null && !this.isConnected()) {
            this.closeAllConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllConnections() {
        Collection<JMXConnector> c = this.connectionToConnector.values();
        for (JMXConnector jmxc : c) {
            if (jmxc == null) continue;
            this.closeClientJoin(jmxc);
        }
        JBoss71ServerConnection jBoss71ServerConnection = this;
        synchronized (jBoss71ServerConnection) {
            this.connectionToConnector.clear();
        }
    }

    private void closeClientJoin(final JMXConnector client) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r);
        try {
            try {
                t.start();
                t.join(3000L);
            }
            catch (InterruptedException interruptedException) {
                t.interrupt();
            }
        }
        finally {
            t.interrupt();
        }
    }
}

