/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.jmx.integration;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;

public class JMXClassLoaderRepository {
    protected HashMap<String, ClassLoader> idToLoader = new HashMap();
    protected HashMap<String, ArrayList<Object>> idToConcerned = new HashMap();

    protected JMXClassLoaderRepository() {
    }

    public void addConcerned(IServer server, Object concerned) {
        ArrayList<Object> list = this.idToConcerned.get(server.getId());
        if (list == null) {
            list = new ArrayList();
            this.idToConcerned.put(server.getId(), list);
        }
        if (!list.contains(concerned)) {
            list.add(concerned);
        }
    }

    public void removeConcerned(IServer server, Object concerned) {
        ArrayList<Object> list = this.idToConcerned.get(server.getId());
        if (list != null) {
            list.remove(concerned);
            if (list.size() == 0) {
                this.idToConcerned.remove(server.getId());
                this.idToLoader.remove(server.getId());
            }
        }
    }

    public ClassLoader getClassLoader(IServer server) {
        ClassLoader loader = this.idToLoader.get(server.getId());
        if (loader == null && this.anyoneCares(server)) {
            this.loadClassLoader(server);
        }
        return this.idToLoader.get(server.getId());
    }

    protected void loadClassLoader(IServer s) {
        try {
            URLClassLoader loader = this.createClassLoader(s);
            this.idToLoader.put(s.getId(), loader);
        }
        catch (MalformedURLException murle) {
            JBossServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.loadJMXClassesFailed, (Object)s.getName()), (Throwable)murle));
        }
    }

    protected URLClassLoader createClassLoader(IServer s) throws MalformedURLException {
        IRuntime rt = s.getRuntime();
        if (rt != null) {
            IPath loc = rt.getLocation();
            URL url = loc.append("client").append("jbossall-client.jar").toFile().toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            return loader;
        }
        return null;
    }

    protected boolean anyoneCares(IServer server) {
        ArrayList<Object> list = this.idToConcerned.get(server.getId());
        return list != null && list.size() > 0;
    }
}

