/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.management.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.ide.eclipse.as.management.core.OperationRequestAddress;

public class DefaultOperationRequestAddress
implements OperationRequestAddress {
    private final List<NodeImpl> nodes = new ArrayList<NodeImpl>();

    public DefaultOperationRequestAddress() {
    }

    public DefaultOperationRequestAddress(OperationRequestAddress initial) {
        if (!initial.isEmpty()) {
            for (OperationRequestAddress.Node node : initial) {
                this.toNode(node.getType(), node.getName());
            }
        }
    }

    @Override
    public void toNodeType(String nodeType) {
        this.nodes.add(new NodeImpl(nodeType, null));
    }

    @Override
    public void toNode(String nodeName) {
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("The prefix should end with the node type before going to a specific node name.");
        }
        this.nodes.get((int)(this.nodes.size() - 1)).name = nodeName;
    }

    @Override
    public void toNode(String nodeType, String nodeName) {
        if (this.endsOnType()) {
            throw new IllegalStateException("The prefix ends on a type. A node name must be specified before this method can be invoked.");
        }
        this.nodes.add(new NodeImpl(nodeType, nodeName));
    }

    @Override
    public String toNodeType() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        String name = this.nodes.get((int)(this.nodes.size() - 1)).name;
        this.nodes.get((int)(this.nodes.size() - 1)).name = null;
        return name;
    }

    @Override
    public OperationRequestAddress.Node toParentNode() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.remove(this.nodes.size() - 1);
    }

    @Override
    public void reset() {
        this.nodes.clear();
    }

    @Override
    public boolean endsOnType() {
        if (this.nodes.isEmpty()) {
            return false;
        }
        NodeImpl node = this.nodes.get(this.nodes.size() - 1);
        return node.name == null;
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public Iterator<OperationRequestAddress.Node> iterator() {
        final OperationRequestAddress.Node[] array = this.nodes.toArray(new OperationRequestAddress.Node[this.nodes.size()]);
        return new Iterator<OperationRequestAddress.Node>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public OperationRequestAddress.Node next() {
                return array[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String getNodeType() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get((int)(this.nodes.size() - 1)).type;
    }

    @Override
    public String getNodeName() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get((int)(this.nodes.size() - 1)).name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationRequestAddress)) {
            return false;
        }
        OperationRequestAddress other = (OperationRequestAddress)obj;
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        Iterator<OperationRequestAddress.Node> thisIterator = this.iterator();
        Iterator otherIterator = other.iterator();
        boolean result = true;
        while (result) {
            if (!thisIterator.next().equals(otherIterator.next())) {
                result = false;
                continue;
            }
            if (!thisIterator.hasNext()) {
                if (!otherIterator.hasNext()) break;
                result = false;
                break;
            }
            if (otherIterator.hasNext()) continue;
            if (!thisIterator.hasNext()) break;
            result = false;
            break;
        }
        return result;
    }

    private static final class NodeImpl
    implements OperationRequestAddress.Node {
        String type;
        String name;

        NodeImpl(String type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OperationRequestAddress.Node)) {
                return false;
            }
            OperationRequestAddress.Node other = (OperationRequestAddress.Node)obj;
            if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
                return false;
            }
            return !(this.type == null ? other.getType() != null : !this.type.equals(other.getType()));
        }
    }
}

