/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.internal.management.eap61plus;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.dmr.ModelNode;
import org.jboss.ide.eclipse.as.internal.management.eap61plus.DeploymentOperationResult;
import org.jboss.ide.eclipse.as.internal.management.eap61plus.EAP61PlusManagerUtil;
import org.jboss.ide.eclipse.as.internal.management.eap61plus.Messages;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7DeploymentResult;
import org.jboss.ide.eclipse.as.management.core.JBoss7DeploymentState;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.management.core.JBoss7ServerState;

public class EAP61PlusManager {
    public static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    private ModelControllerClient client;
    private ServerDeploymentManager manager;
    private IAS7ManagementDetails details;

    public EAP61PlusManager(IAS7ManagementDetails details) throws JBoss7ManangerException {
        try {
            this.details = details;
            Object timeout = details.getProperty("PROPERTY_TIMEOUT");
            int timeout2 = !(timeout instanceof Integer) ? 5000 : (Integer)timeout;
            this.client = ModelControllerClient.Factory.create((String)details.getHost(), (int)details.getManagementPort(), (CallbackHandler)this.getCallbackHandler(), null, (int)timeout2);
            this.manager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.client);
        }
        catch (UnknownHostException uhe) {
            throw new JBoss7ManangerException((Throwable)uhe);
        }
    }

    protected CallbackHandler getCallbackHandler() {
        return new Tools71CallbackHandler();
    }

    public IJBoss7DeploymentResult undeploySync(String name, boolean removeFile, IProgressMonitor monitor) throws JBoss7ManangerException {
        String task = "Undeploy via management: " + name;
        monitor.beginTask(task, 100);
        DeploymentOperationResult result = (DeploymentOperationResult)this.undeploy(name, removeFile);
        monitor.worked(5);
        this.waitFor(result, task, (IProgressMonitor)new SubProgressMonitor(monitor, 95));
        monitor.done();
        return result;
    }

    private void waitFor(DeploymentOperationResult result, String task, IProgressMonitor monitor) throws JBoss7ManangerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        while (!monitor.isCanceled() && !result.isDone()) {
            progress.setWorkRemaining(1000);
            SubMonitor tmp = progress.newChild(1);
            tmp.beginTask("Waiting for task to complete: " + task, 1);
            tmp.worked(1);
            tmp.done();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (monitor.isCanceled()) {
            result.cancel();
            throw new JBoss7ManangerException("Operation canceled: " + task);
        }
        result.getStatus();
        monitor.done();
    }

    public IJBoss7DeploymentResult deploySync(String name, File file, boolean add, IProgressMonitor monitor) throws JBoss7ManangerException {
        String task = "Deploy via management: " + name;
        monitor.beginTask(task, 100);
        DeploymentOperationResult result = (DeploymentOperationResult)this.deploy(name, file, add);
        monitor.worked(5);
        this.waitFor(result, task, (IProgressMonitor)new SubProgressMonitor(monitor, 95));
        monitor.done();
        return result;
    }

    public IJBoss7DeploymentResult undeploy(String name, boolean removeFile) throws JBoss7ManangerException {
        try {
            Object builder = this.manager.newDeploymentPlan();
            builder = removeFile ? builder.undeploy(name).andRemoveUndeployed() : builder.undeploy(name);
            return new DeploymentOperationResult(builder.getLastAction(), this.manager.execute(builder.build()));
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public IJBoss7DeploymentResult remove(String name) throws JBoss7ManangerException {
        try {
            InitialDeploymentPlanBuilder builder = this.manager.newDeploymentPlan();
            builder = builder.remove(name);
            return new DeploymentOperationResult(builder.getLastAction(), this.manager.execute(builder.build()));
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public IJBoss7DeploymentResult deploy(File file) throws JBoss7ManangerException {
        return this.deploy(file.getName(), file, true);
    }

    public IJBoss7DeploymentResult add(String name, File file) throws JBoss7ManangerException {
        try {
            return this.execute((DeploymentPlanBuilder)this.manager.newDeploymentPlan().add(name, file));
        }
        catch (IOException e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public IJBoss7DeploymentResult deploy(String name, File file, boolean add) throws JBoss7ManangerException {
        try {
            if (add) {
                return this.execute(this.manager.newDeploymentPlan().add(name, file).andDeploy());
            }
            return this.execute(this.manager.newDeploymentPlan().deploy(name));
        }
        catch (IOException e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public IJBoss7DeploymentResult replace(File file) throws JBoss7ManangerException {
        return this.replace(file.getName(), file);
    }

    public IJBoss7DeploymentResult replace(String name, File file) throws JBoss7ManangerException {
        try {
            return this.execute(this.manager.newDeploymentPlan().replace(name, file));
        }
        catch (IOException e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public JBoss7DeploymentState getDeploymentStateSafe(String name) throws JBoss7ManangerException {
        if (!this.hasDeployment(name)) {
            return JBoss7DeploymentState.NOT_FOUND;
        }
        return this.getDeploymentState(name);
    }

    public JBoss7DeploymentState getDeploymentState(String name) throws JBoss7ManangerException {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-resource");
        request.get("address").add("deployment", name);
        ModelNode result = null;
        try {
            result = this.execute(request);
        }
        catch (JBoss7ManangerException j7me) {
            return JBoss7DeploymentState.NOT_FOUND;
        }
        Boolean enabled = EAP61PlusManagerUtil.getBooleanProperty("enabled", result);
        if (enabled == null) {
            throw new JBoss7ManangerException(NLS.bind((String)Messages.ModuleStateEvaluationFailed, (Object)name));
        }
        if (enabled.booleanValue()) {
            return JBoss7DeploymentState.STARTED;
        }
        return JBoss7DeploymentState.STOPPED;
    }

    public void stopServer() throws JBoss7ManangerException {
        ModelNode request = new ModelNode();
        request.get("operation").set("shutdown");
        this.quietlyExecute(request);
    }

    public JBoss7ServerState getServerState() throws JBoss7ManangerException {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-attribute");
        request.get("name").set("server-state");
        ModelNode response = this.execute(request);
        return this.toJBoss7ServerState(response);
    }

    public boolean isRunning() {
        try {
            return this.getServerState() == JBoss7ServerState.RUNNING;
        }
        catch (Exception e) {
            return false;
        }
    }

    private JBoss7ServerState toJBoss7ServerState(ModelNode response) throws JBoss7ManangerException {
        try {
            return JBoss7ServerState.valueOfIgnoreCase((String)response.asString());
        }
        catch (IllegalArgumentException e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public void dispose() {
        if (this.client != null) {
            this.closeClient(this.client);
        }
    }

    private void closeClient(final ModelControllerClient client) {
        Thread t = new Thread("Closing client"){

            @Override
            public void run() {
                EAP61PlusManager.this.closeClientJoin(client);
            }
        };
        t.start();
    }

    private void closeClientJoin(final ModelControllerClient client) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r);
        try {
            try {
                t.start();
                t.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                t.interrupt();
            }
        }
        finally {
            t.interrupt();
        }
    }

    ModelNode execute(ModelNode node) throws JBoss7ManangerException {
        try {
            ModelNode response = this.client.execute(node);
            if (!EAP61PlusManagerUtil.isSuccess(response)) {
                throw new JBoss7ManangerException(NLS.bind((String)Messages.OperationOnAddressFailed, (Object[])new Object[]{node.get("operation"), node.get("address"), response.get("failure-description")}));
            }
            return response.get("result");
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    private void quietlyExecute(ModelNode node) throws JBoss7ManangerException {
        block2: {
            try {
                this.client.execute(node);
            }
            catch (Exception e) {
                if (this.isConnectionCloseException(e)) break block2;
                throw new JBoss7ManangerException((Throwable)e);
            }
        }
    }

    private boolean isConnectionCloseException(Exception e) {
        return e instanceof IOException && e.getMessage() != null && e.getMessage().indexOf("Channel closed") > -1 || e.getMessage().indexOf("Operation failed") > -1;
    }

    private IJBoss7DeploymentResult execute(DeploymentPlanBuilder builder) throws JBoss7ManangerException {
        try {
            DeploymentAction action = builder.getLastAction();
            Future planResult = this.manager.execute(builder.build());
            return new DeploymentOperationResult(action, planResult);
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public static ModelNode getEmptyOperation(String operationName, ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        if (address != null) {
            op.get("address").set(address);
        } else {
            op.get("address");
        }
        return op;
    }

    public boolean hasDeployment(String name) throws JBoss7ManangerException {
        return this.getDeploymentNames().contains(name);
    }

    private Set<String> getDeploymentNames() throws JBoss7ManangerException {
        ModelNode op = EAP61PlusManager.getEmptyOperation("read-children-names", new ModelNode());
        op.get("child-type").set("deployment");
        ModelNode result = this.execute(op);
        HashSet<String> deploymentNames = new HashSet<String>();
        if (result.isDefined()) {
            List deploymentNodes = result.asList();
            for (ModelNode node : deploymentNodes) {
                deploymentNames.add(node.asString());
            }
        }
        return deploymentNames;
    }

    protected class Tools71CallbackHandler
    implements CallbackHandler {
        protected Tools71CallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                ((NameCallback)callbacks[0]).setName("anonymous JBossTools user");
                return;
            }
            NameCallback name = null;
            PasswordCallback pass = null;
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback current = callbackArray[n2];
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                }
                if (current instanceof NameCallback) {
                    name = (NameCallback)current;
                } else if (current instanceof PasswordCallback) {
                    pass = (PasswordCallback)current;
                }
                ++n2;
            }
            String[] results = EAP61PlusManager.this.details.handleCallbacks(new String[]{name.getPrompt(), pass.getPrompt()});
            if (results != null && results.length >= 2) {
                name.setName(results[0]);
                pass.setPassword(results[1].toCharArray());
            }
        }
    }
}

