/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListenerManager;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;

public class LocalBehaviorUI
implements IDeploymentTypeUI {
    private IDeploymentTypeUI.IServerModeUICallback callback;

    @Override
    public void fillComposite(Composite parent, IDeploymentTypeUI.IServerModeUICallback callback) {
        this.callback = callback;
        callback.setErrorMessage(null);
        if (callback.getCallbackType() == 2) {
            this.verify();
        }
        parent.setLayout((Layout)new FillLayout());
        Composite child = new Composite(parent, 0);
        this.addListeners(parent);
    }

    private void addListeners(Composite parent) {
        final PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (LocalBehaviorUI.this.callback.getCallbackType() == 2) {
                    LocalBehaviorUI.this.verify();
                }
            }
        };
        this.callback.getServer().addPropertyChangeListener(pcl);
        final UnitedServerListener changeToRuntimeDetailsListener = new UnitedServerListener(){

            public void runtimeChanged(IRuntime runtime) {
                if (LocalBehaviorUI.this.callback.getCallbackType() == 2) {
                    Display.getDefault().asyncExec(() -> LocalBehaviorUI.this.verify());
                }
            }

            public boolean canHandleRuntime(IRuntime runtime) {
                return runtime != null && runtime.equals(LocalBehaviorUI.this.callback.getServer().getRuntime());
            }
        };
        UnitedServerListenerManager.getDefault().addListener(changeToRuntimeDetailsListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UnitedServerListenerManager.getDefault().removeListener(changeToRuntimeDetailsListener);
                LocalBehaviorUI.this.callback.getServer().removePropertyChangeListener(pcl);
            }
        });
    }

    private void verify() {
        String behaviourType = ServerProfileModel.getProfile((IServerAttributes)this.callback.getServer());
        if (!"local".equals(behaviourType)) {
            this.callback.setErrorMessage(null);
        } else {
            ServerExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)this.callback.getServer());
            if (props != null) {
                IStatus status = props.verifyServerStructure();
                this.callback.setErrorMessage(status.isOK() ? null : status.getMessage());
            }
        }
    }
}

