/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor.ports;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Link;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.editor.ports.PortEditorXPathExtension;
import org.jboss.ide.eclipse.as.ui.editor.ports.PortSection;
import org.jboss.ide.eclipse.as.ui.editor.ports.SetPortCommand;

public class SetPortXPathCommand
extends SetPortCommand {
    String overrideAttribute;
    String overridePathAttribute;
    String defaultPath;
    boolean preOverride;
    Button button;
    String xpath;
    Link link;

    public SetPortXPathCommand(IServerWorkingCopy server, ServerAttributeHelper helper, String name, String textAttribute, String overrideAttribute, String overridePathAttribute, String pathDefault, PortEditorXPathExtension ext) {
        super(server, helper, name, textAttribute, ext);
        this.overrideAttribute = overrideAttribute;
        this.overridePathAttribute = overridePathAttribute;
        this.defaultPath = pathDefault;
        this.button = ext.detect;
        this.xpath = ext.currentXPath;
        this.link = ext.link;
    }

    @Override
    public void execute() {
        this.preText = this.helper.getAttribute(this.textAttribute, null);
        if (this.preText == null) {
            this.preText = this.text.getText();
        }
        this.prePath = this.helper.getAttribute(this.overridePathAttribute, this.defaultPath);
        this.preOverride = this.helper.getAttribute(this.overrideAttribute, true);
        this.helper.setAttribute(this.textAttribute, this.text.getText());
        this.helper.setAttribute(this.overrideAttribute, this.button.getSelection());
        this.link.setEnabled(this.button.getSelection());
        this.helper.setAttribute(this.overridePathAttribute, this.xpath);
        this.text.setEnabled(!this.button.getSelection());
        this.text.setEditable(!this.button.getSelection());
        if (this.button.getSelection()) {
            this.text.removeListener(24, this.listener);
            this.text.setText(PortSection.findPortWithDefault(this.helper.getServer(), (IPath)new Path(this.xpath), this.defVal, this.ext.discoverOffset()));
            this.text.addListener(24, this.listener);
        }
        this.validate();
    }

    @Override
    public void undo() {
        this.helper.setAttribute(this.textAttribute, this.preText);
        this.helper.setAttribute(this.overrideAttribute, this.preOverride);
        this.link.setEnabled(this.preOverride);
        this.helper.setAttribute(this.overridePathAttribute, this.prePath);
        this.text.removeListener(24, this.listener);
        this.button.removeListener(13, this.listener);
        this.button.setSelection(this.preOverride);
        this.text.setText(this.preText == null ? "" : this.preText);
        this.text.setEnabled(!this.preOverride);
        this.text.setEditable(!this.preOverride);
        this.button.addListener(13, this.listener);
        this.text.addListener(24, this.listener);
        this.validate();
    }

    private void validate() {
        this.ext.validate();
    }
}

