/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.wtp.ui.util.FormDataUtility;

public abstract class ServerTypePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected AbstractComboDataPreferenceComposite rootComp;

    public ServerTypePreferencePage() {
    }

    public ServerTypePreferencePage(String title) {
        super(title);
    }

    public ServerTypePreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected abstract Control createContents(Composite var1);

    protected void performDefaults() {
        String id = this.rootComp.getCurrentId();
        ArrayList<Object> o = new ArrayList<Object>();
        o.addAll(Arrays.asList(this.rootComp.getCurrentComboSelectionDefaultDataModel()));
        this.rootComp.cacheMap.put(id, o);
        this.rootComp.changed.add(id);
        this.rootComp.viewer.refresh();
        this.updateApplyButton();
    }

    public boolean performOk() {
        return true;
    }

    public static abstract class AbstractComboDataPreferenceComposite
    extends Composite {
        protected ArrayList<String> changed;
        protected HashMap<String, ArrayList<Object>> cacheMap;
        protected Combo combo;
        protected TreeViewer viewer;
        protected Button addButton;
        protected Button removeButton;
        protected Button moveUp;
        protected Button moveDown;

        public AbstractComboDataPreferenceComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new FormLayout());
            Label l = new Label((Composite)this, 0);
            l.setText(this.getDescriptionLabel());
            l.setLayoutData((Object)this.createFormData(0, 5, null, 0, 0, 5, 100, -5));
            this.combo = new Combo((Composite)this, 8);
            this.combo.setLayoutData((Object)this.createFormData(l, 5, null, 0, 0, 5, null, 0));
            this.combo.setItems(this.getComboItems());
            this.viewer = new TreeViewer((Composite)this);
            FormData viewerData = this.createFormData(this.combo, 5, 100, -5, 0, 5, 80, 0);
            viewerData.height = 400;
            this.viewer.getTree().setLayoutData((Object)viewerData);
            this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
            this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    this.handleViewerSelectionChanged();
                }
            });
            Composite buttonWrapper = new Composite((Composite)this, 0);
            buttonWrapper.setLayoutData((Object)this.createFormData(this.combo, 5, null, 0, this.viewer.getTree(), 5, 100, -5));
            buttonWrapper.setLayout((Layout)new GridLayout(1, true));
            this.createRightColumnButtons(buttonWrapper);
            this.combo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    this.getCurrentSelectionDataModel();
                    viewer.refresh();
                    this.updateMoveUpMoveDown();
                }
            });
            this.initializeSelection();
            this.initializeDataModel();
            this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
            this.updateMoveUpMoveDown();
        }

        protected void initializeSelection() {
            this.combo.select(0);
        }

        protected void handleViewerSelectionChanged() {
            this.updateMoveUpMoveDown();
        }

        protected void updateMoveUpMoveDown() {
            boolean enableUp = true;
            boolean enableDown = true;
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            if (sel != null) {
                if (sel.size() > 1 || sel.size() == 0) {
                    enableUp = false;
                    enableDown = false;
                }
                if (sel.getFirstElement() == null) {
                    enableDown = false;
                    enableUp = false;
                } else {
                    Object selected = sel.getFirstElement();
                    Object[] arr = this.getCurrentSelectionDataModel();
                    ArrayList<Object> asList = new ArrayList<Object>();
                    asList.addAll(Arrays.asList(arr));
                    int index = asList.indexOf(selected);
                    if (index == 0) {
                        enableUp = false;
                    }
                    if (index == arr.length - 1) {
                        enableDown = false;
                    }
                }
            }
            if (this.moveUp != null) {
                this.moveUp.setEnabled(enableUp);
            }
            if (this.moveDown != null) {
                this.moveDown.setEnabled(enableDown);
            }
        }

        protected void initializeDataModel() {
            this.cacheMap = new HashMap();
            this.changed = new ArrayList();
            this.getCurrentSelectionDataModel();
        }

        public String getDescriptionLabel() {
            return "";
        }

        protected void createRightColumnButtons(Composite c) {
            this.insertAddRemove(c);
            this.insertMoveUpDown(c);
        }

        protected void insertAddRemove(Composite c) {
            this.addButton = new Button(c, 8);
            this.addButton.setText("Add...");
            this.addButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.removeButton = new Button(c, 8);
            this.removeButton.setText("Remove");
            this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.addButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.addPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.removeButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.removePressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        protected void insertMoveUpDown(Composite c) {
            this.moveUp = new Button(c, 8);
            this.moveUp.setText("Move Up");
            this.moveUp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.moveDown = new Button(c, 8);
            this.moveDown.setText("Move down");
            this.moveDown.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.moveUp.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.moveUpPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.moveDown.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.moveDownPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        protected Object[] getCurrentSelectionDataModel() {
            return new Object[0];
        }

        protected Object[] getCurrentComboSelectionDefaultDataModel() {
            return new Object[0];
        }

        protected void addObject(Object o) {
            if (o != null) {
                String id = this.getCurrentId();
                this.cacheMap.get(id).add(o);
                if (!this.changed.contains(id)) {
                    this.changed.add(id);
                }
                this.viewer.refresh();
            }
        }

        protected void removeObject(Object o) {
            if (o != null) {
                Object nextSel;
                String id = this.getCurrentId();
                int preSelIndex = this.cacheMap.get(id).indexOf(o);
                int toSelect = preSelIndex == 0 ? 0 : preSelIndex - 1;
                this.cacheMap.get(id).remove(o);
                if (!this.changed.contains(id)) {
                    this.changed.add(id);
                }
                this.viewer.refresh();
                if (this.cacheMap.get(id).size() > 0 && (nextSel = this.cacheMap.get(id).get(toSelect)) != null) {
                    this.viewer.setSelection((ISelection)new StructuredSelection(nextSel));
                }
            }
        }

        protected void removePressed() {
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            Object o = sel.getFirstElement();
            this.removeObject(o);
        }

        protected abstract void addPressed();

        protected void moveUpPressed() {
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            Object fs = sel.getFirstElement();
            String id = this.getCurrentId();
            Object[] sets = this.getCurrentSelectionDataModel();
            ArrayList<Object> asList = new ArrayList<Object>();
            asList.addAll(Arrays.asList(sets));
            int ind = asList.indexOf(fs);
            asList.remove(ind);
            asList.add(ind - 1, fs);
            this.cacheMap.put(id, asList);
            if (!this.changed.contains(id)) {
                this.changed.add(id);
            }
            this.updateMoveUpMoveDown();
            this.viewer.refresh();
        }

        protected void moveDownPressed() {
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            Object fs = sel.getFirstElement();
            String id = this.getCurrentId();
            Object[] sets = this.getCurrentSelectionDataModel();
            ArrayList<Object> asList = new ArrayList<Object>();
            asList.addAll(Arrays.asList(sets));
            int ind = asList.indexOf(fs);
            asList.remove(ind);
            asList.add(ind + 1, fs);
            this.cacheMap.put(id, asList);
            if (!this.changed.contains(id)) {
                this.changed.add(id);
            }
            this.updateMoveUpMoveDown();
            this.viewer.refresh();
        }

        protected abstract String getAllOptionString();

        public String getCurrentId() {
            int index = this.combo.getSelectionIndex();
            if (this.showAllOption() && index == 0) {
                return this.getAllOptionString();
            }
            if (index == -1) {
                return null;
            }
            int i2 = this.showAllOption() ? index - 1 : index;
            return this.getIdAtIndex(i2);
        }

        protected abstract String getIdAtIndex(int var1);

        public ArrayList<Object> getDataForComboSelection(String id) {
            return this.cacheMap.get(id);
        }

        protected LabelProvider getLabelProvider() {
            return new LabelProvider();
        }

        protected ITreeContentProvider getContentProvider() {
            return new ITreeContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return this.getCurrentSelectionDataModel();
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getChildren(Object parentElement) {
                    return null;
                }
            };
        }

        protected boolean getAllServerTypes() {
            return true;
        }

        protected boolean showAllOption() {
            return true;
        }

        protected String[] getComboItems() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.showAllOption()) {
                list.add(0, "All Server Types");
            }
            String[] names = this.getComboItemNames();
            list.addAll(Arrays.asList(names));
            return list.toArray(new String[list.size()]);
        }

        protected abstract String[] getComboItemNames();

        private FormData createFormData(Object topStart, int topOffset, Object bottomStart, int bottomOffset, Object leftStart, int leftOffset, Object rightStart, int rightOffset) {
            return FormDataUtility.createFormData2((Object)topStart, (int)topOffset, (Object)bottomStart, (int)bottomOffset, (Object)leftStart, (int)leftOffset, (Object)rightStart, (int)rightOffset);
        }

        public String[] getChanged() {
            return this.changed.toArray(new String[this.changed.size()]);
        }

        public void clearChanged() {
            this.changed.clear();
        }
    }

    public static abstract class ServerTypePreferenceComposite
    extends AbstractComboDataPreferenceComposite {
        private IServerType[] types = null;

        public ServerTypePreferenceComposite(Composite parent, int style) {
            super(parent, style);
        }

        @Override
        protected String[] getComboItemNames() {
            IServerType[] types = this.getComboModel();
            String[] names = new String[types.length];
            int i = 0;
            while (i < types.length) {
                names[i] = types[i].getName();
                ++i;
            }
            return names;
        }

        private IServerType[] getComboModel() {
            if (this.types == null) {
                ArrayList<Object> retval = new ArrayList();
                ArrayList<IServerType> all = new ArrayList<IServerType>(Arrays.asList(ServerCore.getServerTypes()));
                if (!this.getAllServerTypes()) {
                    Iterator<IServerType> i = all.iterator();
                    while (i.hasNext()) {
                        IServerType t = i.next();
                        if (t.getId().startsWith("org.jboss.ide.eclipse.as.")) continue;
                        i.remove();
                    }
                }
                retval = all;
                Collections.sort(retval, new Comparator<IServerType>(){

                    @Override
                    public int compare(IServerType o1, IServerType o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                this.types = all.toArray(new IServerType[all.size()]);
            }
            return this.types;
        }

        @Override
        protected String getIdAtIndex(int index) {
            IServerType type = this.getComboModel()[index];
            String id = type.getId();
            return id;
        }

        @Override
        protected String getAllOptionString() {
            return "All Servers";
        }
    }
}

