/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.ui.JBossServerUIPlugin;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.dialogs.XPathDialogs;
import org.jboss.ide.eclipse.as.ui.views.server.extensions.XPathChangeValueAction;
import org.jboss.ide.eclipse.as.ui.views.server.extensions.XPathTreeContentProvider;

public class XPathActionProvider
extends CommonActionProvider {
    private ICommonActionExtensionSite actionSite;
    public Action newXPathCategoryAction;
    public Action deleteXPathCategoryAction;
    public Action newXPathAction;
    public Action editXPathAction;
    public Action deleteXPathAction;
    public Action editFileAction;
    private XPathChangeValueAction xpathChangeValueAction;
    private CommonViewer cv;
    private IDoubleClickListener doubleClickListener;

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            this.cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.createActions(this.cv, wsSite.getSelectionProvider());
            this.addDoubleClickHandler(this.cv);
        }
    }

    public void dispose() {
        super.dispose();
        this.removeDoubleClickHandler();
    }

    protected void addDoubleClickHandler(CommonViewer cv) {
        this.doubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o = XPathActionProvider.this.getSelection();
                if (o instanceof XPathFileResult.XPathResultNode || o instanceof XPathFileResult || o instanceof XPathQuery) {
                    XPathActionProvider.this.editFileAction.run();
                }
            }
        };
        cv.addDoubleClickListener(this.doubleClickListener);
    }

    protected void removeDoubleClickHandler() {
        this.cv.removeDoubleClickListener(this.doubleClickListener);
    }

    public void createActions(CommonViewer tableViewer, ISelectionProvider provider) {
        Shell shell = tableViewer.getTree().getShell();
        this.newXPathCategoryAction = new Action(){

            public void run() {
                XPathDialogs.XPathCategoryDialog d = new XPathDialogs.XPathCategoryDialog(Display.getCurrent().getActiveShell(), XPathActionProvider.this.getServer());
                if (d.open() == 0) {
                    XPathModel.getDefault().addCategory(XPathActionProvider.this.getServer(), d.getText());
                    XPathModel.getDefault().save(XPathActionProvider.this.getServer());
                    XPathActionProvider.this.refreshViewer();
                }
            }
        };
        this.newXPathCategoryAction.setText(Messages.XPathActionProvider_NewCategoryAction);
        this.deleteXPathCategoryAction = new Action(){

            public void run() {
                int style = 65728;
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), style);
                messageBox.setText(Messages.XPathActionProvider_RemoveCategoryQuestion);
                messageBox.setMessage(Messages.DescriptorXPathRemoveCategoryDesc);
                if (messageBox.open() == 64) {
                    XPathModel.getDefault().removeCategory(XPathActionProvider.this.getServer(), ((XPathCategory)XPathActionProvider.this.getSelection()).getName());
                    XPathModel.getDefault().save(XPathActionProvider.this.getServer());
                    XPathActionProvider.this.refreshViewer();
                }
            }
        };
        this.deleteXPathCategoryAction.setText(Messages.DescriptorXPathRemoveCategory);
        this.newXPathAction = new Action(){

            public void run() {
                XPathDialogs.XPathDialog d;
                XPathCategory category = null;
                Object selectedNode = XPathActionProvider.this.getSelection();
                if (selectedNode instanceof XPathCategory) {
                    category = (XPathCategory)selectedNode;
                } else if (selectedNode instanceof XPathQuery) {
                    category = ((XPathQuery)selectedNode).getCategory();
                }
                if (category != null && (d = new XPathDialogs.XPathDialog(Display.getCurrent().getActiveShell(), XPathActionProvider.this.getServer(), null)).open() == 0) {
                    XPathCategory[] categoryList = XPathModel.getDefault().getCategories(XPathActionProvider.this.getServer());
                    XPathCategory categoryItem = null;
                    int i = 0;
                    while (i < categoryList.length) {
                        if (categoryList[i].getName().equals(category.getName())) {
                            categoryItem = categoryList[i];
                        }
                        ++i;
                    }
                    if (categoryItem != null) {
                        XPathQuery query = new XPathQuery(categoryItem.getServer(), d.getName(), d.getBaseDir(), d.getFilePattern(), d.getXpath(), d.getAttribute());
                        categoryItem.addQuery(query);
                        XPathModel.getDefault().save(XPathActionProvider.this.getServer());
                        XPathActionProvider.this.refreshViewer();
                    }
                }
            }
        };
        this.newXPathAction.setText(Messages.DescriptorXPathNewXPath);
        this.editXPathAction = new Action(){

            public void run() {
                Object o = XPathActionProvider.this.getSelection();
                if (o != null && o instanceof XPathQuery) {
                    XPathQuery original = (XPathQuery)o;
                    XPathCategory category = original.getCategory();
                    XPathDialogs.XPathDialog d = new XPathDialogs.XPathDialog(Display.getCurrent().getActiveShell(), XPathActionProvider.this.getServer(), original);
                    if (d.open() == 0) {
                        original.setAttribute(d.getAttribute());
                        original.setXpathPattern(d.getXpath());
                        original.setName(d.getName());
                        original.setBaseDir(d.getBaseDir());
                        original.setFilePattern(d.getFilePattern());
                        category.save();
                        XPathActionProvider.this.refreshViewer();
                    }
                }
            }
        };
        this.editXPathAction.setText(Messages.DescriptorXPathEditXPath);
        this.deleteXPathAction = new Action(){

            public void run() {
                Object o = XPathActionProvider.this.getSelection();
                if (o instanceof XPathQuery) {
                    XPathCategory cat = ((XPathQuery)o).getCategory();
                    cat.removeQuery((XPathQuery)o);
                    cat.save();
                    XPathActionProvider.this.refreshViewer();
                }
            }
        };
        this.deleteXPathAction.setText(Messages.DescriptorXPathDeleteXPath);
        this.editFileAction = new Action(){

            public void run() {
                try {
                    Object o = XPathActionProvider.this.getSelection();
                    Path p = null;
                    if (o instanceof XPathQuery && ((XPathQuery)o).getResults().length == 1) {
                        o = ((XPathQuery)o).getResults()[0];
                    }
                    if (o instanceof XPathFileResult) {
                        p = new Path(((XPathFileResult)o).getFileLocation());
                    } else if (o instanceof XPathFileResult.XPathResultNode) {
                        p = new Path(((XPathFileResult.XPathResultNode)o).getFileLocation());
                    }
                    if (p != null) {
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore(p.removeLastSegments(1));
                        fileStore = fileStore.getChild(p.lastSegment());
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                        IWorkbenchPage page = win.getActivePage();
                        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                            try {
                                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                            }
                            catch (PartInitException partInitException) {}
                        }
                    }
                }
                catch (Exception exc) {
                    JBossServerUIPlugin.log(Messages.XPathActionProvider_ErrorRunningAction, exc);
                }
            }
        };
        this.editFileAction.setText(Messages.XPathActionProvider_EditFileAction);
        this.xpathChangeValueAction = new XPathChangeValueAction(shell, (TreeViewer)tableViewer, provider);
    }

    protected Object getSelection() {
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
            Object first = selection.getFirstElement();
            return first;
        }
        return null;
    }

    public void fillContextMenu(IMenuManager menu) {
        Object first = this.getSelection();
        if (first == null) {
            return;
        }
        if (first instanceof XPathTreeContentProvider.ServerWrapper) {
            menu.add((IAction)this.newXPathCategoryAction);
            menu.add((IContributionItem)new Separator());
            return;
        }
        if (first instanceof XPathCategory) {
            menu.add((IAction)this.newXPathAction);
            menu.add((IAction)this.deleteXPathCategoryAction);
            menu.add((IContributionItem)new Separator());
            return;
        }
        if (first instanceof XPathQuery) {
            menu.add((IAction)this.newXPathAction);
            menu.add((IAction)this.editXPathAction);
            menu.add((IAction)this.deleteXPathAction);
        }
        if (this.xpathChangeValueAction.shouldRun()) {
            menu.add((IAction)this.xpathChangeValueAction);
        }
        if (first instanceof XPathFileResult.XPathResultNode || first instanceof XPathFileResult || first instanceof XPathQuery && ((XPathQuery)first).getResults().length == 1) {
            menu.add((IAction)this.editFileAction);
        }
    }

    protected void refreshViewer() {
        this.actionSite.getStructuredViewer().refresh();
    }

    protected IServer getServer() {
        Object o = this.getSelection();
        if (o instanceof XPathTreeContentProvider.ServerWrapper) {
            return ((XPathTreeContentProvider.ServerWrapper)o).server;
        }
        if (o instanceof XPathCategory) {
            return ((XPathCategory)o).getServer();
        }
        if (o instanceof XPathQuery) {
            return ((XPathQuery)o).getCategory().getServer();
        }
        if (o instanceof XPathFileResult) {
            return ((XPathFileResult)o).getQuery().getCategory().getServer();
        }
        if (o instanceof XPathFileResult.XPathResultNode) {
            return ((XPathFileResult.XPathResultNode)o).getFile().getQuery().getCategory().getServer();
        }
        return null;
    }
}

