/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class UnitedServerListenerManager
implements IServerLifecycleListener,
IServerListener,
IPublishListener,
IRuntimeLifecycleListener {
    protected CopyOnWriteArrayList<UnitedServerListener> list = new CopyOnWriteArrayList();
    private boolean delegatesInitialized = false;

    public static UnitedServerListenerManager getDefault() {
        return SingletonHolder.instance;
    }

    private UnitedServerListenerManager() {
        new Thread(){

            @Override
            public void run() {
                UnitedServerListenerManager.this.initializeManager();
            }
        }.start();
    }

    private void initializeManager() {
        IServer[] allServers = ServerCore.getServers();
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this);
        int i = 0;
        while (i < allServers.length) {
            this.protectAddManagerAsListeners(allServers[i]);
            ++i;
        }
        this.initializeCurrentListeners();
    }

    @Deprecated
    public synchronized UnitedServerListener[] getListeners() {
        return this.list.toArray(new UnitedServerListener[this.list.size()]);
    }

    public static boolean isJBossServer(IServer server) {
        return ServerConverter.getJBossServer(server) != null;
    }

    private synchronized boolean isDelegatesInitialized() {
        return this.delegatesInitialized;
    }

    private synchronized void setDelegatesInitialized(boolean val) {
        this.delegatesInitialized = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UnitedServerListener listener) {
        boolean requiresInit = false;
        UnitedServerListenerManager unitedServerListenerManager = this;
        synchronized (unitedServerListenerManager) {
            if (!this.list.contains(listener)) {
                requiresInit = this.isDelegatesInitialized();
                this.list.add(listener);
            }
        }
        if (requiresInit) {
            this.initializeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initializeCurrentListeners() {
        it = null;
        var2_2 = this;
        synchronized (var2_2) {
            it = this.list.iterator();
            this.setDelegatesInitialized(true);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl13
        }
        do {
            this.initializeListener(it.next());
lbl13:
            // 2 sources

        } while (it.hasNext());
    }

    private void initializeListener(UnitedServerListener listener) {
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            listener.init(allServers[i]);
            ++i;
        }
    }

    public void removeListener(UnitedServerListener listener) {
        this.list.remove(listener);
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            listener.cleanUp(allServers[i]);
            ++i;
        }
    }

    private synchronized void protectAddManagerAsListeners(IServer server) {
        server.removeServerListener((IServerListener)this);
        server.removePublishListener((IPublishListener)this);
        server.addServerListener((IServerListener)this);
        server.addPublishListener((IPublishListener)this);
    }

    public void serverAdded(IServer server) {
        this.protectAddManagerAsListeners(server);
        for (UnitedServerListener working : this.list) {
            if (!working.canHandleServer(server)) continue;
            working.serverAdded(server);
        }
    }

    public void serverChanged(IServer server) {
        for (UnitedServerListener working : this.list) {
            if (!working.canHandleServer(server)) continue;
            working.serverChanged(server);
        }
    }

    public void serverRemoved(IServer server) {
        server.removeServerListener((IServerListener)this);
        server.removePublishListener((IPublishListener)this);
        for (UnitedServerListener working : this.list) {
            if (!working.canHandleServer(server)) continue;
            working.serverRemoved(server);
        }
    }

    public void serverChanged(ServerEvent event) {
        IServer server = event.getServer();
        for (UnitedServerListener working : this.list) {
            if (!working.canHandleServer(server)) continue;
            working.serverChanged(event);
        }
    }

    public void publishStarted(IServer server) {
        for (UnitedServerListener working : this.list) {
            if (!working.canHandleServer(server)) continue;
            working.publishStarted(server);
        }
    }

    public void publishFinished(IServer server, IStatus status) {
        for (UnitedServerListener working : this.list) {
            if (!working.canHandleServer(server)) continue;
            working.publishFinished(server, status);
        }
    }

    public void runtimeAdded(IRuntime runtime) {
        for (UnitedServerListener working : this.list) {
            if (!working.canHandleRuntime(runtime)) continue;
            working.runtimeAdded(runtime);
        }
    }

    public void runtimeChanged(IRuntime runtime) {
        for (UnitedServerListener working : this.list) {
            if (!working.canHandleRuntime(runtime)) continue;
            working.runtimeChanged(runtime);
        }
    }

    public void runtimeRemoved(IRuntime runtime) {
        for (UnitedServerListener working : this.list) {
            if (!working.canHandleRuntime(runtime)) continue;
            working.runtimeRemoved(runtime);
        }
    }

    /* synthetic */ UnitedServerListenerManager(UnitedServerListenerManager unitedServerListenerManager) {
        this();
    }

    static class SingletonHolder {
        static UnitedServerListenerManager instance = new UnitedServerListenerManager(null);

        SingletonHolder() {
        }
    }
}

