/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.internal.core.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.internal.core.impl.BatchProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;

public class BatchProjectFactory {
    private static final String MODEL_ID = "Batch";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchProject getBatchProject(IProject project, boolean resolve) {
        BatchProject result = null;
        KbProject kb = (KbProject)KbProjectFactory.getKbProject((IProject)project, (boolean)resolve);
        if (kb != null) {
            KbProject kbProject = kb;
            synchronized (kbProject) {
                result = (BatchProject)kb.getExtensionModel(MODEL_ID);
                if (result == null) {
                    result = new BatchProject();
                    result.setProject(project);
                    kb.setExtensionModel(MODEL_ID, (Object)result);
                }
            }
        }
        if (result != null && resolve) {
            result.resolve();
        }
        return result;
    }

    public static IBatchProject getBatchProjectWithProgress(final IProject project) {
        BatchProject batch = BatchProjectFactory.getBatchProject(project, false);
        if (batch != null && !batch.isStorageResolved()) {
            if (Display.getCurrent() != null) {
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Building batch project", 10);
                            monitor.worked(3);
                            BatchProjectFactory.getBatchProject(project, true);
                            monitor.worked(7);
                        }
                    });
                }
                catch (InterruptedException ie) {
                    BatchCorePlugin.pluginLog().logError((Throwable)ie);
                }
                catch (InvocationTargetException ite) {
                    BatchCorePlugin.pluginLog().logError((Throwable)ite);
                }
            } else {
                BatchProjectFactory.getBatchProject(project, true);
            }
        }
        return batch;
    }
}

