/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui;

import java.text.MessageFormat;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.browsersim.ui.CustomMessageBox;
import org.jboss.tools.browsersim.ui.Messages;
import org.jboss.tools.browsersim.ui.model.TruncateWindow;

public class SizeWarningDialog
extends CustomMessageBox {
    private Point actualSize;
    private Point requiredSize;
    private String deviceName;
    private boolean vertical;
    private TruncateWindow truncateWindow = TruncateWindow.NEVER_TRUNCATE;
    private boolean rememberDecision = false;

    public SizeWarningDialog(Shell parent, Point actualSize, Point requiredSize, String deviceName, boolean vertical) {
        super(parent, parent.getDisplay().getSystemImage(2));
        this.actualSize = actualSize;
        this.requiredSize = requiredSize;
        this.deviceName = deviceName;
        this.vertical = vertical;
        this.setText(Messages.SizeWarningDialog_DEVICE_SIZE_WILL_BE_TRUNCATED);
    }

    @Override
    protected void createWidgets() {
        super.createWidgets();
        Composite messageRow = new Composite(this.getMessageComposite(), 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.spacing = 12;
        messageRow.setLayout((Layout)rowLayout);
        messageRow.setBackground(this.getMessageCompositeBackground());
        Label message = new Label(messageRow, 64);
        String messageText = this.vertical ? MessageFormat.format(Messages.SizeWarningDialog_DESKTOP_SIZE_TOO_SMALL_VERTICAL, this.actualSize.x, this.actualSize.y, this.deviceName, this.requiredSize.x, this.requiredSize.y) : MessageFormat.format(Messages.SizeWarningDialog_DESKTOP_SIZE_TOO_SMALL_HORIZONTAL, this.actualSize.x, this.actualSize.y, this.deviceName, this.requiredSize.x, this.requiredSize.y);
        message.setText(messageText);
        message.setBackground(this.getMessageCompositeBackground());
        Button rememberDecisionCheckbox = new Button(messageRow, 32);
        rememberDecisionCheckbox.setText(Messages.SizeWarningDialog_REMEMBER_MY_DECISION);
        rememberDecisionCheckbox.setBackground(this.getMessageCompositeBackground());
        rememberDecisionCheckbox.setSelection(this.rememberDecision);
        rememberDecisionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SizeWarningDialog.this.rememberDecision = ((Button)e.widget).getSelection();
            }
        });
        Composite buttonRow = new Composite(this.getButtonsComposite(), 0);
        buttonRow.setLayout((Layout)new RowLayout(256));
        GridData buttonRowLayoutData = new GridData(0x1000008, 0x1000000, true, true);
        buttonRow.setLayoutData((Object)buttonRowLayoutData);
        Button okButton = new Button(buttonRow, 8);
        okButton.setText(Messages.SizeWarningDialog_OK);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SizeWarningDialog.this.truncateWindow = TruncateWindow.ALWAYS_TRUNCATE;
                SizeWarningDialog.this.getShell().close();
            }
        });
        Button noButton = new Button(buttonRow, 8);
        noButton.setText(Messages.SizeWarningDialog_CANCEL);
        noButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SizeWarningDialog.this.getShell().close();
            }
        });
        this.getShell().setDefaultButton(okButton);
        this.getShell().pack();
    }

    public TruncateWindow getTruncateWindow() {
        return this.truncateWindow;
    }

    public boolean getRememberDecision() {
        return this.rememberDecision;
    }
}

