/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.browsersim.ui.skin.NativeSkin;
import org.jboss.tools.browsersim.ui.skin.android.GalaxyNote2Skin;
import org.jboss.tools.browsersim.ui.skin.android.GalaxyS3Skin;
import org.jboss.tools.browsersim.ui.skin.ios.AppleIPadMiniResizableSkin;
import org.jboss.tools.browsersim.ui.skin.ios.AppleIPadResizableSkin;
import org.jboss.tools.browsersim.ui.skin.ios.AppleIPhone3ResizableSkin;
import org.jboss.tools.browsersim.ui.skin.ios.AppleIPhone4ResizableSkin;
import org.jboss.tools.browsersim.ui.skin.ios.AppleIPhone6ResizableSkin;

public class SkinMap {
    public static final Class<? extends BrowserSimSkin> DEFAULT_SKIN_CLASS = NativeSkin.class;
    private static SkinMap instance;
    private Map<String, Class<? extends BrowserSimSkin>> map = new HashMap<String, Class<? extends BrowserSimSkin>>();

    private SkinMap() {
        this.map.put("iPhone 3", AppleIPhone3ResizableSkin.class);
        this.map.put("iPhone 4", AppleIPhone4ResizableSkin.class);
        this.map.put("Galaxy Note II", GalaxyNote2Skin.class);
        this.map.put("Galaxy S III", GalaxyS3Skin.class);
        this.map.put("iPad", AppleIPadResizableSkin.class);
        this.map.put("iPad mini", AppleIPadMiniResizableSkin.class);
        this.map.put("iPhone 6", AppleIPhone6ResizableSkin.class);
    }

    public static SkinMap getInstance() {
        if (instance == null) {
            instance = new SkinMap();
        }
        return instance;
    }

    public Class<? extends BrowserSimSkin> getSkinClass(String skinId) {
        Class<? extends BrowserSimSkin> skinClass = this.map.get(skinId);
        if (skinClass == null) {
            skinClass = DEFAULT_SKIN_CLASS;
        }
        return skinClass;
    }

    public Set<String> getSkinIds() {
        return this.map.keySet();
    }
}

