/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.browsersim.ui.BrowserSimLogger;
import org.jboss.tools.browsersim.ui.util.BrowserSimUtil;

public class JavaFXUtil {
    private static List<String> getJavaFXLibrariesPath(String javaHome) {
        ArrayList<String> libsPaths = new ArrayList<String>();
        libsPaths.add(String.valueOf(javaHome) + File.separator + "lib" + File.separator + "jfxrt.jar");
        libsPaths.add(String.valueOf(javaHome) + File.separator + "lib" + File.separator + "jfxswt.jar");
        libsPaths.add(String.valueOf(javaHome) + File.separator + "lib" + File.separator + "ext" + File.separator + "jfxrt.jar");
        return libsPaths;
    }

    public static boolean loadJavaFX() {
        return JavaFXUtil.loadJavaFX(System.getProperty("java.home"));
    }

    public static boolean loadJavaFX(String javaHome) {
        boolean loaded = false;
        for (String libPath : JavaFXUtil.getJavaFXLibrariesPath(javaHome)) {
            File lib = new File(libPath);
            if (!lib.exists()) continue;
            JavaFXUtil.loadJar(lib);
            loaded = true;
        }
        return loaded;
    }

    public static boolean isJavaFXAvailable() {
        return JavaFXUtil.isJavaFXAvailable(System.getProperty("java.home"));
    }

    public static boolean isJavaFXAvailable(String javaHome) {
        for (String libPath : JavaFXUtil.getJavaFXLibrariesPath(javaHome)) {
            File lib = new File(libPath);
            if (!lib.exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean isJavaFX8OrHigher() {
        String javaHome = System.getProperty("java.home");
        return new File(String.valueOf(javaHome) + File.separator + "lib" + File.separator + "jfxswt.jar").exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadMock(String tempDir, String jarName) {
        InputStream inputStream = null;
        try {
            try {
                inputStream = BrowserSimUtil.class.getClassLoader().getResourceAsStream(jarName);
                Path tmpFile = Paths.get(tempDir, jarName);
                Files.copy(inputStream, tmpFile, new CopyOption[0]);
                JavaFXUtil.loadJar(tmpFile.toFile());
                return;
            }
            catch (FileNotFoundException e) {
                BrowserSimLogger.logError(e.getMessage(), e);
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e2) {
                    BrowserSimLogger.logError(e2.getMessage(), e2);
                }
                return;
            }
            catch (IOException e) {
                BrowserSimLogger.logError(e.getMessage(), e);
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e3) {
                    BrowserSimLogger.logError(e3.getMessage(), e3);
                }
                return;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    BrowserSimLogger.logError(e.getMessage(), e);
                }
            }
        }
    }

    private static void loadJar(File file) {
        try {
            URL u = file.toURI().toURL();
            URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            BrowserSimLogger.logError("Unable to add " + file.getName() + " to classpath.", t);
        }
    }
}

