/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.browsersim.ui.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.browsersim.browser.IBrowser;
import org.jboss.tools.browsersim.ui.Messages;

public final class LiveReloadUtil {
    private LiveReloadUtil() {
    }

    public static void injectScript(IBrowser browser, int port, boolean isJavaFX) {
        if (browser != null && !browser.isDisposed()) {
            String script = LiveReloadUtil.generateScript(port, isJavaFX);
            browser.execute(script);
        }
    }

    public static boolean isLivereloadAvailable(int port) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            URL url = new URL("http://localhost:" + port + "/livereload.js");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(1000);
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void showLivereloadError(String message, Shell shell) {
        MessageBox warning = new MessageBox(shell, 8);
        warning.setText(Messages.WARNING);
        warning.setMessage(message);
        warning.open();
    }

    private static String generateScript(int port, boolean isJavaFX) {
        StringBuilder script = new StringBuilder();
        String injection = "var e = document.createElement('script');e.type = 'text/javascript';e.async = 'true';e.src = 'http://localhost:" + port + "/livereload.js';" + "document.head.appendChild(e);";
        if (isJavaFX) {
            script.append("if (!window.LiveReload) {").append(injection).append("}");
        } else {
            script.append("if (!window.LiveReload) {").append("window.addEventListener('load', function() {").append(injection).append("});").append("}");
        }
        return script.toString();
    }
}

