/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.cdi.core.CDICoreBuilder;
import org.jboss.tools.cdi.core.CDICoreMessages;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanField;
import org.jboss.tools.cdi.core.IBeanMember;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IDecorator;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInjectionPointParameter;
import org.jboss.tools.cdi.core.IInterceptor;
import org.jboss.tools.cdi.core.IInterceptorBinded;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IInterceptorBindingDeclaration;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IScopeDeclaration;
import org.jboss.tools.cdi.core.IScoped;
import org.jboss.tools.cdi.core.ISessionBean;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.core.IStereotyped;
import org.jboss.tools.cdi.internal.core.impl.CDIProjectAsYouType;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.project.facet.CDIFacetInstallDelegate;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IAnnotationType;
import org.jboss.tools.common.java.IJavaReference;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.zip.UnzipOperation;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.osgi.framework.Bundle;

public class CDIUtil {
    private static File TEMPLATE_FOLDER;
    private static final String BEANS_XML_1_0_TEMPLATE_NAME = "beans.xml";
    private static final String BEANS_XML_1_1_TEMPLATE_NAME = "beans11.xml";
    private static final String BEANS_XML_2_0_TEMPLATE_NAME = "beans20.xml";
    private static final String BEANS_XML_FILE_NAME = "beans.xml";

    public static void enableCDI(IProject project, IProgressMonitor monitor) {
        CDIUtil.enableCDI(project, null, monitor);
    }

    public static void enableCDI(IProject project, boolean generateBeansXml, IProgressMonitor monitor) {
        CDIUtil.enableCDI(project, generateBeansXml ? CDIVersion.getLatestDefaultVersion() : null, monitor);
    }

    public static void enableCDI(IProject project, CDIVersion beansXmlVersion, IProgressMonitor monitor) {
        try {
            IProject[] ps;
            WebModelPlugin.addNatureToProjectWithValidationSupport((IProject)project, (String)KbBuilder.BUILDER_ID, (String)"org.jboss.tools.jst.web.kb.kbnature");
            WebModelPlugin.addNatureToProjectWithValidationSupport((IProject)project, (String)CDICoreBuilder.BUILDER_ID, (String)CDICoreNature.NATURE_ID);
            if (beansXmlVersion != null) {
                File beansXml = CDIUtil.getBeansXml(project);
                if (beansXml != null && !beansXml.exists()) {
                    beansXml.getParentFile().mkdir();
                    String templateName = null;
                    templateName = beansXmlVersion == CDIVersion.CDI_1_0 ? "beans.xml" : (beansXmlVersion == CDIVersion.CDI_2_0 ? BEANS_XML_2_0_TEMPLATE_NAME : BEANS_XML_1_1_TEMPLATE_NAME);
                    try {
                        FileUtils.getFileUtils().copyFile(new File(CDIUtil.getTemplatesFolder(), templateName), beansXml, null, false, false);
                    }
                    catch (IOException e) {
                        CDICorePlugin.getDefault().logError(e);
                    }
                }
                project.refreshLocal(2, monitor);
            }
            IProject[] iProjectArray = ps = project.getWorkspace().getRoot().getProjects();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                CDICoreNature n3 = CDICorePlugin.getCDI(p, false);
                if (n3 != null && n3.isStorageResolved()) {
                    n3.getClassPath().validateProjectDependencies();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    public static void disableCDI(IProject project) {
        try {
            EclipseUtil.removeNatureFromProject((IProject)project, (String)CDICoreNature.NATURE_ID);
            CDICoreValidator.cleanProject(project);
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    public static File getTemplatesFolder() throws IOException {
        if (TEMPLATE_FOLDER == null) {
            Bundle bundle = CDICorePlugin.getDefault().getBundle();
            String version = bundle.getVersion().toString();
            IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
            File templatesDir = FileLocator.getBundleFile((Bundle)bundle);
            if (templatesDir.isFile()) {
                File toCopy = new File(stateLocation.toFile(), version);
                if (!toCopy.exists()) {
                    toCopy.mkdirs();
                    UnzipOperation unZip = new UnzipOperation(templatesDir.getAbsolutePath());
                    unZip.execute(toCopy, "templates.*");
                }
                templatesDir = toCopy;
            }
            TEMPLATE_FOLDER = new File(templatesDir, "templates");
        }
        return TEMPLATE_FOLDER;
    }

    public static File getBeansXml(IProject project) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject != null) {
            IProjectFacetVersion webVersion = facetedProject.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
            if (webVersion != null) {
                IContainer webInfFolder;
                IVirtualFolder webInf;
                IVirtualComponent com = ComponentCore.createComponent((IProject)project);
                if (com != null && com.getRootFolder() != null && (webInf = com.getRootFolder().getFolder((IPath)new Path("/WEB-INF"))) != null && (webInfFolder = webInf.getUnderlyingFolder()).isAccessible()) {
                    File file = new File(webInfFolder.getLocation().toFile(), "beans.xml");
                    return file;
                }
            } else if (facetedProject.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jst.java")) != null) {
                Set sources = EclipseResourceUtil.getSourceFolders((IProject)project);
                if (sources.size() == 1) {
                    return new File(((IFolder)sources.iterator().next()).getLocation().toFile(), "META-INF/beans.xml");
                }
                for (IFolder src : sources) {
                    IFolder metaInf = src.getFolder("META-INF");
                    if (metaInf == null || !metaInf.isAccessible()) continue;
                    return new File(metaInf.getLocation().toFile(), "beans.xml");
                }
            }
        }
        return null;
    }

    public static IInjectionPoint findInjectionPoint(Collection<IBean> beans, IJavaElement element, int position) {
        if (!(element instanceof IField || element instanceof IMethod || element instanceof ILocalVariable)) {
            return null;
        }
        for (IBean bean : beans) {
            Collection<IInjectionPoint> injectionPoints = bean.getInjectionPoints();
            for (IInjectionPoint iPoint : injectionPoints) {
                if (element != null && iPoint.isDeclaredFor(element)) {
                    return iPoint;
                }
                if (!(iPoint instanceof IInjectionPointParameter) || position == 0 || iPoint.getStartPosition() > position || iPoint.getStartPosition() + iPoint.getLength() < position) continue;
                return iPoint;
            }
        }
        return null;
    }

    public static List<IBean> sortBeans(Collection<IBean> beans) {
        TreeMap<String, IBean> alternativeBeans = new TreeMap<String, IBean>();
        TreeMap<String, IBean> selectedAlternativeBeans = new TreeMap<String, IBean>();
        TreeMap<String, IBean> nonAlternativeBeans = new TreeMap<String, IBean>();
        TreeMap<String, IBean> decorators = new TreeMap<String, IBean>();
        TreeMap<String, IBean> interceptors = new TreeMap<String, IBean>();
        for (IBean bean : beans) {
            if (bean.isSelectedAlternative()) {
                selectedAlternativeBeans.put(bean.getElementName(), bean);
                continue;
            }
            if (bean.isAlternative()) {
                alternativeBeans.put(bean.getElementName(), bean);
                continue;
            }
            if (bean instanceof IDecorator) {
                decorators.put(bean.getElementName(), bean);
                continue;
            }
            if (bean instanceof IInterceptor) {
                interceptors.put(bean.getElementName(), bean);
                continue;
            }
            nonAlternativeBeans.put(bean.getElementName(), bean);
        }
        ArrayList<IBean> sortedBeans = new ArrayList<IBean>();
        sortedBeans.addAll(selectedAlternativeBeans.values());
        sortedBeans.addAll(nonAlternativeBeans.values());
        sortedBeans.addAll(alternativeBeans.values());
        sortedBeans.addAll(decorators.values());
        sortedBeans.addAll(interceptors.values());
        return sortedBeans;
    }

    public static IAnnotationDeclaration getDifferentScopeDeclarationThanDepentend(IScoped scoped) {
        return CDIUtil.getAnotherScopeDeclaration(scoped, "javax.enterprise.context.Dependent");
    }

    public static IAnnotationDeclaration getDifferentScopeDeclarationThanApplicationScoped(IScoped scoped) {
        return CDIUtil.getAnotherScopeDeclaration(scoped, "javax.enterprise.context.ApplicationScoped");
    }

    public static IAnnotationDeclaration getAnotherScopeDeclaration(IScoped scoped, String scopeTypeName) {
        IScope scope = scoped.getScope();
        if (scope == null) {
            return null;
        }
        if (!scopeTypeName.equals(scope.getSourceType().getFullyQualifiedName())) {
            Collection<IScopeDeclaration> scopeDeclarations = scoped.getScopeDeclarations();
            if (!scopeDeclarations.isEmpty()) {
                return scopeDeclarations.iterator().next();
            }
            if (scoped instanceof IStereotyped) {
                Collection<IStereotypeDeclaration> stereoTypeDeclarations = ((IStereotyped)((Object)scoped)).getStereotypeDeclarations();
                for (IStereotypeDeclaration stereotypeDeclaration : stereoTypeDeclarations) {
                    IStereotype stereotype = stereotypeDeclaration.getStereotype();
                    IScope stereotypeScope = stereotype.getScope();
                    if (stereotypeScope == null || scopeTypeName.equals(stereotypeScope.getSourceType().getFullyQualifiedName())) continue;
                    return stereotypeDeclaration;
                }
            }
        }
        return null;
    }

    public static IAnnotationDeclaration getScopeDeclaration(IBean bean, String scopeTypeName) {
        IScope scope = bean.getScope();
        if (scopeTypeName.equals(scope.getSourceType().getFullyQualifiedName())) {
            Collection<IScopeDeclaration> scopeDeclarations = bean.getScopeDeclarations();
            for (IScopeDeclaration scopeDeclaration : scopeDeclarations) {
                if (!scopeTypeName.equals(scopeDeclaration.getScope().getSourceType().getFullyQualifiedName())) continue;
                return scopeDeclaration;
            }
            Collection<IStereotypeDeclaration> stereoTypeDeclarations = bean.getStereotypeDeclarations();
            for (IStereotypeDeclaration stereotypeDeclaration : stereoTypeDeclarations) {
                IScope stereotypeScope = stereotypeDeclaration.getStereotype().getScope();
                if (stereotypeScope == null || !scopeTypeName.equals(stereotypeScope.getSourceType().getFullyQualifiedName())) continue;
                return stereotypeDeclaration;
            }
        }
        return null;
    }

    public static IAnnotationDeclaration getAnnotationDeclaration(IAnnotated annotated, ICDIAnnotation annotation) {
        List annotations = annotated.getAnnotations();
        for (IAnnotationDeclaration annotationDeclaration : annotations) {
            IAnnotationType annotationElement = annotationDeclaration.getAnnotation();
            if (annotationElement == null || !annotation.equals(annotationElement)) continue;
            return annotationDeclaration;
        }
        if (annotated instanceof IStereotyped) {
            Collection<IStereotypeDeclaration> stereoTypeDeclarations = ((IStereotyped)annotated).getStereotypeDeclarations();
            for (IStereotypeDeclaration stereotypeDeclaration : stereoTypeDeclarations) {
                if (CDIUtil.getAnnotationDeclaration((IAnnotated)stereotypeDeclaration.getStereotype(), annotation) == null) continue;
                return stereotypeDeclaration;
            }
        }
        return null;
    }

    public static IAnnotationDeclaration getAnnotationDeclaration(IAnnotated element, String annotationTypeName) {
        List declarations = element.getAnnotations();
        for (IAnnotationDeclaration declaration : declarations) {
            IAnnotationDeclaration decl;
            IAnnotationType type = declaration.getAnnotation();
            if (type == null) continue;
            if (annotationTypeName.equals(type.getSourceType().getFullyQualifiedName())) {
                return declaration;
            }
            if (!(type instanceof IAnnotated) || (decl = CDIUtil.getAnnotationDeclaration((IAnnotated)type, annotationTypeName)) == null) continue;
            return decl;
        }
        return null;
    }

    public static IAnnotationDeclaration getNamedDeclaration(IBean bean) {
        return CDIUtil.getQualifierDeclaration(bean, "javax.inject.Named");
    }

    public static IAnnotationDeclaration getQualifierDeclaration(IBean bean, String qualifierTypeName) {
        IAnnotationDeclaration declaration = CDIUtil.getQualifiedStereotypeDeclaration(bean, qualifierTypeName);
        if (declaration == null) {
            declaration = CDIUtil.getQualifiedSpecializesDeclaration(bean, qualifierTypeName);
        }
        return declaration;
    }

    public static IAnnotationDeclaration getQualifiedSpecializesDeclaration(IBean bean, String qualifierTypeName) {
        IBean specializedBean = bean.getSpecializedBean();
        return specializedBean != null ? CDIUtil.getQualifierDeclaration(specializedBean, qualifierTypeName) : null;
    }

    public static IAnnotationDeclaration getQualifiedStereotypeDeclaration(IStereotyped stereotyped, String qualifierTypeName) {
        IAnnotationDeclaration qualifierDeclaration = stereotyped.getAnnotation(qualifierTypeName);
        if (qualifierDeclaration != null) {
            return qualifierDeclaration;
        }
        Collection<IStereotypeDeclaration> stereotypeDeclarations = stereotyped.getStereotypeDeclarations();
        for (IStereotypeDeclaration declaration : stereotypeDeclarations) {
            if (CDIUtil.getQualifiedStereotypeDeclaration(declaration.getStereotype(), qualifierTypeName) == null) continue;
            return declaration;
        }
        return null;
    }

    public static IAnnotationDeclaration getNamedStereotypeDeclaration(IStereotyped stereotyped) {
        return CDIUtil.getQualifiedStereotypeDeclaration(stereotyped, "javax.inject.Named");
    }

    public static Collection<ITextSourceReference> getAnnotationPossitions(IBeanMethod method, String annotationTypeName) {
        List<IParameter> params = method.getParameters();
        HashSet<ITextSourceReference> declarations = new HashSet<ITextSourceReference>();
        for (IParameter param : params) {
            IJavaSourceReference declaration = param.getAnnotationPosition(annotationTypeName);
            if (declaration == null) continue;
            declarations.add((ITextSourceReference)declaration);
        }
        return declarations;
    }

    public static IAnnotationDeclaration getSessionDeclaration(IClassBean bean) {
        IAnnotationDeclaration declaration = bean.getAnnotation("javax.ejb.Stateful");
        if (declaration != null) {
            return declaration;
        }
        declaration = bean.getAnnotation("javax.ejb.Stateless");
        if (declaration != null) {
            return declaration;
        }
        declaration = bean.getAnnotation("javax.ejb.Singleton");
        return declaration;
    }

    public static boolean isSessionBean(IBean bean) {
        return bean instanceof ISessionBean || bean instanceof IClassBean && (bean.getAnnotation("javax.ejb.Stateful") != null || bean.getAnnotation("javax.ejb.Stateless") != null || bean.getAnnotation("javax.ejb.Singleton") != null);
    }

    public static boolean isDecorator(IBean bean) {
        return bean instanceof IDecorator || bean instanceof IClassBean && bean.getAnnotation("javax.decorator.Decorator") != null;
    }

    public static boolean isInterceptor(IBean bean) {
        return bean instanceof IInterceptor || bean instanceof IClassBean && bean.getAnnotation("javax.interceptor.Interceptor") != null;
    }

    public static boolean isBusinessOrStaticMethod(ISessionBean bean, IBeanMethod method) {
        return CDIUtil.getBusinessMethodDeclaration(bean, method) != null;
    }

    public static Set<IType> getLocalInterfaces(ISessionBean bean) {
        HashSet<IType> sourceTypes = new HashSet<IType>();
        try {
            for (IParametedType type : bean.getLegalTypes()) {
                IAnnotation annotation;
                IAnnotation[] annotations;
                IType sourceType = type.getType();
                if (sourceType == null) continue;
                IAnnotation[] iAnnotationArray = annotations = sourceType.getAnnotations();
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    annotation = iAnnotationArray[n2];
                    if ("javax.ejb.LocalBean".equals(annotation.getElementName()) || "LocalBean".equals(annotation.getElementName())) {
                        return Collections.emptySet();
                    }
                    ++n2;
                }
                if (!sourceType.isInterface()) continue;
                annotation = sourceType.getAnnotation("javax.ejb.Local");
                if (!annotation.exists()) {
                    annotation = sourceType.getAnnotation("Local");
                }
                if (!annotation.exists() || !"javax.ejb.Local".equals(EclipseJavaUtil.resolveType((IType)sourceType, (String)"Local"))) continue;
                sourceTypes.add(sourceType);
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return sourceTypes;
    }

    public static IMethod getBusinessMethodDeclaration(ISessionBean bean, IBeanMethod method) {
        try {
            int flags = method.getMethod().getFlags();
            if (Flags.isStatic((int)flags)) {
                return method.getMethod();
            }
            if (!Flags.isFinal((int)flags) && Flags.isPublic((int)flags)) {
                if (bean.getAnnotation("javax.ejb.Singleton") != null) {
                    return method.getMethod();
                }
                Set<IType> sourceTypes = CDIUtil.getLocalInterfaces(bean);
                if (sourceTypes.isEmpty()) {
                    return method.getMethod();
                }
                for (IType sourceType : sourceTypes) {
                    IMethod[] methods;
                    IMethod[] iMethodArray = methods = sourceType.getMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod iMethod = iMethodArray[n2];
                        if (method.getMethod().isSimilar(iMethod)) {
                            return iMethod;
                        }
                        ++n2;
                    }
                }
                return null;
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return null;
    }

    public static IMethod getOverridingMethodDeclaration(IBeanMethod method) {
        HashMap<IType, IMethod> foundMethods;
        IClassBean bean;
        block10: {
            bean = method.getClassBean();
            foundMethods = new HashMap<IType, IMethod>();
            if (!Flags.isStatic((int)method.getMethod().getFlags())) break block10;
            return null;
        }
        try {
            for (IParametedType type : bean.getLegalTypes()) {
                IMethod[] methods;
                IType sourceType = type.getType();
                if (sourceType == null || sourceType.isInterface()) continue;
                IMethod[] iMethodArray = methods = sourceType.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod iMethod = iMethodArray[n2];
                    if (method.getMethod().isSimilar(iMethod)) {
                        foundMethods.put(iMethod.getDeclaringType(), iMethod);
                    }
                    ++n2;
                }
            }
            if (foundMethods.size() == 1) {
                return (IMethod)foundMethods.values().iterator().next();
            }
            if (foundMethods.size() > 1) {
                IParametedType type;
                type = bean.getBeanClass();
                IType superClass = CDIUtil.getSuperClass((IType)type);
                while (superClass != null) {
                    IMethod m = (IMethod)foundMethods.get(superClass);
                    if (m != null) {
                        return m;
                    }
                    superClass = CDIUtil.getSuperClass(superClass);
                }
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return null;
    }

    public static IMethod getDirectOverridingMethodDeclaration(IBeanMethod method) {
        IClassBean bean;
        block6: {
            bean = method.getClassBean();
            if (!Flags.isStatic((int)method.getMethod().getFlags())) break block6;
            return null;
        }
        try {
            IType type = bean.getBeanClass();
            IType superClass = CDIUtil.getSuperClass(type);
            if (superClass != null) {
                IMethod[] methods;
                IMethod[] iMethodArray = methods = superClass.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod iMethod = iMethodArray[n2];
                    if (method.getMethod().isSimilar(iMethod)) {
                        return iMethod;
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return null;
    }

    public static Collection<IInjectionPointParameter> getInjectionPointParameters(IClassBean bean) {
        Collection<IInjectionPoint> points = bean.getInjectionPoints();
        ArrayList<IInjectionPointParameter> params = new ArrayList<IInjectionPointParameter>();
        for (IInjectionPoint injection : points) {
            if (!(injection instanceof IInjectionPointParameter)) continue;
            params.add((IInjectionPointParameter)injection);
        }
        return params;
    }

    public static boolean isMethodGeneric(IBeanMethod method) {
        try {
            return method.getMethod().getTypeParameters().length > 0;
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
            return false;
        }
    }

    public static boolean isMethodStatic(IBeanMethod method) {
        try {
            return Flags.isStatic((int)method.getMethod().getFlags());
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
            return false;
        }
    }

    public static boolean isMethodAbstract(IBeanMethod method) {
        try {
            return Flags.isAbstract((int)method.getMethod().getFlags());
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTypeVariable(IBeanMember member, boolean checkGenericMethod) {
        try {
            String[] typeVariableSegnatures = member.getClassBean().getBeanClass().getTypeParameterSignatures();
            ArrayList<String> variables = new ArrayList<String>();
            String[] stringArray = typeVariableSegnatures;
            int n = typeVariableSegnatures.length;
            int n2 = 0;
            while (n2 < n) {
                String variableSig = stringArray[n2];
                variables.add(Signature.getTypeVariable((String)variableSig));
                ++n2;
            }
            if (checkGenericMethod) {
                ITypeParameter[] typeParams = null;
                if (member instanceof IParameter) {
                    typeParams = ((IParameter)member).getBeanMethod().getMethod().getTypeParameters();
                }
                if (member instanceof IBeanMethod) {
                    typeParams = ((IBeanMethod)member).getMethod().getTypeParameters();
                }
                if (typeParams != null) {
                    ITypeParameter[] iTypeParameterArray = typeParams;
                    int n3 = typeParams.length;
                    n = 0;
                    while (n < n3) {
                        ITypeParameter param = iTypeParameterArray[n];
                        variables.add(param.getElementName());
                        ++n;
                    }
                }
            }
            String signature = null;
            if (member instanceof IBeanField) {
                signature = ((IBeanField)member).getField().getTypeSignature();
            } else if (member instanceof IParameter) {
                if (((IParameter)member).getType() == null) {
                    return false;
                }
                signature = ((IParameter)member).getType().getSignature();
            } else if (member instanceof IBeanMethod) {
                signature = ((IBeanMethod)member).getMethod().getReturnType();
            }
            boolean checkArrayType = CDIVersion.CDI_1_2.equals((Object)member.getCDIProject().getVersion());
            return CDIUtil.isTypeVariable(variables, signature, checkArrayType);
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
            return false;
        }
    }

    private static boolean isTypeVariable(List<String> typeVariables, String signature, boolean checkArrayType) {
        if (signature == null) {
            return false;
        }
        String typeString = Signature.toString((String)signature);
        for (String variableName : typeVariables) {
            if (!typeString.equals(variableName) && (!checkArrayType || !typeString.startsWith(String.valueOf(variableName) + "["))) continue;
            return true;
        }
        return false;
    }

    private static IType getSuperClass(IType type) throws JavaModelException {
        String fullySuperclassName;
        String superclassName = type.getSuperclassName();
        if (superclassName != null && (fullySuperclassName = EclipseJavaUtil.resolveType((IType)type, (String)superclassName)) != null && !fullySuperclassName.equals("java.lang.Object")) {
            if (fullySuperclassName.equals(type.getFullyQualifiedName())) {
                return null;
            }
            IType superType = type.getJavaProject().findType(fullySuperclassName);
            return superType;
        }
        return null;
    }

    public static boolean hasNonBindingAnnotationDeclaration(IType sourceType, IAnnotatable member) {
        return CDIUtil.hasAnnotationDeclaration(sourceType, member, "javax.enterprise.util.Nonbinding");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAnnotationDeclaration(IType sourceType, IAnnotatable member, String annotationTypeName) {
        try {
            IAnnotation[] annotations = member.getAnnotations();
            String simpleAnnotationTypeName = annotationTypeName;
            int lastDot = annotationTypeName.lastIndexOf(46);
            if (lastDot > -1) {
                simpleAnnotationTypeName = simpleAnnotationTypeName.substring(lastDot + 1);
            }
            IAnnotation[] iAnnotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                IType annotationType;
                String fullAnnotationclassName;
                if (n2 >= n) {
                    return false;
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotationTypeName.equals(annotation.getElementName())) {
                    return true;
                }
                if (simpleAnnotationTypeName.equals(annotation.getElementName()) && (fullAnnotationclassName = EclipseJavaUtil.resolveType((IType)sourceType, (String)simpleAnnotationTypeName)) != null && (annotationType = sourceType.getJavaProject().findType(fullAnnotationclassName)) != null && annotationType.getFullyQualifiedName().equals(annotationTypeName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return false;
    }

    public static ITextSourceReference convertToSourceReference(final ISourceRange range, final IResource resource, final IMember javaElement) {
        if (javaElement == null || javaElement.getResource() == null || !javaElement.getResource().equals((Object)resource)) {
            return new ITextSourceReference(){

                public int getStartPosition() {
                    return range.getOffset();
                }

                public int getLength() {
                    return range.getLength();
                }

                public IResource getResource() {
                    return resource;
                }
            };
        }
        return new IJavaSourceReference(){

            public IMember getSourceMember() {
                return javaElement;
            }

            public IJavaElement getSourceElement() {
                return javaElement;
            }

            public int getStartPosition() {
                return range.getOffset();
            }

            public IResource getResource() {
                return resource;
            }

            public int getLength() {
                return range.getLength();
            }
        };
    }

    public static ITextSourceReference convertToJavaSourceReference(final ITextSourceReference reference, final IMember javaElement) {
        if (reference instanceof IJavaSourceReference || javaElement == null || reference.getResource() != null && !reference.getResource().equals((Object)javaElement.getResource())) {
            return reference;
        }
        return new IJavaSourceReference(){

            public IMember getSourceMember() {
                return javaElement;
            }

            public IJavaElement getSourceElement() {
                return javaElement;
            }

            public int getStartPosition() {
                return reference.getStartPosition();
            }

            public IResource getResource() {
                return reference.getResource();
            }

            public int getLength() {
                return reference.getLength();
            }
        };
    }

    public static boolean containsDefaultQualifier(IInjectionPoint point) {
        Collection<IQualifierDeclaration> declarations = point.getQualifierDeclarations();
        if (declarations.isEmpty()) {
            return true;
        }
        for (IQualifierDeclaration declaration : declarations) {
            if (!"javax.enterprise.inject.Default".equals(declaration.getQualifier().getSourceType().getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static CDICoreNature getCDINatureWithProgress(IProject project) {
        final CDICoreNature cdiNature = CDICorePlugin.getCDI(project, false);
        if (cdiNature == null) {
            return null;
        }
        boolean resolved = cdiNature.isStorageResolved();
        if (resolved) {
            for (CDICoreNature p : cdiNature.getCDIProjects(true)) {
                if (p.isStorageResolved()) continue;
                resolved = false;
                break;
            }
        }
        if (!resolved) {
            if (Display.getCurrent() != null) {
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(CDICoreMessages.CDI_UTIL_BUILD_CDI_MODEL, 10);
                            monitor.worked(3);
                            cdiNature.resolve();
                            Set<CDICoreNature> ps = cdiNature.getCDIProjects(true);
                            Iterator<CDICoreNature> it = ps.iterator();
                            while (it.hasNext()) {
                                CDICoreNature n = it.next();
                                if (!n.isStorageResolved()) continue;
                                it.remove();
                            }
                            if (ps.isEmpty()) {
                                monitor.worked(7);
                            } else {
                                int delta = ps.size() == 1 ? 7 : (ps.size() == 2 ? 3 : (ps.size() == 3 ? 2 : 1));
                                for (CDICoreNature p : ps) {
                                    p.resolve();
                                    monitor.worked(delta);
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException ie) {
                    CDICorePlugin.getDefault().logError(ie);
                }
                catch (InvocationTargetException ite) {
                    CDICorePlugin.getDefault().logError(ite);
                }
            } else {
                cdiNature.resolve();
            }
        }
        return cdiNature;
    }

    public static Collection<IInterceptorBinding> getAllInterceptorBindings(IInterceptorBinded binded) {
        ArrayList<IInterceptorBinding> result = new ArrayList<IInterceptorBinding>();
        for (IInterceptorBindingDeclaration d : CDIUtil.collectAdditionalInterceptorBindingDeclaratios(binded, new HashSet<IInterceptorBindingDeclaration>())) {
            IInterceptorBinding b = d.getInterceptorBinding();
            if (b == null) continue;
            result.add(b);
        }
        return result;
    }

    public static Collection<IInterceptorBindingDeclaration> getAllInterceptorBindingDeclaratios(IInterceptorBinded binded) {
        return CDIUtil.collectAdditionalInterceptorBindingDeclaratios(binded, new HashSet<IInterceptorBindingDeclaration>());
    }

    private static Collection<IInterceptorBindingDeclaration> collectAdditionalInterceptorBindingDeclaratios(IInterceptorBinded binded, Set<IInterceptorBindingDeclaration> result) {
        for (IInterceptorBindingDeclaration declaration : binded.getInterceptorBindingDeclarations(true)) {
            if (result.contains(declaration)) continue;
            result.add(declaration);
            IInterceptorBinding binding = declaration.getInterceptorBinding();
            if (binding != null) {
                CDIUtil.collectAdditionalInterceptorBindingDeclaratios(binding, result);
            }
            if (!(binding instanceof IStereotyped)) continue;
            CDIUtil.collectAdditionalInterceptorBindingDeclaratiosFromStereotyps((IStereotyped)((Object)binding), result);
        }
        if (binded instanceof IStereotyped) {
            CDIUtil.collectAdditionalInterceptorBindingDeclaratiosFromStereotyps((IStereotyped)((Object)binded), result);
        }
        return result;
    }

    private static Set<IInterceptorBindingDeclaration> collectAdditionalInterceptorBindingDeclaratiosFromStereotyps(IStereotyped stereotyped, Set<IInterceptorBindingDeclaration> result) {
        Set<IStereotypeDeclaration> stereotypeDeclarations = CDIUtil.collectInheritedStereotypDeclarations(stereotyped, new HashSet<IStereotypeDeclaration>());
        if (stereotyped instanceof ClassBean) {
            stereotypeDeclarations.addAll(((ClassBean)stereotyped).getInheritedStereotypDeclarations());
        }
        for (IStereotypeDeclaration stereotypeDeclaration : stereotypeDeclarations) {
            CDIUtil.collectAdditionalInterceptorBindingDeclaratios(stereotypeDeclaration.getStereotype(), result);
        }
        return result;
    }

    private static Set<IStereotypeDeclaration> collectInheritedStereotypDeclarations(IStereotyped stereotyped, Set<IStereotypeDeclaration> result) {
        for (IStereotypeDeclaration declaration : stereotyped.getStereotypeDeclarations()) {
            if (result.contains(declaration)) continue;
            result.add(declaration);
            CDIUtil.collectInheritedStereotypDeclarations(declaration.getStereotype(), result);
        }
        return result;
    }

    public static Boolean checkTargetAnnotation(IAnnotationType annotationType, String[][] variants) throws JavaModelException {
        IAnnotationDeclaration target = annotationType.getAnnotationDeclaration("java.lang.annotation.Target");
        return target == null ? null : Boolean.valueOf(CDIUtil.checkTargetAnnotation(target, variants));
    }

    public static boolean checkTargetAnnotation(IAnnotationDeclaration target, String[][] variants) throws JavaModelException {
        Set<String> vs = CDIUtil.getTargetAnnotationValues(target);
        boolean ok = false;
        int i = 0;
        while (i < variants.length) {
            if (vs.size() == variants[i].length) {
                String[] values;
                boolean ok2 = true;
                String[] stringArray = values = variants[i];
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (!vs.contains(s)) {
                        ok2 = false;
                        break;
                    }
                    ++n2;
                }
                if (ok2) {
                    ok = true;
                    break;
                }
            }
            ++i;
        }
        return ok;
    }

    public static Set<String> getTargetAnnotationValues(IAnnotationDeclaration target) throws JavaModelException {
        String s;
        int i;
        HashSet<String> result = new HashSet<String>();
        Object o = target.getMemberValue(null);
        if (o instanceof Object[]) {
            Object[] os;
            Object[] objectArray = os = (Object[])o;
            int n = os.length;
            int n2 = 0;
            while (n2 < n) {
                Object q = objectArray[n2];
                String s2 = q.toString();
                int i2 = s2.lastIndexOf(46);
                if (i2 >= 0 && "java.lang.annotation.ElementType".equals(s2.substring(0, i2))) {
                    s2 = s2.substring(i2 + 1);
                    result.add(s2);
                }
                ++n2;
            }
        } else if (o != null && (i = (s = o.toString()).lastIndexOf(46)) >= 0 && "java.lang.annotation.ElementType".equals(s.substring(0, i))) {
            s = s.substring(i + 1);
            result.add(s);
        }
        return result;
    }

    public static Collection<IBean> getFilteredBeans(ICDIProject cdiProject, boolean attemptToResolveAmbiguousDependency, IInjectionPoint injectionPoint) {
        HashSet<IJavaElement> elements = new HashSet<IJavaElement>();
        ArrayList<IBean> result = new ArrayList<IBean>();
        for (IBean bean : cdiProject.getBeans(attemptToResolveAmbiguousDependency, injectionPoint)) {
            IJavaElement element = CDIUtil.getJavaElement(bean);
            if (elements.contains(element)) continue;
            elements.add(element);
            result.add(bean);
        }
        return result;
    }

    public static Collection<IBean> getFilteredBeans(ICDIProject cdiProject, IPath path) {
        HashSet<IJavaElement> elements = new HashSet<IJavaElement>();
        ArrayList<IBean> result = new ArrayList<IBean>();
        for (IBean bean : cdiProject.getBeans(path)) {
            IJavaElement element = CDIUtil.getJavaElement(bean);
            if (elements.contains(element)) continue;
            elements.add(element);
            result.add(bean);
        }
        return result;
    }

    public static List<IBean> getSortedBeans(ICDIProject cdiProject, boolean attemptToResolveAmbiguousDependency, IInjectionPoint injectionPoint) {
        Collection<IBean> beans = CDIUtil.getFilteredBeans(cdiProject, attemptToResolveAmbiguousDependency, injectionPoint);
        return CDIUtil.sortBeans(beans);
    }

    public static List<IBean> getSortedBeans(ICDIProject cdiProject, IPath path) {
        Collection<IBean> beans = CDIUtil.getFilteredBeans(cdiProject, path);
        return CDIUtil.sortBeans(beans);
    }

    public static IJavaElement getJavaElement(ICDIElement cdiElement) {
        if (cdiElement instanceof IJavaReference) {
            return ((IJavaReference)cdiElement).getSourceMember();
        }
        if (cdiElement instanceof IBean) {
            return ((IBean)cdiElement).getBeanClass();
        }
        if (cdiElement instanceof IInjectionPointParameter) {
            IMethod method = ((IInjectionPointParameter)cdiElement).getBeanMethod().getMethod();
            return CDIUtil.getParameter(method, ((IInjectionPointParameter)cdiElement).getName());
        }
        return null;
    }

    public static ILocalVariable getParameter(IMethod method, String name) {
        try {
            ILocalVariable[] iLocalVariableArray = method.getParameters();
            int n = iLocalVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable param = iLocalVariableArray[n2];
                if (param.getElementName().equals(name)) {
                    return param;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            CDICorePlugin.getDefault().logError(ex);
        }
        return null;
    }

    public static ICDIProject getCDIProject(IFile file, CDICoreNature cdiNature, boolean asYouType) {
        ICDIProject cdiProject = cdiNature.getDelegate();
        if (asYouType && file != null) {
            return new CDIProjectAsYouType(cdiProject, file);
        }
        return cdiProject;
    }

    public static CDIVersion getCDIVersion(IProject project) {
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)project);
        if (jp == null) {
            return CDIVersion.CDI_UNKNOWN;
        }
        try {
            if (EclipseJavaUtil.findType((IJavaProject)jp, (String)"javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator") != null) {
                return CDIVersion.CDI_2_0;
            }
            if (EclipseJavaUtil.findType((IJavaProject)jp, (String)"javax.enterprise.inject.Vetoed") != null) {
                String v;
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null && (v = facetedProject.getProjectFacetVersion(CDIFacetInstallDelegate.CDI_FACET)) != null && v.equals(CDIFacetInstallDelegate.CDI_11)) {
                    return CDIVersion.CDI_1_1;
                }
                v = CDIUtil.getCDIImplementationVersion(project);
                if (v != null && v.startsWith("1.1")) {
                    return CDIVersion.CDI_1_1;
                }
                return CDIVersion.CDI_1_2;
            }
            if (EclipseJavaUtil.findType((IJavaProject)jp, (String)"javax.inject.Qualifier") != null) {
                return CDIVersion.CDI_1_0;
            }
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return CDIVersion.CDI_UNKNOWN;
    }

    public static String getCDIImplementationVersion(IProject project) throws CoreException {
        try {
            InputStream content = CDIUtil.readManifest(project);
            if (content != null) {
                Properties p = new Properties();
                p.load(content);
                return p.getProperty("Specification-Version");
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.cdi.core", "Failed to read manifest in cdi-api.jar in project " + project.getName(), (Throwable)e));
        }
        return null;
    }

    public static InputStream readManifest(IProject project) throws CoreException, IOException {
        InputStream is;
        ZipFile zip;
        ZipEntry entry;
        IPackageFragmentRoot library = CDIUtil.findLibrary(project);
        if (library instanceof JarPackageFragmentRoot && (entry = (zip = ((JarPackageFragmentRoot)library).getJar()).getEntry("META-INF/MANIFEST.MF")) != null && (is = zip.getInputStream(entry)) != null) {
            return is;
        }
        return null;
    }

    public static IPackageFragmentRoot findLibrary(IProject project) throws JavaModelException {
        if (project == null || !project.isAccessible()) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
            IPath resource = fragmentRoot.getPath();
            if (resource != null && resource.lastSegment().startsWith("cdi-api")) {
                return fragmentRoot;
            }
            ++n2;
        }
        return null;
    }
}

