/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.ca;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IDecorator;
import org.jboss.tools.cdi.core.IInterceptor;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.KbQuery;

public class BeansXmlProcessor {
    private static final BeansXmlProcessor INSTANCE = new BeansXmlProcessor();
    public static final Image CLASS_PROPOSAL_IMAGE = JavaPluginImages.DESC_OBJS_CLASS.createImage();
    public static final Image ANNOTATION_PROPOSAL_IMAGE = JavaPluginImages.DESC_OBJS_ANNOTATION.createImage();
    private static final TextProposal[] EMPTY_ARRAY = new TextProposal[0];
    private static final String ALTERNATIVES_ELEMENT = "alternatives";
    private static final String CLASS_ELEMENT = "class";
    private static final String STEREOTYPE_ELEMENT = "stereotype";
    private static final String DECORATORS_ELEMENT = "decorators";
    private static final String INTERCEPTOR_ELEMENT = "interceptors";

    public static BeansXmlProcessor getInstance() {
        return INSTANCE;
    }

    private BeansXmlProcessor() {
    }

    public TextProposal[] getProposals(KbQuery query, IProject project) {
        CDICoreNature nature;
        String[] parents = query.getParentTags();
        if (parents.length > 1 && (nature = CDICorePlugin.getCDI(project, false)) != null) {
            ICDIProject cdiProject = nature.getDelegate();
            int lastIndex = parents.length - 1;
            int firstIndex = parents.length - 2;
            if (CLASS_ELEMENT.equals(parents[lastIndex])) {
                if (ALTERNATIVES_ELEMENT.equals(parents[firstIndex])) {
                    return this.getAlternativeBeans(query, cdiProject);
                }
                if (DECORATORS_ELEMENT.equals(parents[firstIndex])) {
                    return this.getDecorators(query, cdiProject);
                }
                if (INTERCEPTOR_ELEMENT.equals(parents[firstIndex])) {
                    return this.getInterceptors(query, cdiProject);
                }
            } else if (STEREOTYPE_ELEMENT.equals(parents[lastIndex]) && ALTERNATIVES_ELEMENT.equals(parents[firstIndex])) {
                return this.getAlternativeStereotypes(query, cdiProject);
            }
        }
        return EMPTY_ARRAY;
    }

    private TextProposal[] getAlternativeBeans(KbQuery query, ICDIProject cdiProject) {
        IBean[] alternatives;
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        String value = this.removeLeadingWhitespace(query.getValue());
        IBean[] iBeanArray = alternatives = cdiProject.getAlternatives();
        int n = alternatives.length;
        int n2 = 0;
        while (n2 < n) {
            IBean bean = iBeanArray[n2];
            if (bean instanceof IClassBean) {
                IType type = bean.getBeanClass();
                this.addMatchedType(type, value, proposals, CDIImages.getImageDescriptorByElement(bean));
            }
            ++n2;
        }
        return proposals.toArray(new TextProposal[0]);
    }

    private TextProposal[] getAlternativeStereotypes(KbQuery query, ICDIProject cdiProject) {
        IStereotype[] alternatives;
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        String value = this.removeLeadingWhitespace(query.getValue());
        IStereotype[] iStereotypeArray = alternatives = cdiProject.getStereotypes();
        int n = alternatives.length;
        int n2 = 0;
        while (n2 < n) {
            IStereotype stereotype = iStereotypeArray[n2];
            if (stereotype.isAlternative()) {
                IType type = stereotype.getSourceType();
                this.addMatchedType(type, value, proposals, CDIImages.getImageDescriptorByElement(stereotype));
            }
            ++n2;
        }
        return proposals.toArray(new TextProposal[0]);
    }

    private TextProposal[] getDecorators(KbQuery query, ICDIProject cdiProject) {
        IDecorator[] decorators;
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        String value = this.removeLeadingWhitespace(query.getValue());
        IDecorator[] iDecoratorArray = decorators = cdiProject.getDecorators();
        int n = decorators.length;
        int n2 = 0;
        while (n2 < n) {
            IDecorator bean = iDecoratorArray[n2];
            IType type = bean.getBeanClass();
            this.addMatchedType(type, value, proposals, CDIImages.getImageDescriptorByElement(bean));
            ++n2;
        }
        return proposals.toArray(new TextProposal[0]);
    }

    private TextProposal[] getInterceptors(KbQuery query, ICDIProject cdiProject) {
        IInterceptor[] interceptors;
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        String value = this.removeLeadingWhitespace(query.getValue());
        IInterceptor[] iInterceptorArray = interceptors = cdiProject.getInterceptors();
        int n = interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            IInterceptor bean = iInterceptorArray[n2];
            IType type = bean.getBeanClass();
            this.addMatchedType(type, value, proposals, CDIImages.getImageDescriptorByElement(bean));
            ++n2;
        }
        return proposals.toArray(new TextProposal[0]);
    }

    private String removeLeadingWhitespace(String value) {
        int len = value.length();
        int st = 0;
        char[] val = value.toCharArray();
        while (st < len && val[st] <= ' ') {
            ++st;
        }
        return st > 0 ? value.substring(st) : value;
    }

    private void addMatchedType(IType type, String value, List<TextProposal> proposals, ImageDescriptor image) {
        String fullTypeName = type.getFullyQualifiedName();
        if (fullTypeName.startsWith(value)) {
            TextProposal proposal = new TextProposal();
            proposal.setContextInfo(fullTypeName);
            proposal.setLabel(String.valueOf(type.getElementName()) + " - " + type.getPackageFragment().getElementName());
            proposal.setReplacementString(fullTypeName);
            proposal.setPosition(fullTypeName.length());
            proposal.setImageDescriptor(image);
            proposals.add(proposal);
        }
    }
}

