/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IInterceptorBindingDeclaration;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedMemberFeature;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.definition.BeanMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.ParameterDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;

public class MethodDefinition
extends BeanMemberDefinition {
    IMethod method;
    boolean isConstructor;
    List<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();

    public void setMethod(IMethod method, IRootDefinitionContext context, int flags) {
        this.method = method;
        this.setAnnotatable((IAnnotatable)method, method.getDeclaringType(), context, flags);
    }

    public IMethod getMethod() {
        return this.method;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    protected void init(IType contextType, IRootDefinitionContext context, int flags) throws CoreException {
        super.init(contextType, context, flags);
        this.isConstructor = this.method.isConstructor();
        this.loadParamDefinitions(contextType, context, flags);
    }

    public boolean parametersAreInjectionPoints() {
        return this.getProducesAnnotation() != null || this.getInjectAnnotation() != null;
    }

    void loadParamDefinitions(IType contextType, IRootDefinitionContext context, int flags) throws CoreException {
        if (this.method == null) {
            return;
        }
        ILocalVariable[] ps = this.method.getParameters();
        boolean loadAll = (flags & FLAG_ALL_MEMBERS) > 0;
        boolean parametersAreInjectionPoints = this.parametersAreInjectionPoints();
        if (ps.length == 0) {
            return;
        }
        if (contextType == null) {
            return;
        }
        Set<IProcessAnnotatedMemberFeature> extensions = context.getProject().getExtensionManager().getProcessAnnotatedMemberFeatures();
        ParameterDefinition[] ds = new ParameterDefinition[ps.length];
        int i = 0;
        while (i < ps.length) {
            ParameterDefinition pd = new ParameterDefinition();
            pd.setMethodDefinition(this);
            pd.index = i;
            pd.setLocalVariable(ps[i], context, flags);
            for (IProcessAnnotatedMemberFeature e : extensions) {
                e.processAnnotatedMember(pd, context);
            }
            if (pd.isAnnotationPresent("javax.enterprise.event.Observes") || pd.isAnnotationPresent("javax.enterprise.inject.Disposes")) {
                parametersAreInjectionPoints = true;
            }
            ds[i] = pd;
            ++i;
        }
        i = 0;
        while (i < ps.length) {
            if (loadAll || parametersAreInjectionPoints || !ds[i].getAnnotations().isEmpty()) {
                this.parameters.add(ds[i]);
            }
            ++i;
        }
    }

    @Override
    public boolean isCDIAnnotated() {
        return super.isCDIAnnotated() || this.isDisposer() || this.isObserver() || this.isObserverAsync() || this.getPreDestroyMethod() != null || this.getPostConstructorMethod() != null || !this.getInterceptorBindings().isEmpty() || this.hasStereotypeDeclarations();
    }

    public Collection<IInterceptorBinding> getInterceptorBindings() {
        ArrayList<IInterceptorBinding> result = new ArrayList<IInterceptorBinding>();
        for (IInterceptorBindingDeclaration declaration : ClassBean.getInterceptorBindingDeclarations(this)) {
            result.add(declaration.getInterceptorBinding());
        }
        return result;
    }

    public boolean hasStereotypeDeclarations() {
        List<IAnnotationDeclaration> as = this.getAnnotations();
        for (IAnnotationDeclaration a : as) {
            if (!(a instanceof IStereotypeDeclaration)) continue;
            return true;
        }
        return false;
    }

    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public boolean isDisposer() {
        for (ParameterDefinition p : this.parameters) {
            if (!p.isAnnotationPresent("javax.enterprise.inject.Disposes")) continue;
            return true;
        }
        return false;
    }

    public boolean isObserver() {
        for (ParameterDefinition p : this.parameters) {
            if (!p.isAnnotationPresent("javax.enterprise.event.Observes")) continue;
            return true;
        }
        return false;
    }

    public boolean isObserverAsync() {
        for (ParameterDefinition p : this.parameters) {
            if (!p.isAnnotationPresent("javax.enterprise.event.ObservesAsync")) continue;
            return true;
        }
        return false;
    }

    public AnnotationDeclaration getPreDestroyMethod() {
        return this.getAnnotation("javax.annotation.PreDestroy");
    }

    public AnnotationDeclaration getPostConstructorMethod() {
        return this.getAnnotation("javax.annotation.PostConstruct");
    }
}

