/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.jboss.tools.cdi.core.CDICoreMessages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.internal.core.refactoring.CDIRenameProcessor;
import org.jboss.tools.common.text.ITextSourceReference;

public class RenameNamedBeanProcessor
extends CDIRenameProcessor {
    public RenameNamedBeanProcessor(IBean bean) {
        super(CDICoreMessages.RENAME_NAMED_BEAN_PROCESSOR_TITLE, bean);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        this.status = new RefactoringStatus();
        if (this.bean != null) {
            this.rootChange = new CompositeChange(CDICoreMessages.RENAME_NAMED_BEAN_PROCESSOR_TITLE);
            this.renameBean(pm);
        }
        return this.status;
    }

    private void renameBean(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 3);
        this.clearChanges();
        this.changeDeclarations();
        if (this.status.hasFatalError()) {
            return;
        }
        pm.worked(1);
        this.getSearcher().findELReferences(pm);
        pm.done();
    }

    private void changeDeclarations() throws CoreException {
        ITextSourceReference stereotypeLocation;
        this.declarationFile = (IFile)this.bean.getResource();
        if (this.declarationFile == null) {
            this.status.addFatalError(CDICoreMessages.CDI_RENAME_PROCESSOR_BEAN_HAS_NO_FILE);
            return;
        }
        ITextSourceReference nameLocation = this.bean.getNameLocation(false);
        ITextSourceReference iTextSourceReference = stereotypeLocation = nameLocation != null ? null : this.bean.getNameLocation(true);
        if (nameLocation == null && stereotypeLocation == null) {
            this.status.addFatalError(CDICoreMessages.CDI_RENAME_PROCESSOR_BEAN_HAS_NO_NAME_LOCATION);
            return;
        }
        String newText = "@Named(\"" + this.getNewName() + "\")";
        if (nameLocation != null) {
            this.change(this.declarationFile, nameLocation.getStartPosition(), nameLocation.getLength(), newText);
        } else if (stereotypeLocation != null) {
            this.change(this.declarationFile, stereotypeLocation.getStartPosition() + stereotypeLocation.getLength(), 0, " " + newText);
        }
    }
}

