/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.IDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedTypeFeature;
import org.jboss.tools.cdi.core.extension.feature.IValidatorFeature;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeConstants;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikePartialbeanBindingConfiguration;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikePartialbeanDefinitionContext;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeSeverityPreferences;
import org.jboss.tools.cdi.deltaspike.core.InterfaceDefinition;
import org.jboss.tools.cdi.deltaspike.core.validation.DeltaspikeValidationMessages;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.DefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.text.ITextSourceReference;

public class DeltaspikePartialbeanExtension
implements ICDIExtension,
IBuildParticipantFeature,
IProcessAnnotatedTypeFeature,
IValidatorFeature,
DeltaspikeConstants {
    public static String ID = "org.apache.deltaspike.partialbean.impl.PartialBeanBindingExtension";
    DeltaspikePartialbeanDefinitionContext context = new DeltaspikePartialbeanDefinitionContext();

    public static DeltaspikePartialbeanExtension getExtension(CDICoreNature project) {
        return (DeltaspikePartialbeanExtension)project.getExtensionManager().getExtensionByRuntime(ID);
    }

    public DeltaspikePartialbeanDefinitionContext getContext() {
        return this.context;
    }

    public void processAnnotatedType(TypeDefinition typeDefinition, IRootDefinitionContext context) {
        IAnnotationDeclaration d = this.findAnnotationAnnotatedWithPartialBeanBindingType((AbstractTypeDefinition)typeDefinition, context);
        if (d != null) {
            DeltaspikePartialbeanDefinitionContext contextCopy = (DeltaspikePartialbeanDefinitionContext)this.context.getWorkingCopy();
            DeltaspikePartialbeanBindingConfiguration c = contextCopy.getConfiguration(d.getTypeName());
            if (typeDefinition.isAbstract()) {
                typeDefinition.setBeanConstructor(true);
                c.addPartialBean(typeDefinition);
            } else if (this.isImplementingInvocationHandler(typeDefinition)) {
                c.addInvocationHandler(typeDefinition);
            } else {
                c.addInvalidPartialBean(typeDefinition);
            }
            this.addToDependencies(c, (AbstractMemberDefinition)typeDefinition, context);
        }
    }

    public void beginVisiting() {
    }

    public void visitJar(IPath path, IPackageFragmentRoot root, XModelObject beansXML) {
    }

    public void visit(IFile file, IPath src, IPath webinf) {
    }

    public void buildDefinitions() {
    }

    public void buildDefinitions(FileSet fileSet) {
        DeltaspikePartialbeanDefinitionContext workingCopy = (DeltaspikePartialbeanDefinitionContext)this.context.getWorkingCopy();
        Map is = fileSet.getInterfaces();
        for (IPath p : is.keySet()) {
            for (IType type : (List)is.get(p)) {
                InterfaceDefinition def = new InterfaceDefinition(type, (IDefinitionContextExtension)workingCopy);
                IAnnotationDeclaration d = this.findAnnotationAnnotatedWithPartialBeanBindingType(def, workingCopy.getRootContext());
                if (d == null) continue;
                TypeDefinition typeDefinition = new TypeDefinition();
                typeDefinition.setType(type, workingCopy.getRootContext(), 0);
                typeDefinition.setBeanConstructor(true);
                DeltaspikePartialbeanBindingConfiguration c = workingCopy.getConfiguration(d.getTypeName());
                c.addPartialBean(typeDefinition);
                ((DefinitionContext)this.context.getRootContext().getWorkingCopy()).addType(type.getPath(), type.getFullyQualifiedName(), (AbstractTypeDefinition)typeDefinition);
                this.addToDependencies(c, (AbstractMemberDefinition)typeDefinition, workingCopy.getRootContext());
            }
        }
    }

    public void buildBeans(CDIProject target) {
    }

    public void validateResource(IFile file, CDICoreValidator validator) {
        IPath path = file.getFullPath();
        for (DeltaspikePartialbeanBindingConfiguration c : this.context.partialbeanBindingConfigurations.values()) {
            IAnnotationDeclaration dc;
            if (!c.getInvolvedTypes().contains(path)) continue;
            for (TypeDefinition def : c.getInvocationHandlers().values()) {
                IClassBean cb;
                if (!file.equals((Object)def.getResource())) continue;
                this.reportIgnoredBindings(file, validator, def);
                dc = this.findAnnotationAnnotatedWithPartialBeanBindingType((AbstractTypeDefinition)def, this.context.getRootContext());
                if (c.getInvocationHandlers().size() > 1) {
                    validator.addError(DeltaspikeValidationMessages.MULTIPLE_PARTIAL_BEAN_HANDLERS, DeltaspikeSeverityPreferences.MULTIPLE_PARTIAL_BEAN_HANDLERS, new String[]{dc.getTypeName()}, (ITextSourceReference)dc, (IResource)file);
                }
                if ((cb = this.context.getRootContext().getProject().getDelegate().getBeanClass(def.getType())) == null || cb.getScope().isNorlmalScope()) continue;
                validator.addError(DeltaspikeValidationMessages.INVALID_PARTIAL_BEAN_HANDLER, DeltaspikeSeverityPreferences.INVALID_PARTIAL_BEAN_HANDLER, new String[0], (ITextSourceReference)dc, (IResource)file);
            }
            for (TypeDefinition def : c.getPartialBeans().values()) {
                if (!file.equals((Object)def.getResource())) continue;
                this.reportIgnoredBindings(file, validator, def);
                dc = this.findAnnotationAnnotatedWithPartialBeanBindingType((AbstractTypeDefinition)def, this.context.getRootContext());
                if (!c.getInvocationHandlers().isEmpty()) continue;
                validator.addError(DeltaspikeValidationMessages.MISSING_PARTIAL_BEAN_HANDLER, DeltaspikeSeverityPreferences.MISSING_PARTIAL_BEAN_HANDLER, new String[]{def.getQualifiedName(), dc.getTypeName()}, (ITextSourceReference)dc, (IResource)file);
            }
            for (TypeDefinition def : c.getInvalidPartialBeans().values()) {
                if (!file.equals((Object)def.getResource())) continue;
                this.reportIgnoredBindings(file, validator, def);
                dc = this.findAnnotationAnnotatedWithPartialBeanBindingType((AbstractTypeDefinition)def, this.context.getRootContext());
                validator.addError(DeltaspikeValidationMessages.ILLEGAL_PARTIAL_BEAN, DeltaspikeSeverityPreferences.ILLEGAL_PARTIAL_BEAN, new String[]{dc.getTypeName()}, (ITextSourceReference)dc, (IResource)file);
            }
        }
    }

    private void reportIgnoredBindings(IFile file, CDICoreValidator validator, TypeDefinition def) {
        List<IAnnotationDeclaration> dcs = this.getAllAnnotationsAnnotatedWithPartialBeanBindingType((AbstractTypeDefinition)def, this.context.getRootContext());
        if (dcs.size() > 1) {
            IAnnotationDeclaration d0 = dcs.remove(0);
            for (IAnnotationDeclaration dc : dcs) {
                validator.addError(DeltaspikeValidationMessages.MULTIPLE_PARTIAL_BEAN_BINDINGS, DeltaspikeSeverityPreferences.MULTIPLE_PARTIAL_BEAN_BINDINGS, new String[]{dc.getTypeName(), d0.getTypeName()}, (ITextSourceReference)dc, (IResource)file);
            }
        }
    }

    public SeverityPreferences getSeverityPreferences() {
        return DeltaspikeSeverityPreferences.getInstance();
    }

    private IAnnotationDeclaration findAnnotationAnnotatedWithPartialBeanBindingType(AbstractTypeDefinition t, IRootDefinitionContext context) {
        for (IAnnotationDeclaration d : t.getAnnotations()) {
            AnnotationDefinition a;
            if (d.getTypeName() == null || (a = context.getAnnotation(d.getTypeName())) == null || !a.isAnnotationPresent("org.apache.deltaspike.partialbean.api.PartialBeanBinding")) continue;
            return d;
        }
        return null;
    }

    private List<IAnnotationDeclaration> getAllAnnotationsAnnotatedWithPartialBeanBindingType(AbstractTypeDefinition t, IRootDefinitionContext context) {
        ArrayList<IAnnotationDeclaration> result = new ArrayList<IAnnotationDeclaration>();
        for (IAnnotationDeclaration d : t.getAnnotations()) {
            AnnotationDefinition a;
            if (d.getTypeName() == null || (a = context.getAnnotation(d.getTypeName())) == null || !a.isAnnotationPresent("org.apache.deltaspike.partialbean.api.PartialBeanBinding")) continue;
            result.add(d);
        }
        return result;
    }

    private boolean isImplementingInvocationHandler(TypeDefinition typeDefinition) {
        for (IParametedType t : typeDefinition.getAllTypes()) {
            IType type = t.getType();
            if (type == null || !"java.lang.reflect.InvocationHandler".equals(type.getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private void addToDependencies(DeltaspikePartialbeanBindingConfiguration c, AbstractMemberDefinition def, IRootDefinitionContext context) {
        IResource r = def.getResource();
        if (r != null && r.exists() && !c.getInvolvedTypes().contains(r.getFullPath())) {
            IPath newPath = r.getFullPath();
            Set<IPath> ps = c.getInvolvedTypes();
            for (IPath p : ps) {
                context.addDependency(p, newPath);
                context.addDependency(newPath, p);
            }
            ps.add(newPath);
        }
    }
}

