/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.text.ext;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeCorePlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;

public class JavaElementHyperlink
extends AbstractHyperlink {
    protected IJavaElement element;

    public JavaElementHyperlink(IRegion region, IJavaElement element, IDocument document) {
        this.element = element;
        this.setRegion(region);
        this.setDocument(document);
    }

    public void doHyperlink(IRegion region) {
        IEditorPart part = null;
        if (this.element != null && this.element.exists() && this.element.getAncestor(7) != null) {
            try {
                part = JavaUI.openInEditor((IJavaElement)this.element.getAncestor(7));
            }
            catch (JavaModelException ex) {
                DeltaspikeCorePlugin.getDefault().logError(ex);
            }
            catch (PartInitException ex) {
                DeltaspikeCorePlugin.getDefault().logError(ex);
            }
            if (part != null) {
                JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)this.element);
            }
        }
        if (part == null) {
            this.openFileFailed();
        }
    }

    public String getHyperlinkText() {
        String s = "";
        if (this.element instanceof IMethod) {
            IMethod m = (IMethod)this.element;
            s = String.valueOf(m.getDeclaringType().getElementName()) + "." + m.getElementName() + "()";
        }
        String text = "Open authorizer method " + s;
        return text;
    }
}

