/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.text.ext.CDIExtensionsMessages;
import org.jboss.tools.cdi.text.ext.hyperlink.InformationControlManager;
import org.jboss.tools.cdi.text.ext.hyperlink.InjectedPointHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;

public class AlternativeInjectedPointListHyperlink
extends AbstractHyperlink {
    protected List<IBean> beans;
    protected ITextViewer viewer;

    public AlternativeInjectedPointListHyperlink(IRegion region, List<IBean> beans, ITextViewer viewer, IDocument document) {
        this.beans = beans;
        this.setRegion(region);
        this.viewer = viewer;
        this.setDocument(document);
    }

    protected void doHyperlink(IRegion region) {
        IHyperlink[] hyperlinks = new IHyperlink[this.beans.size()];
        int index = 0;
        for (IBean bean : this.beans) {
            hyperlinks[index++] = this.createHyperlink(region, bean);
        }
        if (hyperlinks.length == 0) {
            this.openFileFailed();
            return;
        }
        if (hyperlinks.length == 1) {
            ((InjectedPointHyperlink)hyperlinks[0]).doHyperlink(region);
        } else {
            InformationControlManager.instance.showHyperlinks(CDIExtensionsMessages.CDI_SHOW_ALL_ELIGIBLE_BEANS_TITLE, this.viewer, hyperlinks);
        }
    }

    protected IHyperlink createHyperlink(IRegion region, IBean bean) {
        return new InjectedPointHyperlink(region, bean, this.getDocument());
    }

    public String getHyperlinkText() {
        return CDIExtensionsMessages.CDI_INJECTED_POINT_HYPERLINK_SHOW_ALTERNATIVES;
    }
}

