/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.text.ext.CDIExtensionsMessages;
import org.jboss.tools.cdi.text.ext.hyperlink.EventHyperlink;
import org.jboss.tools.cdi.text.ext.hyperlink.ITestableCDIHyperlink;
import org.jboss.tools.cdi.text.ext.hyperlink.InformationControlManager;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;

public class EventListHyperlink
extends AbstractHyperlink
implements ITestableCDIHyperlink {
    private ITextViewer viewer;
    private Set<IInjectionPoint> events;

    public EventListHyperlink(ITextViewer viewer, IRegion region, Set<IInjectionPoint> events, IDocument document) {
        this.viewer = viewer;
        this.events = events;
        this.setRegion(region);
        this.setDocument(document);
    }

    protected void doHyperlink(IRegion region) {
        IHyperlink[] hyperlinks = new IHyperlink[this.events.size()];
        int index = 0;
        for (IInjectionPoint event : this.events) {
            hyperlinks[index++] = new EventHyperlink(region, event, this.getDocument());
        }
        if (hyperlinks.length == 0) {
            this.openFileFailed();
            return;
        }
        if (hyperlinks.length == 1) {
            ((EventHyperlink)hyperlinks[0]).doHyperlink(region);
        } else {
            InformationControlManager.instance.showHyperlinks(CDIExtensionsMessages.CDI_EVENT_TITLE, this.viewer, hyperlinks);
        }
    }

    public String getHyperlinkText() {
        return CDIExtensionsMessages.CDI_EVENT_LIST_HYPERLINK_OPEN_EVENTS;
    }

    @Override
    public ICDIElement getCDIElement() {
        return null;
    }

    public Set<? extends ICDIElement> getCDIElements() {
        return this.events;
    }
}

