/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.refactoring.BaseMarkerResolution;

public class MakeFieldStaticMarkerResolution
extends BaseMarkerResolution {
    private IField field;

    public MakeFieldStaticMarkerResolution(IField field) {
        super(CDIMarkerResolutionUtils.getJavaMember((IJavaElement)field).getCompilationUnit());
        this.label = MessageFormat.format(CDIUIMessages.MAKE_FIELD_STATIC_MARKER_RESOLUTION_TITLE, field.getElementName());
        this.field = field;
        this.init();
    }

    protected CompilationUnitChange getChange(ICompilationUnit compilationUnit) {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        MultiTextEdit edit = new MultiTextEdit();
        change.setEdit((TextEdit)edit);
        try {
            IBuffer buffer = compilationUnit.getBuffer();
            int flag = this.field.getFlags();
            String text = buffer.getText(this.field.getSourceRange().getOffset(), this.field.getSourceRange().getLength());
            int position = this.field.getSourceRange().getOffset();
            if (Flags.isPublic((int)flag)) {
                InsertEdit ie = new InsertEdit(position += text.indexOf("public") + "public".length(), " static");
                edit.addChild((TextEdit)ie);
            } else if (Flags.isPrivate((int)flag)) {
                InsertEdit ie = new InsertEdit(position += text.indexOf("private") + "private".length(), " static");
                edit.addChild((TextEdit)ie);
            } else if (Flags.isProtected((int)flag)) {
                InsertEdit ie = new InsertEdit(position += text.indexOf("protected") + "protected".length(), " static");
                edit.addChild((TextEdit)ie);
            } else {
                String type = Signature.getSignatureSimpleName((String)this.field.getTypeSignature());
                InsertEdit ie = new InsertEdit(position += text.indexOf(type), " static");
                edit.addChild((TextEdit)ie);
            }
        }
        catch (CoreException ex) {
            CDIUIPlugin.getDefault().logError(ex);
        }
        return change;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_EDIT);
    }
}

