/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.quickfix.IQuickFix;

public class MakeMethodBusinessMarkerResolution
implements IQuickFix {
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String PROTECTED = "protected";
    private static final String SPACE = " ";
    private String label;
    private IMethod method;
    private IType localInterface;
    private IFile file;

    public MakeMethodBusinessMarkerResolution(IMethod method, IType localInterface) {
        this.label = MessageFormat.format(CDIUIMessages.MAKE_METHOD_BUSINESS_MARKER_RESOLUTION_TITLE, method.getElementName(), localInterface.getElementName());
        this.method = method;
        this.localInterface = localInterface;
        try {
            this.file = (IFile)method.getUnderlyingResource();
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        this.internal_run();
    }

    private void internal_run() {
        try {
            ICompilationUnit original = EclipseUtil.getCompilationUnit((IFile)this.file);
            if (original == null) {
                return;
            }
            ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IBuffer buffer = compilationUnit.getBuffer();
            int flag = this.method.getFlags();
            String text = buffer.getText(this.method.getSourceRange().getOffset(), this.method.getSourceRange().getLength());
            int position = this.method.getSourceRange().getOffset();
            if (!Flags.isPublic((int)flag)) {
                if (Flags.isPrivate((int)flag)) {
                    buffer.replace(position += text.indexOf(PRIVATE), PRIVATE.length(), PUBLIC);
                } else if (Flags.isProtected((int)flag)) {
                    buffer.replace(position += text.indexOf(PROTECTED), PROTECTED.length(), PUBLIC);
                } else {
                    String type = Signature.getSignatureSimpleName((String)this.method.getReturnType());
                    buffer.replace(position += text.indexOf(type), 0, "public ");
                }
            }
            compilationUnit.commitWorkingCopy(false, (IProgressMonitor)new NullProgressMonitor());
            compilationUnit.discardWorkingCopy();
            original = this.localInterface.getCompilationUnit();
            compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IType interfaceType = compilationUnit.getType(this.localInterface.getElementName());
            StringBuffer content = new StringBuffer();
            content.append("public ");
            String simpleType = Signature.getSignatureSimpleName((String)this.method.getReturnType());
            content.append(simpleType);
            content.append(SPACE);
            content.append(this.method.getElementName());
            content.append("(");
            IType originalType = this.method.getDeclaringType();
            this.addImport(originalType, simpleType, compilationUnit);
            String[] types = this.method.getParameterTypes();
            String[] names = this.method.getParameterNames();
            int i = 0;
            while (i < this.method.getNumberOfParameters()) {
                if (i > 0) {
                    content.append(", ");
                }
                simpleType = Signature.getSignatureSimpleName((String)types[i]);
                this.addImport(originalType, simpleType, compilationUnit);
                content.append(simpleType);
                content.append(SPACE);
                content.append(names[i]);
                ++i;
            }
            content.append(");");
            interfaceType.createMethod(content.toString(), null, false, (IProgressMonitor)new NullProgressMonitor());
            compilationUnit.commitWorkingCopy(false, (IProgressMonitor)new NullProgressMonitor());
            compilationUnit.discardWorkingCopy();
        }
        catch (CoreException ex) {
            CDIUIPlugin.getDefault().logError(ex);
        }
    }

    private void addImport(IType originalType, String simpleName, ICompilationUnit compilationUnit) throws JavaModelException {
        String qualifiedName = EclipseJavaUtil.resolveType((IType)originalType, (String)simpleName);
        CDIMarkerResolutionUtils.addImport((String)qualifiedName, (ICompilationUnit)compilationUnit);
    }

    public String getDescription() {
        return this.label;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_ADD);
    }

    public int getRelevance() {
        return 100;
    }

    public void apply(IDocument document) {
        this.internal_run();
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.label;
    }

    public String getDisplayString() {
        return this.label;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

