/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.search;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.util.BeanPresentationUtil;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.cdi.ui.search.CDIElementWrapper;
import org.jboss.tools.cdi.ui.search.CDIMatch;
import org.jboss.tools.cdi.ui.search.InjectionPointQueryParticipant;
import org.jboss.tools.common.java.IParametedType;

public class CDIBeanQueryParticipant
implements IQueryParticipant {
    static CDIBeanLabelProvider labelProvider = new CDIBeanLabelProvider();

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        if (querySpecification instanceof ElementQuerySpecification) {
            CDICoreNature[] natures;
            if (!this.isSearchForReferences(querySpecification.getLimitTo())) {
                return;
            }
            ElementQuerySpecification qs = (ElementQuerySpecification)querySpecification;
            IJavaElement element = qs.getElement();
            IProject project = element.getJavaProject().getProject();
            ICDIProject cdiProject = CDICorePlugin.getCDIProject((IProject)project, (boolean)true);
            if (cdiProject == null) {
                return;
            }
            this.searchInProject(requestor, querySpecification, cdiProject, monitor, element);
            CDICoreNature[] cDICoreNatureArray = natures = cdiProject.getNature().getAllDependentProjects(true);
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                CDICoreNature nature = cDICoreNatureArray[n2];
                ICDIProject p = nature.getDelegate();
                if (p != null) {
                    this.searchInProject(requestor, querySpecification, p, monitor, element);
                }
                ++n2;
            }
        }
    }

    private void searchInProject(ISearchRequestor requestor, QuerySpecification querySpecification, ICDIProject cdiProject, IProgressMonitor monitor, IJavaElement element) {
        Collection sourceBeans = cdiProject.getBeans(element);
        HashSet injectionPoints = new HashSet();
        for (IBean b : sourceBeans) {
            for (IParametedType t : b.getLegalTypes()) {
                injectionPoints.addAll(cdiProject.getInjections(t.getType().getFullyQualifiedName()));
            }
        }
        monitor.beginTask(CDIUIMessages.CDI_BEAN_QUERY_PARTICIPANT_TASK, injectionPoints.size());
        block2: for (IInjectionPoint injectionPoint : injectionPoints) {
            if (monitor.isCanceled()) break;
            Collection resultBeans = cdiProject.getBeans(false, injectionPoint);
            monitor.worked(1);
            for (IBean cBean : resultBeans) {
                if (!sourceBeans.contains(cBean) || !InjectionPointQueryParticipant.containsInSearchScope(querySpecification, (ICDIElement)cBean)) continue;
                CDIMatch match = new CDIMatch((ICDIElement)injectionPoint);
                requestor.reportMatch((Match)match);
                continue block2;
            }
        }
        monitor.done();
    }

    public boolean isSearchForReferences(int limitTo) {
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        return maskedLimitTo == 2 || maskedLimitTo == 3;
    }

    public int estimateTicks(QuerySpecification specification) {
        return 10;
    }

    public IMatchPresentation getUIParticipant() {
        return new CDIBeanMatchPresentation();
    }

    static class CDIBeanLabelProvider
    implements ILabelProvider {
        CDIBeanLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof CDIElementWrapper) {
                return CDIImages.getImageByElement((ICDIElement)((CDIElementWrapper)element).getCDIElement());
            }
            return CDIImages.getImage((ImageDescriptor)CDIImages.WELD_IMAGE);
        }

        public String getText(Object element) {
            if (element instanceof CDIElementWrapper) {
                ICDIElement cdiElement = ((CDIElementWrapper)element).getCDIElement();
                String kind = BeanPresentationUtil.getCDIElementKind((ICDIElement)cdiElement);
                String text = "";
                if (kind != null) {
                    text = String.valueOf(kind) + " ";
                }
                return String.valueOf(text) + cdiElement.getElementName() + BeanPresentationUtil.getCDIElementLocation((ICDIElement)cdiElement, (boolean)false);
            }
            return "";
        }
    }

    class CDIBeanMatchPresentation
    implements IMatchPresentation {
        CDIBeanMatchPresentation() {
        }

        public ILabelProvider createLabelProvider() {
            return labelProvider;
        }

        public void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
            IJavaElement element;
            if (match instanceof CDIMatch && (element = ((CDIMatch)match).getJavaElement()) != null) {
                try {
                    JavaUI.openInEditor((IJavaElement)element);
                }
                catch (JavaModelException ex) {
                    CDIUIPlugin.getDefault().logError(ex);
                }
                catch (PartInitException ex) {
                    CDIUIPlugin.getDefault().logError(ex);
                }
            }
        }
    }
}

