/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectFirstPage;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.ui.CDIUIMessages;

public class CDIProjectWizard
extends WebProjectWizard
implements IExecutableExtension {
    public static final String CDI10_TEMPALTE = "template.jboss.tools.cdi10";
    public static final String CDI12_TEMPALTE = "template.jboss.tools.cdi12";
    private IPreset oldPreset;
    public static final String ID = "org.jboss.tools.cdi.ui.wizard.NewCDIProjectWizard";
    private FirstPage firstPage;

    public CDIProjectWizard() {
        this.setWindowTitle(CDIUIMessages.CDI_PROJECT_WIZARD_NEW_PROJECT);
    }

    protected IFacetedProjectTemplate getTemplate() {
        return ProjectFacetsManager.getTemplate((String)CDI10_TEMPALTE);
    }

    protected void setRuntimeAndDefaultFacets(IRuntime runtime) {
        IFacetedProjectWorkingCopy dm = this.getFacetedProjectWorkingCopy();
        IPreset preset = dm.getSelectedPreset();
        if (preset != null) {
            this.oldPreset = preset;
        }
        dm.setTargetedRuntimes(Collections.emptySet());
        boolean dontUseRuntimeConfig = false;
        if (runtime != null) {
            if (runtime.supports(IJ2EEFacetConstants.DYNAMIC_WEB_31)) {
                Set facets = ProjectFacetsManager.getTemplate((String)CDI10_TEMPALTE).getInitialPreset().getProjectFacets();
                dm.setProjectFacets(facets);
                dontUseRuntimeConfig = true;
            } else if (this.oldPreset != null) {
                dm.setProjectFacets(this.oldPreset.getProjectFacets());
                dontUseRuntimeConfig = true;
            } else {
                HashSet<IProjectFacetVersion> minFacets = new HashSet<IProjectFacetVersion>();
                try {
                    for (IProjectFacet f : dm.getFixedProjectFacets()) {
                        minFacets.add(f.getLatestSupportedVersion(runtime));
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                dm.setProjectFacets(minFacets);
            }
            dm.setTargetedRuntimes(Collections.singleton(runtime));
        }
        if (dontUseRuntimeConfig) {
            if (dm.getAvailablePresets().contains(this.oldPreset)) {
                dm.setSelectedPreset(this.oldPreset.getId());
            }
        } else if (dm.getAvailablePresets().contains("default.configuration")) {
            dm.setSelectedPreset("default.configuration");
        }
    }

    protected IWizardPage createFirstPage() {
        this.firstPage = new FirstPage(this.model, "first.page");
        return this.firstPage;
    }

    public void setWebVersionCombo(IProjectFacetVersion webFacet) {
        this.firstPage.setWebVersionCombo(webFacet.getVersionString());
        this.firstPage.handlePrimaryFacetVersionSelectedEvent();
    }

    protected ImageDescriptor getDefaultPageImageDescriptor() {
        return CDIImages.getImageDescriptor((String)"wizard/CDIProjectWizBan.png");
    }

    protected String getFinalPerspectiveID() {
        return null;
    }

    class FirstPage
    extends WebProjectFirstPage {
        public FirstPage(IDataModel model, String pageName) {
            super(model, pageName);
            this.setTitle(CDIUIMessages.CDI_PROJECT_WIZARD_NEW_PROJECT_TITLE);
            this.setDescription(CDIUIMessages.CDI_PROJECT_WIZARD_NEW_PROJECT_DESCRIPTION);
            this.setImageDescriptor(CDIProjectWizard.this.getDefaultPageImageDescriptor());
        }

        public boolean isPageComplete() {
            boolean pageComplete = super.isPageComplete();
            IProjectFacet pFacet = ProjectFacetsManager.getProjectFacet((String)"jst.cdi");
            IFacetedProjectWorkingCopy fProject = CDIProjectWizard.this.getFacetedProjectWorkingCopy();
            if (fProject != null) {
                IProjectFacetVersion cdiFacet = fProject.getProjectFacetVersion(pFacet);
                if (cdiFacet == null) {
                    if (pageComplete) {
                        this.setErrorMessage(CDIUIMessages.CDI_PROJECT_WIZARD_PAGE1_CDI_FACET_MUST_BE_SPECIFIED);
                        return false;
                    }
                } else if (pageComplete) {
                    this.setErrorMessage(null);
                } else if (CDIUIMessages.CDI_PROJECT_WIZARD_PAGE1_CDI_FACET_MUST_BE_SPECIFIED.equals(this.getErrorMessage())) {
                    this.setErrorMessage(null);
                }
            }
            return pageComplete;
        }

        protected void handlePrimaryFacetVersionSelectedEvent() {
            super.handlePrimaryFacetVersionSelectedEvent();
            IFacetedProjectWorkingCopy dm = CDIProjectWizard.this.getFacetedProjectWorkingCopy();
            IFacetedProjectTemplate template = dm.hasProjectFacet(IJ2EEFacetConstants.DYNAMIC_WEB_31) ? ProjectFacetsManager.getTemplate((String)CDIProjectWizard.CDI12_TEMPALTE) : ProjectFacetsManager.getTemplate((String)CDIProjectWizard.CDI10_TEMPALTE);
            dm.setFixedProjectFacets(template.getFixedProjectFacets());
            dm.setProjectFacets(template.getInitialPreset().getProjectFacets());
            dm.setSelectedPreset(template.getInitialPreset().getId());
        }

        protected void updatePrimaryVersions() {
            IFacetedProjectWorkingCopy dm = CDIProjectWizard.this.getFacetedProjectWorkingCopy();
            IRuntime runtime = dm.getPrimaryRuntime();
            if (runtime != null) {
                IFacetedProjectTemplate template = null;
                String webFacet = null;
                IPreset defaultPreset = dm.getDefaultConfiguration();
                boolean defaultPresetContainsWeb30 = false;
                if (defaultPreset != null) {
                    Set presetFacets = defaultPreset.getProjectFacets();
                    for (IProjectFacetVersion facetVersion : presetFacets) {
                        if (!facetVersion.equals(IJ2EEFacetConstants.DYNAMIC_WEB_30)) continue;
                        defaultPresetContainsWeb30 = true;
                        break;
                    }
                }
                if (!defaultPresetContainsWeb30 && runtime.supports(IJ2EEFacetConstants.DYNAMIC_WEB_31)) {
                    template = ProjectFacetsManager.getTemplate((String)CDIProjectWizard.CDI12_TEMPALTE);
                    webFacet = IJ2EEFacetConstants.DYNAMIC_WEB_31.getVersionString();
                } else if (runtime.supports(IJ2EEFacetConstants.DYNAMIC_WEB_30)) {
                    template = ProjectFacetsManager.getTemplate((String)CDIProjectWizard.CDI10_TEMPALTE);
                    webFacet = IJ2EEFacetConstants.DYNAMIC_WEB_30.getVersionString();
                }
                if (template != null) {
                    this.setWebVersionCombo(webFacet);
                    dm.setFixedProjectFacets(template.getFixedProjectFacets());
                    dm.setProjectFacets(template.getInitialPreset().getProjectFacets());
                    dm.setSelectedPreset(template.getInitialPreset().getId());
                    return;
                }
            }
            super.updatePrimaryVersions();
        }

        public void setWebVersionCombo(String webFacet) {
            IFacetedProjectWorkingCopy dm = CDIProjectWizard.this.getFacetedProjectWorkingCopy();
            SortedSet initialVersions = dm.getAvailableVersions(this.primaryProjectFacet);
            String[] items = new String[initialVersions.size()];
            int i = 0;
            int selectedVersionIndex = -1;
            Iterator iterator = initialVersions.iterator();
            while (iterator.hasNext()) {
                items[i] = ((IProjectFacetVersion)iterator.next()).getVersionString();
                if (selectedVersionIndex == -1 && items[i].equals(webFacet)) {
                    selectedVersionIndex = i;
                }
                ++i;
            }
            this.primaryVersionCombo.clearSelection();
            this.primaryVersionCombo.setItems(items);
            this.primaryVersionCombo.select(selectedVersionIndex);
        }
    }
}

