/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.ui.wizards.NewAnnotationWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.cdi.core.CDICoreMessages;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.wizard.CheckBoxEditorWrapper;
import org.jboss.tools.common.ui.widget.editor.CheckBoxFieldEditor;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.ITaggedFieldEditor;
import org.jboss.tools.common.ui.widget.editor.LabelFieldEditor;

public abstract class NewCDIAnnotationWizardPage
extends NewAnnotationWizardPage {
    protected CheckBoxEditorWrapper inherited = null;
    protected IFieldEditor target = null;

    public NewCDIAnnotationWizardPage() {
        this.setImageDescriptor(CDIImages.getImageDescriptor((String)"wizard/CDIAnnotationWizBan.png"));
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        ISourceRange range = newType.getSourceRange();
        IBuffer buf = newType.getCompilationUnit().getBuffer();
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)newType.getJavaProject());
        StringBuffer sb = new StringBuffer();
        this.addAnnotations(imports, sb, lineDelimiter);
        buf.replace(range.getOffset(), 0, sb.toString());
    }

    protected abstract void addAnnotations(NewTypeWizardPage.ImportsManager var1, StringBuffer var2, String var3);

    protected void addTargetAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter, String[] targets) {
        if (targets.length == 0) {
            return;
        }
        imports.addImport("java.lang.annotation.Target");
        StringBuffer list = new StringBuffer();
        int i = 0;
        while (i < targets.length) {
            imports.addImport("static java.lang.annotation.ElementType." + targets[i]);
            if (i > 0) {
                list.append(", ");
            }
            list.append(targets[i]);
            ++i;
        }
        sb.append("@Target( {" + list.toString() + "} )").append(lineDelimiter);
    }

    static void addAnnotation(String typeName, NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        int i = typeName.lastIndexOf(46);
        String name = typeName.substring(i + 1);
        imports.addImport(typeName);
        sb.append("@").append(name).append(lineDelimiter);
    }

    protected void addInheritedAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.inherited != null && this.inherited.composite.getValue() == Boolean.TRUE) {
            NewCDIAnnotationWizardPage.addAnnotation("java.lang.annotation.Inherited", imports, sb, lineDelimiter);
        }
    }

    protected void addRetentionAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        imports.addImport("java.lang.annotation.Retention");
        imports.addImport("static java.lang.annotation.RetentionPolicy.RUNTIME");
        sb.append("@Retention(RUNTIME)").append(lineDelimiter);
    }

    protected void addDocumentedAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        NewCDIAnnotationWizardPage.addAnnotation("java.lang.annotation.Documented", imports, sb, lineDelimiter);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createCustomFields(composite);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_annotation_wizard_page_context");
    }

    protected abstract void createCustomFields(Composite var1);

    protected CheckBoxEditorWrapper createCheckBoxField(Composite composite, String name, String label, boolean defaultValue) {
        CheckBoxEditorWrapper wrapper = new CheckBoxEditorWrapper();
        wrapper.checkBox = new CheckBoxFieldEditor(name, label, (Object)defaultValue);
        CompositeEditor editor = new CompositeEditor(name, label, (Object)defaultValue);
        editor.addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, ""), wrapper.checkBox});
        wrapper.composite = editor;
        wrapper.composite.doFillIntoGrid((Object)composite);
        ((Button)wrapper.checkBox.getCheckBoxControl()).setText(label);
        return wrapper;
    }

    protected void createInheritedField(Composite composite, boolean defaultValue) {
        String label = "Add @Inherited";
        this.inherited = this.createCheckBoxField(composite, "isInherited", label, defaultValue);
    }

    protected void createTargetField(Composite composite, List<String> values) {
        this.target = this.createComboField("Target", CDIUIMessages.FIELD_EDITOR_TARGET_LABEL, composite, values);
    }

    protected ITaggedFieldEditor createComboField(String name, String label, Composite composite, List<String> values) {
        ITaggedFieldEditor result = IFieldEditorFactory.INSTANCE.createComboEditor(name, label, values, (Object)values.get(0));
        ((CompositeEditor)result).addFieldEditors(new IFieldEditor[]{new LabelFieldEditor(name, "")});
        result.doFillIntoGrid((Object)composite);
        Combo combo = (Combo)result.getEditorControls()[1];
        Object layoutData = combo.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).horizontalAlignment = 4;
        }
        return result;
    }

    protected String[] getTargets() {
        if (this.target == null) {
            return new String[]{"TYPE", "METHOD", "PARAMETER", "FIELD"};
        }
        String value = (String)this.target.getValue();
        String[] vs = value.length() == 0 ? new String[]{} : value.split(",");
        int i = 0;
        while (i < vs.length) {
            vs[i] = vs[i].trim();
            ++i;
        }
        return vs;
    }

    public void setInherited(boolean b) {
        if (this.inherited != null) {
            this.inherited.composite.setValue((Object)b);
        }
    }

    public void setTarget(String s) {
        if (this.target != null) {
            ((CompositeEditor)this.target).setValue((Object)s);
        }
    }

    static ICDIProject getCDIProject(IJavaProject jp) {
        CDICoreNature n = NewCDIAnnotationWizardPage.getCDINatureWithProgress(jp.getProject());
        return n == null ? null : n.getDelegate();
    }

    public static CDICoreNature getCDINatureWithProgress(IProject project) {
        final CDICoreNature cdiNature = CDICorePlugin.getCDI((IProject)project, (boolean)false);
        if (cdiNature != null && !cdiNature.isStorageResolved()) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(CDICoreMessages.CDI_UTIL_BUILD_CDI_MODEL, 10);
                        monitor.worked(3);
                        cdiNature.resolve();
                        monitor.worked(7);
                    }
                });
            }
            catch (InterruptedException ie) {
                CDICorePlugin.getDefault().logError((Throwable)ie);
            }
            catch (InvocationTargetException ite) {
                CDICorePlugin.getDefault().logError((Throwable)ite);
            }
        }
        return cdiNature;
    }
}

