/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.wizard.BeansXMLAccess;
import org.jboss.tools.cdi.ui.wizard.InterceptorBindingSelectionProvider;
import org.jboss.tools.cdi.ui.wizard.NewCDIAnnotationWizardPage;
import org.jboss.tools.common.java.generation.JavaBeanGenerator;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.widget.editor.LabelFieldEditor;

public class NewDecoratorWizardPage
extends NewClassWizardPage {
    protected InterceptorBindingSelectionProvider interceptorBindingsProvider = new InterceptorBindingSelectionProvider();
    IFieldEditor fieldName = null;
    String defaultTypeName = null;
    String defaultFieldName = null;
    protected StatusInfo fieldNameStatus = new StatusInfo();
    protected boolean mayBeRegisteredInBeansXML = true;
    protected BeansXMLAccess registerInBeansXML = new BeansXMLAccess((NewTypeWizardPage)this, "Decorators", "CDIClass", "class");

    public NewDecoratorWizardPage() {
        this.setTitle(CDIUIMessages.NEW_DECORATOR_WIZARD_PAGE_NAME);
        this.setDescription(CDIUIMessages.NEW_DECORATOR_WIZARD_DESCRIPTION);
        this.setImageDescriptor(CDIImages.getImageDescriptor((String)"wizard/CDIClassWizBan.png"));
    }

    public void setMayBeRegisteredInBeansXML(boolean b) {
        this.mayBeRegisteredInBeansXML = b;
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        this.defaultTypeName = null;
        this.defaultFieldName = null;
        if (selection != null && !selection.isEmpty()) {
            Object o = selection.iterator().next();
            IType type = null;
            if (o instanceof IType) {
                type = (IType)o;
            } else if (o instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)o;
                try {
                    IType[] ts = cu.getTypes();
                    if (ts != null && ts.length > 0) {
                        type = ts[0];
                    }
                }
                catch (JavaModelException e) {
                    CDICorePlugin.getDefault().logError((Throwable)e);
                }
            }
            boolean isInterface = false;
            try {
                isInterface = type != null && type.isInterface();
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError((Throwable)e);
            }
            if (isInterface) {
                ArrayList<String> interfacesNames = new ArrayList<String>();
                String name = "";
                try {
                    name = type.getFullyQualifiedParameterizedName();
                }
                catch (JavaModelException javaModelException) {
                    name = type.getFullyQualifiedName();
                }
                interfacesNames.add(name);
                this.setSuperInterfaces(interfacesNames, true);
                this.superInterfacesChanged();
                this.setDefaultTypeName(name);
            }
        }
        this.setModifiers(this.getModifiers() | 0x400, true);
        this.doStatusUpdate();
    }

    void setDefaultTypeName(String interfaceName) {
        boolean isDefault;
        int d = interfaceName.lastIndexOf(46);
        int b = interfaceName.indexOf(60);
        if (b < 0) {
            b = interfaceName.length();
        }
        String elementName = interfaceName.substring(d + 1, b);
        String typeName = String.valueOf(elementName) + "Decorator";
        typeName = String.valueOf(typeName) + interfaceName.substring(b);
        String currentTypeName = this.getTypeName();
        boolean bl = isDefault = currentTypeName == null || currentTypeName.length() == 0 || currentTypeName.equals(this.defaultTypeName);
        if (isDefault) {
            this.setTypeName(typeName, true);
            this.typeNameChanged();
        }
        this.defaultTypeName = typeName;
        String _defaultFieldName = elementName;
        if (_defaultFieldName.length() > 0) {
            _defaultFieldName = String.valueOf(_defaultFieldName.substring(0, 1).toLowerCase()) + _defaultFieldName.substring(1);
            if (this.fieldName != null) {
                String currentFieldName = this.fieldName.getValueAsString();
                boolean bl2 = isDefault = currentFieldName == null || currentFieldName.length() == 0 || currentFieldName.equals(this.defaultFieldName);
                if (isDefault) {
                    this.fieldName.setValue((Object)_defaultFieldName);
                }
                this.defaultFieldName = _defaultFieldName;
            }
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createCustomFields(composite);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
        this.doStatusUpdate();
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(newType, true, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ISourceRange range = newType.getSourceRange();
        IBuffer buf = newType.getCompilationUnit().getBuffer();
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)newType.getJavaProject());
        StringBuffer sb = new StringBuffer();
        this.addAnnotations(imports, sb, lineDelimiter);
        buf.replace(range.getOffset(), 0, sb.toString());
        this.createDelegateField(newType, imports, monitor, lineDelimiter);
        this.modifyMethodContent(newType, imports, monitor, lineDelimiter);
    }

    void addAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        this.addDecoratorAnnotation(imports, sb, lineDelimiter);
    }

    protected void addDecoratorAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        NewCDIAnnotationWizardPage.addAnnotation("javax.decorator.Decorator", imports, sb, lineDelimiter);
    }

    protected void createCustomFields(Composite composite) {
        this.createFieldNameField(composite);
        this.createRegisterInBeansXML(composite);
    }

    protected void createFieldNameField(Composite composite) {
        String label = "Delegate Field Name:";
        List is = this.getSuperInterfaces();
        String defaultFieldName = "";
        if (is != null && !is.isEmpty()) {
            defaultFieldName = is.get(0).toString();
            int i = defaultFieldName.lastIndexOf(46);
            if (i >= 0) {
                defaultFieldName = defaultFieldName.substring(i + 1);
            }
            if (defaultFieldName.length() > 0) {
                defaultFieldName = String.valueOf(defaultFieldName.substring(0, 1).toLowerCase()) + defaultFieldName.substring(1);
            }
            if ((i = defaultFieldName.indexOf(60)) >= 0) {
                defaultFieldName = defaultFieldName.substring(0, i);
            }
        }
        this.fieldName = IFieldEditorFactory.INSTANCE.createTextEditor("fieldName", label, defaultFieldName);
        ((CompositeEditor)this.fieldName).addFieldEditors(new IFieldEditor[]{new LabelFieldEditor("fieldName", "")});
        this.fieldName.doFillIntoGrid((Object)composite);
        this.fieldName.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewDecoratorWizardPage.this.onFieldNameChange();
                NewDecoratorWizardPage.this.doStatusUpdate();
            }
        });
    }

    void onFieldNameChange() {
        String methodName = this.fieldName.getValueAsString();
        this.fieldNameStatus = new StatusInfo();
        if (methodName.length() == 0) {
            this.fieldNameStatus.setError(CDIUIMessages.MESSAGE_FIELD_NAME_EMPTY);
            return;
        }
        IStatus val = JavaConventionsUtil.validateMethodName((String)methodName, null);
        if (val != null && val.getSeverity() == 4) {
            this.fieldNameStatus.setError(NLS.bind((String)CDIUIMessages.MESSAGE_FIELD_NAME_NOT_VALID, (Object)val.getMessage()));
        }
    }

    protected void createRegisterInBeansXML(Composite composite) {
        if (!this.mayBeRegisteredInBeansXML) {
            return;
        }
        this.registerInBeansXML.create(composite);
    }

    protected IField createDelegateField(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, String lineDelimiter) throws CoreException {
        int i;
        String fieldName = "" + this.fieldName.getValue();
        imports.addImport("javax.interceptor.InvocationContext");
        imports.addImport("javax.interceptor.AroundInvoke");
        imports.addImport("javax.inject.Inject");
        imports.addImport("javax.enterprise.inject.Any");
        imports.addImport("javax.decorator.Delegate");
        ICompilationUnit cu = type.getCompilationUnit();
        JavaModelUtil.reconcile((ICompilationUnit)cu);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject());
        settings.createComments = this.isAddComments();
        String access = "private";
        String javatype = "Object";
        List is = this.getSuperInterfaces();
        if (is != null && (i = 0) < is.size()) {
            String in = is.get(i).toString();
            int d = in.lastIndexOf(46);
            if (d >= 0) {
                in = in.substring(d + 1);
            }
            javatype = in;
        }
        String fieldHeader = "@Inject @Delegate @Any " + access + " " + javatype + " " + fieldName + ";" + lineDelimiter;
        IJavaElement[] cs = type.getChildren();
        IJavaElement sibling = cs == null || cs.length == 0 ? null : cs[0];
        IField m = type.createField(fieldHeader, sibling, true, null);
        this.editField(cu, m, javatype, fieldHeader, lineDelimiter);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void editField(ICompilationUnit cu, IField m, String javatype, String fieldHeader, String lineDelimiter) throws CoreException {
        ICompilationUnit iCompilationUnit = cu;
        synchronized (iCompilationUnit) {
            cu.reconcile(0, true, null, null);
        }
        ISourceRange range = m.getSourceRange();
        IBuffer buf = cu.getBuffer();
        StringBuffer sb = new StringBuffer(lineDelimiter);
        if (this.isAddComments()) {
            String fieldComment = CodeGeneration.getFieldComment((ICompilationUnit)cu, (String)javatype, (String)m.getElementName(), (String)lineDelimiter);
            sb.append(fieldComment).append(lineDelimiter);
        }
        sb.append(fieldHeader);
        String formattedContent = JavaBeanGenerator.codeFormat2((int)4, (String)sb.toString(), (int)1, (String)lineDelimiter, (IJavaProject)cu.getJavaProject());
        if (formattedContent != null && formattedContent.startsWith("\t")) {
            formattedContent = formattedContent.substring(1);
        }
        buf.replace(range.getOffset(), range.getLength(), formattedContent);
    }

    protected IStatus superInterfacesChanged() {
        StatusInfo result;
        List list = this.getSuperInterfaces();
        if (list != null && !list.isEmpty()) {
            this.setDefaultTypeName(list.get(0).toString());
        }
        if (!(result = (StatusInfo)super.superInterfacesChanged()).isError() && (list == null || list.isEmpty())) {
            result.setError("Please select decorated type.");
        }
        return result;
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        if (!CDIUIMessages.NEW_DECORATOR_WIZARD_DESCRIPTION.equals(this.getDescription())) {
            this.setDescription(CDIUIMessages.NEW_DECORATOR_WIZARD_DESCRIPTION);
        }
        IStatus[] ns = new IStatus[status.length + 1];
        System.arraycopy(status, 0, ns, 0, status.length);
        ns[status.length] = this.fieldNameStatus;
        status = ns;
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyMethodContent(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, String lineDelimiter) throws CoreException {
        IMethod[] ms = type.getMethods();
        int i = 0;
        while (i < ms.length) {
            block9: {
                StringBuffer sb;
                int end;
                int start;
                IBuffer buf;
                block11: {
                    ISourceRange range;
                    block10: {
                        ICompilationUnit cu;
                        if (ms[i].isConstructor()) break block9;
                        ICompilationUnit iCompilationUnit = cu = type.getCompilationUnit();
                        synchronized (iCompilationUnit) {
                            cu.reconcile(0, true, null, null);
                        }
                        buf = cu.getBuffer();
                        range = ms[i].getSourceRange();
                        start = -1;
                        end = -1;
                        sb = new StringBuffer();
                        if (!"void".equals(ms[i].getReturnType()) && !"V".equals(ms[i].getReturnType())) break block10;
                        end = buf.getContents().indexOf("}", range.getOffset());
                        if (end < 0 || (end = buf.getContents().lastIndexOf(lineDelimiter, end)) < 0 || end < range.getOffset()) break block9;
                        start = end;
                        break block11;
                    }
                    start = buf.getContents().indexOf("return", range.getOffset());
                    if (start < 0 || start > range.getOffset() + range.getLength() || (end = buf.getContents().indexOf(";", start += 7)) < 0) break block9;
                    ++end;
                }
                String fieldName = "" + this.fieldName.getValue();
                String methodName = ms[i].getElementName();
                String[] ps = ms[i].getParameterNames();
                sb.append(fieldName).append('.').append(methodName).append('(');
                int k = 0;
                while (k < ps.length) {
                    if (k > 0) {
                        sb.append(", ");
                    }
                    sb.append(ps[k]);
                    ++k;
                }
                sb.append(");");
                buf.replace(start, end - start, sb.toString());
            }
            ++i;
        }
    }

    public boolean isToBeRegisteredInBeansXML() {
        return this.registerInBeansXML.isSelected();
    }

    public void setVisible(boolean visible) {
        if (!this.getControl().isVisible() && visible && this.fSuperInterfacesStatus.matches(4) && !this.fTypeNameStatus.matches(4)) {
            this.setDescription(this.fSuperInterfacesStatus.getMessage());
        }
        super.setVisible(visible);
    }

    protected String getSuperInterfacesLabel() {
        return CDIUIMessages.NEW_DECORATOR_WIZARD_INTERFACES_LABEL;
    }

    protected IStatus packageChanged() {
        IStatus result = super.packageChanged();
        if (result != null && result.isOK()) {
            this.interceptorBindingsProvider.setPackageFragment(this.getPackageFragment());
        }
        this.registerInBeansXML.validate();
        return result;
    }

    protected IStatus typeNameChanged() {
        IStatus result = super.typeNameChanged();
        this.registerInBeansXML.validate();
        return result;
    }
}

