/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.cdi.ui.wizard.InterceptorBindingSelectionProvider;
import org.jboss.tools.cdi.ui.wizard.NewCDIAnnotationWizardPage;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.ListFieldEditor;

public class NewInterceptorBindingWizardPage
extends NewCDIAnnotationWizardPage {
    protected InterceptorBindingSelectionProvider interceptorBindingsProvider = new InterceptorBindingSelectionProvider();
    protected ListFieldEditor interceptorBindings = null;
    protected StatusInfo targetStatus = new StatusInfo();

    public NewInterceptorBindingWizardPage() {
        this.setTitle(CDIUIMessages.NEW_INTERCEPTOR_BINDING_WIZARD_PAGE_NAME);
    }

    @Override
    protected void addAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        this.addInterceptorBindingAnnotation(imports, sb, lineDelimiter);
        this.addInheritedAnnotation(imports, sb, lineDelimiter);
        this.addInterceptorBindingAnnotations(imports, sb, lineDelimiter);
        this.addTargetAnnotation(imports, sb, lineDelimiter, this.getTargets());
        this.addRetentionAnnotation(imports, sb, lineDelimiter);
        this.addDocumentedAnnotation(imports, sb, lineDelimiter);
    }

    protected void addInterceptorBindingAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        NewInterceptorBindingWizardPage.addAnnotation("javax.interceptor.InterceptorBinding", imports, sb, lineDelimiter);
    }

    protected void addInterceptorBindingAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.interceptorBindings != null) {
            List list = (List)this.interceptorBindings.getValue();
            for (Object o : list) {
                if (!(o instanceof ICDIAnnotation)) continue;
                ICDIAnnotation a = (ICDIAnnotation)o;
                String typeName = a.getSourceType().getFullyQualifiedName();
                NewInterceptorBindingWizardPage.addAnnotation(typeName, imports, sb, lineDelimiter);
            }
        }
    }

    @Override
    protected void createCustomFields(Composite composite) {
        this.createInheritedField(composite, true);
        this.createTargetField(composite);
        this.createInterceptorBindingField(composite);
    }

    protected void createTargetField(Composite composite) {
        ArrayList<String> targetOptions = new ArrayList<String>();
        targetOptions.add("TYPE,METHOD");
        targetOptions.add("TYPE");
        this.createTargetField(composite, targetOptions);
        this.target.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewInterceptorBindingWizardPage.this.validateTargetAndInterceptorBinding();
            }
        });
    }

    protected void createInterceptorBindingField(Composite composite) {
        this.interceptorBindings = new ListFieldEditor("interceptorBindings", CDIUIMessages.FIELD_EDITOR_INTERCEPTOR_BINDINGS_LABEL, new ArrayList());
        this.interceptorBindings.setProvider((ListFieldEditor.ListFieldEditorProvider)this.interceptorBindingsProvider);
        this.interceptorBindingsProvider.setEditorField((IFieldEditor)this.interceptorBindings);
        this.interceptorBindings.doFillIntoGrid((Object)composite);
        this.setInterceptorBindings(this.getPackageFragmentRoot());
        this.interceptorBindings.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewInterceptorBindingWizardPage.this.validateTargetAndInterceptorBinding();
            }
        });
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        super.setPackageFragmentRoot(root, canBeModified);
        this.setInterceptorBindings(root);
    }

    void setInterceptorBindings(IPackageFragmentRoot root) {
        IJavaProject jp;
        ICDIProject cdi;
        this.interceptorBindingsProvider.setProject(null);
        if (root != null && (cdi = NewInterceptorBindingWizardPage.getCDIProject(jp = root.getJavaProject())) != null) {
            this.interceptorBindingsProvider.setProject(cdi);
        }
    }

    void validateTargetAndInterceptorBinding() {
        try {
            this.getTargetAndInterceptorBindingError();
        }
        catch (JavaModelException e) {
            CDIUIPlugin.getDefault().logError(e);
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        IStatus[] ns = new IStatus[status.length + 1];
        System.arraycopy(status, 0, ns, 0, status.length);
        ns[status.length] = this.targetStatus;
        status = ns;
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    void getTargetAndInterceptorBindingError() throws JavaModelException {
        this.targetStatus = new StatusInfo();
        if (this.interceptorBindings != null && this.target != null) {
            String value = (String)this.target.getValue();
            boolean hasMethodOrField = value != null && (value.indexOf("METHOD") >= 0 || value.indexOf("FIELD") >= 0);
            List list = (List)this.interceptorBindings.getValue();
            for (Object o : list) {
                Set targets;
                IInterceptorBinding a;
                IAnnotationDeclaration target;
                if (!(o instanceof IInterceptorBinding) || (target = (a = (IInterceptorBinding)o).getAnnotationDeclaration("java.lang.annotation.Target")) == null || (targets = CDIUtil.getTargetAnnotationValues((IAnnotationDeclaration)target)) == null || targets.size() != 1 || !targets.contains("TYPE") || !hasMethodOrField) continue;
                String message = NLS.bind((String)CDIUIMessages.MESSAGE_INTERCEPTOR_BINDING_IS_NOT_COMPATIBLE, (Object)a.getSourceType().getElementName());
                this.targetStatus.setWarning(message);
            }
        }
    }

    public void addInterceptorBinding(IInterceptorBinding s) {
        List vs = (List)this.interceptorBindings.getValue();
        ArrayList<IInterceptorBinding> nvs = new ArrayList<IInterceptorBinding>();
        if (vs != null) {
            nvs.addAll(vs);
        }
        nvs.add(s);
        this.interceptorBindings.setValue(nvs);
    }
}

