/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.ui.widget.editor.ListFieldEditor;

public class SelectCDIAnnotationDialog
extends FilteredItemsSelectionDialog {
    private static final String FILE_NAME = "SelectCDIAnnotationHistory.xml";
    private static final String ROOT_NODE = "historyRootNode";
    private static final String INFO_NODE = "infoNode";
    private static final String PROJECT_NAME = "ProjectName";
    private static final String COMPONENT_NAME = "ComponentName";
    private static final String DELETED = "Deleted";
    private static final String SEPARATOR = " - ";
    private static final String YES = "yes";
    private static final String NO = "no";
    ListFieldEditor.ListFieldEditorProvider<ICDIAnnotation> provider = null;

    public SelectCDIAnnotationDialog(Shell shell, boolean multi) {
        super(shell, multi);
        this.setSelectionHistory(new SeamComponentSelectionHistory());
        this.setListLabelProvider(new CDIAnnotationLabelProvider());
        this.setDetailsLabelProvider(new CDIAnnotationLabelProvider());
        XMLMemento memento = SelectCDIAnnotationDialog.loadMemento();
        if (memento != null) {
            this.getSelectionHistory().load((IMemento)memento);
        }
    }

    public void setProvider(ListFieldEditor.ListFieldEditorProvider<ICDIAnnotation> provider) {
        this.provider = provider;
    }

    public void startSearch() {
        this.applyFilter();
    }

    public void okPressed() {
        super.okPressed();
    }

    public void stopSearchAndShowResults() {
        this.refresh();
        List list = this.getSelectedItems().toList();
        Collections.sort(list, this.getItemsComparator());
        this.setResult(list);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new CDIAnnotionFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.subTask("Wait");
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException interruptedException) {}
        if (this.provider != null) {
            ICDIAnnotation[] as;
            ICDIAnnotation[] iCDIAnnotationArray = as = (ICDIAnnotation[])this.provider.getSelectableObjects();
            int n = as.length;
            int n2 = 0;
            while (n2 < n) {
                ICDIAnnotation component = iCDIAnnotationArray[n2];
                IProject project = component.getCDIProject().getNature().getProject();
                contentProvider.add((Object)new CDIAnnotationWrapper(component.getSourceType().getFullyQualifiedName(), project.getName(), component), itemsFilter);
                ++n2;
            }
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    private static XMLMemento loadMemento() {
        XMLMemento memento = null;
        IPath stateLocation = CDIUIPlugin.getDefault().getStateLocation().append(FILE_NAME);
        File file = new File(stateLocation.toOSString());
        if (file.exists()) {
            InputStreamReader reader = null;
            try {
                try {
                    reader = new FileReader(file);
                    memento = XMLMemento.createReadRoot((Reader)reader);
                }
                catch (IOException ex) {
                    CDIUIPlugin.getDefault().logError(ex);
                    try {
                        reader.close();
                    }
                    catch (IOException ex2) {
                        CDIUIPlugin.getDefault().logError(ex2);
                    }
                }
                catch (WorkbenchException ex) {
                    CDIUIPlugin.getDefault().logError(ex);
                    try {
                        reader.close();
                    }
                    catch (IOException ex3) {
                        CDIUIPlugin.getDefault().logError(ex3);
                    }
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    CDIUIPlugin.getDefault().logError(ex);
                }
            }
        }
        return memento;
    }

    private static void saveMemento(XMLMemento xmlMemento) {
        IPath stateLocation = CDIUIPlugin.getDefault().getStateLocation().append(FILE_NAME);
        File file = new File(stateLocation.toOSString());
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                xmlMemento.save((Writer)writer);
            }
            catch (IOException ex) {
                CDIUIPlugin.getDefault().logError(ex);
                try {
                    writer.close();
                }
                catch (IOException ex2) {
                    CDIUIPlugin.getDefault().logError(ex2);
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {
                CDIUIPlugin.getDefault().logError(ex);
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings("OPEN_CDI_COMPONENT_DIALOG_NAME");
    }

    public String getElementName(Object item) {
        if (item instanceof CDIAnnotationWrapper) {
            CDIAnnotationWrapper componentWrapper = (CDIAnnotationWrapper)item;
            return componentWrapper.getComponentName();
        }
        return null;
    }

    protected Comparator<CDIAnnotationWrapper> getItemsComparator() {
        return new CDIAnnotationComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(this.getSelectedItems().size() >= 0 ? 0 : 4, "org.jboss.tools.cdi.ui", null);
    }

    public class CDIAnnotationComparator
    implements Comparator<CDIAnnotationWrapper> {
        @Override
        public int compare(CDIAnnotationWrapper left, CDIAnnotationWrapper right) {
            return left.getComponentName().compareTo(right.getComponentName());
        }
    }

    public class CDIAnnotationLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof CDIAnnotationWrapper) {
                return CDIImages.getImageByElement((ICDIElement)((CDIAnnotationWrapper)element).getComponent());
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CDIAnnotationWrapper) {
                CDIAnnotationWrapper a = (CDIAnnotationWrapper)element;
                return String.valueOf(a.getComponentName()) + SelectCDIAnnotationDialog.SEPARATOR + a.getProjectName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class CDIAnnotationWrapper {
        private String componentName;
        private String projectName;
        private ICDIAnnotation component;

        public CDIAnnotationWrapper(String componentName, String projectName) {
            this.componentName = componentName;
            this.projectName = projectName;
        }

        public CDIAnnotationWrapper(String componentName, String projectName, ICDIAnnotation component) {
            this(componentName, projectName);
            this.component = component;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public ICDIAnnotation getComponent() {
            if (this.component == null) {
                ICDIProject cdiProject;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
                if (project != null && (cdiProject = CDICorePlugin.getCDIProject((IProject)project, (boolean)true)) != null) {
                    IInterceptorBinding component = cdiProject.getInterceptorBinding(this.componentName);
                    if (component == null) {
                        cdiProject.getStereotype(this.componentName);
                    }
                    return component;
                }
                return null;
            }
            return this.component;
        }

        public boolean equals(Object o) {
            if (o instanceof CDIAnnotationWrapper) {
                CDIAnnotationWrapper other = (CDIAnnotationWrapper)o;
                return this.componentName.equals(other.componentName) && this.projectName.equals(other.projectName);
            }
            return false;
        }
    }

    public class CDIAnnotionFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public CDIAnnotionFilter() {
            super((FilteredItemsSelectionDialog)SelectCDIAnnotationDialog.this);
            if (this.patternMatcher != null && this.patternMatcher.getPattern() == null || this.patternMatcher.getPattern().length() == 0) {
                this.patternMatcher.setPattern("*");
            }
        }

        public CDIAnnotionFilter(SearchPattern searchPattern) {
            super((FilteredItemsSelectionDialog)SelectCDIAnnotationDialog.this, searchPattern);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            if (item instanceof CDIAnnotationWrapper) {
                int lastIndex;
                String pattern;
                CDIAnnotationWrapper componentWrapper = (CDIAnnotationWrapper)item;
                String qName = componentWrapper.getComponentName();
                boolean result = this.patternMatcher.matches(qName);
                if (!result && (pattern = this.patternMatcher.getPattern()).indexOf(".") < 0 && (lastIndex = qName.lastIndexOf(".")) >= 0 && lastIndex + 1 < qName.length()) {
                    return this.patternMatcher.matches(qName.substring(lastIndex + 1));
                }
                return result;
            }
            return false;
        }
    }

    public class SeamComponentSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        protected Object restoreItemFromMemento(IMemento memento) {
            XMLMemento mem = (XMLMemento)memento;
            String projectName = mem.getString(SelectCDIAnnotationDialog.PROJECT_NAME);
            if (projectName == null) {
                return null;
            }
            String componentName = mem.getString(SelectCDIAnnotationDialog.COMPONENT_NAME);
            if (componentName == null) {
                return null;
            }
            String componentDeleted = mem.getString(SelectCDIAnnotationDialog.DELETED);
            if (componentDeleted != null && SelectCDIAnnotationDialog.YES.equals(componentDeleted)) {
                return null;
            }
            return new CDIAnnotationWrapper(componentName, projectName);
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }

        public void save(IMemento memento) {
            super.save(memento);
            if (!(memento instanceof XMLMemento)) {
                return;
            }
            XMLMemento xmlMemento = (XMLMemento)memento;
            SelectCDIAnnotationDialog.saveMemento(xmlMemento);
        }
    }
}

