/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard.xpl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SearchPattern;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.internal.core.refactoring.ValuedQualifier;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.cdi.ui.wizard.AbstractModifyInjectionPointWizard;
import org.jboss.tools.cdi.ui.wizard.AddQualifiersToBeanWizardPage;
import org.jboss.tools.cdi.ui.wizard.NewQualifierCreationWizard;

public class AddQualifiersToBeanComposite
extends Composite {
    private static Font font;
    private IInjectionPoint injectionPoint;
    private IBean selectedBean;
    private List<IBean> beans;
    private AddQualifiersToBeanWizardPage page;
    private Text pattern;
    private ArrayList<ValuedQualifier> originalQualifiers = new ArrayList();
    private ArrayList<ValuedQualifier> qualifiers = new ArrayList();
    private ArrayList<ValuedQualifier> deployed = new ArrayList();
    private TableViewer availableTableViewer;
    private TableViewer deployedTableViewer;
    private Button add;
    private Button addAll;
    private Button remove;
    private Button editQualifierValue;
    private Button removeAll;
    private Label nLabel;
    protected boolean isComplete = false;
    private boolean hasDefaultQualifier = false;
    private ValuedQualifier defaultQualifier;
    private ValuedQualifier namedQualifier;
    private ILabelProvider labelProvider = new QualifiersListLabelProvider();

    public AddQualifiersToBeanComposite(Composite parent, AddQualifiersToBeanWizardPage page) {
        super(parent, 0);
        this.page = page;
        this.injectionPoint = ((AbstractModifyInjectionPointWizard)page.getWizard()).getInjectionPoint();
        this.selectedBean = ((AbstractModifyInjectionPointWizard)page.getWizard()).getSelectedBean();
        this.beans = ((AbstractModifyInjectionPointWizard)page.getWizard()).getBeans();
        this.createControl();
        if (this.selectedBean != null) {
            this.init();
        }
        page.setDeployedQualifiers(this.getDeployedQualifiers());
    }

    public void init() {
        this.selectedBean = ((AbstractModifyInjectionPointWizard)this.page.getWizard()).getSelectedBean();
        String beanName = CDIMarkerResolutionUtils.getELName((IBean)this.selectedBean);
        this.originalQualifiers.clear();
        this.deployed.clear();
        for (IQualifier iQualifier : this.selectedBean.getQualifiers()) {
            IQualifierDeclaration declaration = CDIMarkerResolutionUtils.findQualifierDeclaration((IBean)this.selectedBean, (IQualifier)iQualifier);
            if (declaration != null) {
                ValuedQualifier vq = new ValuedQualifier(iQualifier, declaration);
                this.deployed.add(vq);
                continue;
            }
            this.originalQualifiers.add(new ValuedQualifier(iQualifier));
        }
        this.defaultQualifier = new ValuedQualifier(this.selectedBean.getCDIProject().getQualifier("javax.enterprise.inject.Default"));
        this.namedQualifier = new ValuedQualifier(this.selectedBean.getCDIProject().getQualifier("javax.inject.Named"));
        this.namedQualifier.setValue("value", beanName);
        for (ValuedQualifier valuedQualifier : this.originalQualifiers) {
            if (!valuedQualifier.equals((Object)this.defaultQualifier)) continue;
            this.hasDefaultQualifier = true;
            break;
        }
        ArrayList<ValuedQualifier> arrayList = new ArrayList<ValuedQualifier>();
        arrayList.addAll(this.originalQualifiers);
        arrayList.addAll(this.deployed);
        this.deployedTableViewer.setInput(arrayList);
        this.qualifiers.clear();
        this.loadAvailableQualifiers();
        this.availableTableViewer.setInput(this.qualifiers);
        if (this.nLabel != null) {
            this.nLabel.setText(MessageFormat.format(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_MESSAGE, this.selectedBean.getElementName(), this.injectionPoint.getElementName()));
        }
        this.refresh();
    }

    private ValuedQualifier loadAvailableQualifiers() {
        IQualifier[] qs;
        String beanName = CDIMarkerResolutionUtils.getELName((IBean)this.selectedBean);
        ValuedQualifier lastQualifier = null;
        String beanTypeName = this.selectedBean.getBeanClass().getFullyQualifiedName();
        String beanPackage = beanTypeName.substring(0, beanTypeName.lastIndexOf("."));
        IJavaProject beanJavaProject = this.selectedBean.getBeanClass().getJavaProject();
        String injectionPointTypeName = this.injectionPoint.getClassBean().getBeanClass().getFullyQualifiedName();
        String injectionPointPackage = injectionPointTypeName.substring(0, injectionPointTypeName.lastIndexOf("."));
        IJavaProject injectionPointJavaProject = this.injectionPoint.getBean().getBeanClass().getJavaProject();
        boolean samePackage = beanPackage.equals(injectionPointPackage);
        IQualifier[] iQualifierArray = qs = this.selectedBean.getCDIProject().getQualifiers();
        int n = qs.length;
        int n2 = 0;
        while (n2 < n) {
            IQualifier q = iQualifierArray[n2];
            ValuedQualifier vq = new ValuedQualifier(q);
            if (!(this.contains(this.originalQualifiers, vq) || this.contains(this.qualifiers, vq) || this.contains(this.deployed, vq))) {
                try {
                    boolean isPublic = Flags.isPublic((int)q.getSourceType().getFlags());
                    String qualifierTypeName = q.getSourceType().getFullyQualifiedName();
                    String qualifierPackage = qualifierTypeName.substring(0, qualifierTypeName.lastIndexOf("."));
                    if ((isPublic || samePackage && injectionPointPackage.equals(qualifierPackage)) && beanJavaProject.findType(qualifierTypeName) != null && injectionPointJavaProject.findType(qualifierTypeName) != null) {
                        if (q.getSourceType().getFullyQualifiedName().equals("javax.inject.Named")) {
                            vq.setValue("value", beanName);
                        }
                        this.qualifiers.add(vq);
                        this.availableTableViewer.add((Object)vq);
                        lastQualifier = vq;
                    }
                }
                catch (JavaModelException ex) {
                    CDIUIPlugin.getDefault().logError(ex);
                }
            }
            ++n2;
        }
        return lastQualifier;
    }

    private boolean contains(ArrayList<ValuedQualifier> qualifiers, ValuedQualifier qualifier) {
        for (ValuedQualifier q : qualifiers) {
            if (!q.equals((Object)qualifier)) continue;
            return true;
        }
        return false;
    }

    public void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (AddQualifiersToBeanComposite.this.availableTableViewer == null || AddQualifiersToBeanComposite.this.availableTableViewer.getControl().isDisposed()) {
                    return;
                }
                AddQualifiersToBeanComposite.this.availableTableViewer.refresh();
                AddQualifiersToBeanComposite.this.deployedTableViewer.refresh();
                AddQualifiersToBeanComposite.this.setEnablement();
            }
        });
    }

    public boolean checkBeans() {
        ArrayList<ValuedQualifier> total = new ArrayList<ValuedQualifier>();
        total.addAll(this.originalQualifiers);
        total.addAll(this.deployed);
        HashSet qfs = new HashSet(total);
        for (IBean b : this.beans) {
            if (b.equals(this.selectedBean) || !CDIMarkerResolutionUtils.checkValuedQualifiers((IBean)this.selectedBean, (IBean)b, qfs)) continue;
            return false;
        }
        return true;
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.setFont(this.getParent().getFont());
        Display display = this.getDisplay();
        FontData[] fd = this.getFont().getFontData();
        int size2 = fd.length;
        int i = 0;
        while (i < size2) {
            fd[i].setStyle(2);
            ++i;
        }
        font = new Font((Device)display, fd);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this.nLabel = new Label((Composite)this, 0);
        GridData data = new GridData(770);
        data.horizontalSpan = 3;
        this.nLabel.setLayoutData((Object)data);
        if (this.selectedBean != null) {
            this.nLabel.setText(MessageFormat.format(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_MESSAGE, this.selectedBean.getElementName(), this.injectionPoint.getElementName()));
        }
        Label label = new Label((Composite)this, 0);
        label.setText(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_ENTER_QUALIFIER_NAME);
        label.setLayoutData((Object)data);
        this.pattern = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.pattern.setLayoutData((Object)data);
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddQualifiersToBeanComposite.this.availableTableViewer.refresh();
            }
        });
        this.pattern.setFocus();
        label = new Label((Composite)this, 0);
        label.setText("");
        label = new Label((Composite)this, 0);
        label.setText("");
        label = new Label((Composite)this, 0);
        label.setText(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_AVAILABLE);
        label = new Label((Composite)this, 0);
        label.setText("");
        label = new Label((Composite)this, 0);
        label.setText(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_IN_BEAN);
        Table availableTable = new Table((Composite)this, 2818);
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 150;
        availableTable.setLayoutData((Object)data);
        this.availableTableViewer = new TableViewer(availableTable);
        this.availableTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        QualifiersListContentProvider contentProvider = new QualifiersListContentProvider();
        this.availableTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.availableTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof IQualifier && o2 instanceof IQualifier) {
                    IQualifier q1 = (IQualifier)o1;
                    IQualifier q2 = (IQualifier)o2;
                    return q1.getSourceType().getElementName().compareToIgnoreCase(q2.getSourceType().getElementName());
                }
                return super.compare(viewer, o1, o2);
            }
        });
        this.availableTableViewer.setInput(this.qualifiers);
        this.availableTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddQualifiersToBeanComposite.this.setEnablement();
            }
        });
        this.availableTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddQualifiersToBeanComposite.this.setEnablement();
                if (AddQualifiersToBeanComposite.this.add.isEnabled()) {
                    AddQualifiersToBeanComposite.this.add(false);
                }
            }
        });
        this.availableTableViewer.addFilter((ViewerFilter)new QualifierFilter());
        Composite comp = new Composite((Composite)this, 0);
        data = new GridData(1296);
        data.widthHint = 120;
        comp.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 25;
        layout.verticalSpacing = 20;
        comp.setLayout((Layout)layout);
        this.add = new Button(comp, 8);
        this.add.setText(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_ADD);
        this.add.setLayoutData((Object)new GridData(768));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQualifiersToBeanComposite.this.add(false);
            }
        });
        this.remove = new Button(comp, 8);
        this.remove.setText(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_REMOVE);
        this.remove.setLayoutData((Object)new GridData(768));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQualifiersToBeanComposite.this.remove(false);
            }
        });
        label = new Label(comp, 0);
        label.setText("");
        this.addAll = new Button(comp, 8);
        this.addAll.setText(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_ADD_ALL);
        this.addAll.setLayoutData((Object)new GridData(768));
        this.addAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQualifiersToBeanComposite.this.add(true);
            }
        });
        this.removeAll = new Button(comp, 8);
        this.removeAll.setText(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_REMOVE_ALL);
        this.removeAll.setLayoutData((Object)new GridData(768));
        this.removeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddQualifiersToBeanComposite.this.remove(true);
            }
        });
        Table deployedTable = new Table((Composite)this, 2818);
        data = new GridData(1808);
        data.widthHint = 150;
        deployedTable.setLayoutData((Object)data);
        this.deployedTableViewer = new TableViewer(deployedTable);
        this.deployedTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.deployedTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.deployedTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof IQualifier && o2 instanceof IQualifier) {
                    IQualifier q1 = (IQualifier)o1;
                    IQualifier q2 = (IQualifier)o2;
                    return q1.getSourceType().getElementName().compareToIgnoreCase(q2.getSourceType().getElementName());
                }
                return super.compare(viewer, o1, o2);
            }
        });
        this.deployedTableViewer.setInput(this.originalQualifiers);
        this.deployedTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddQualifiersToBeanComposite.this.setEnablement();
            }
        });
        this.deployedTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddQualifiersToBeanComposite.this.setEnablement();
                if (AddQualifiersToBeanComposite.this.remove.isEnabled()) {
                    AddQualifiersToBeanComposite.this.remove(false);
                }
            }
        });
        Button createQualifier = new Button((Composite)this, 8);
        createQualifier.setText(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_CREATE_NEW_QUALIFIER);
        createQualifier.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                final IJobManager manager = Job.getJobManager();
                if (Display.getCurrent() != null) {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            NewQualifierCreationWizard wizard = new NewQualifierCreationWizard();
                            StructuredSelection selection = new StructuredSelection(new Object[]{AddQualifiersToBeanComposite.this.selectedBean.getBeanClass()});
                            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
                            WizardDialog dialog = new WizardDialog(AddQualifiersToBeanComposite.this.getShell(), (IWizard)wizard);
                            int status = dialog.open();
                            if (status == 0) {
                                manager.endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                                try {
                                    Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                                }
                                catch (OperationCanceledException e) {
                                    CDICorePlugin.getDefault().logError((Throwable)e);
                                }
                                catch (InterruptedException e) {
                                    CDICorePlugin.getDefault().logError((Throwable)e);
                                }
                                AddQualifiersToBeanComposite.this.loadAvailableQualifiers();
                                manager.beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), null);
                            }
                        }
                    });
                }
            }
        });
        label = new Label((Composite)this, 0);
        label.setText("");
        this.editQualifierValue = new Button((Composite)this, 8);
        this.editQualifierValue.setText(CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_EDIT_QUALIFIER_VALUE);
        this.editQualifierValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ValuedQualifier[] vq = AddQualifiersToBeanComposite.this.getDeployedSelection();
                ValueDialog d = new ValueDialog(AddQualifiersToBeanComposite.this.getShell(), vq[0].getStringValue());
                int result = d.open();
                if (result == 0) {
                    vq[0].setValue("value", d.getValue());
                }
            }
        });
        Dialog.applyDialogFont((Control)this);
    }

    protected ValuedQualifier[] getAvailableSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.availableTableViewer.getSelection();
        if (sel.isEmpty()) {
            return new ValuedQualifier[0];
        }
        ValuedQualifier[] mss = new ValuedQualifier[sel.size()];
        System.arraycopy(sel.toArray(), 0, mss, 0, sel.size());
        return mss;
    }

    protected ValuedQualifier[] getDeployedSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.deployedTableViewer.getSelection();
        if (sel.isEmpty()) {
            return new ValuedQualifier[0];
        }
        ValuedQualifier[] mss = new ValuedQualifier[sel.size()];
        System.arraycopy(sel.toArray(), 0, mss, 0, sel.size());
        return mss;
    }

    protected void setEnablement() {
        ValuedQualifier qualifier;
        int i;
        boolean enabled;
        this.isComplete = true;
        ValuedQualifier[] ms = this.getAvailableSelection();
        if (ms == null || ms.length == 0) {
            this.add.setEnabled(false);
        } else {
            enabled = false;
            i = 0;
            while (i < ms.length) {
                qualifier = ms[i];
                if (qualifier != null) {
                    if (this.contains(this.qualifiers, qualifier)) {
                        enabled = true;
                    } else {
                        enabled = false;
                        break;
                    }
                }
                ++i;
            }
            this.add.setEnabled(enabled);
        }
        this.addAll.setEnabled(this.qualifiers.size() > 0);
        ms = this.getDeployedSelection();
        if (ms == null || ms.length == 0) {
            this.remove.setEnabled(false);
            this.editQualifierValue.setEnabled(false);
        } else {
            enabled = false;
            i = 0;
            while (i < ms.length) {
                qualifier = ms[i];
                if (qualifier == null || !this.contains(this.deployed, qualifier)) {
                    enabled = false;
                    break;
                }
                enabled = true;
                ++i;
            }
            this.remove.setEnabled(enabled);
            if (enabled && ms.length == 1 && this.isEditEnabled(ms[0])) {
                this.editQualifierValue.setEnabled(true);
            } else {
                this.editQualifierValue.setEnabled(false);
            }
        }
        this.removeAll.setEnabled(this.deployed.size() > 0);
        this.isComplete = this.checkBeans();
        if (this.isComplete) {
            this.page.setMessage("");
        } else {
            this.page.setMessage(NLS.bind((String)CDIUIMessages.ADD_QUALIFIERS_TO_BEAN_WIZARD_SET_IS_NOT_UNIQUE, (Object)this.selectedBean.getElementName(), (Object)this.injectionPoint.getElementName()), 3);
        }
        this.page.setPageComplete(this.isComplete);
    }

    private boolean isEditEnabled(ValuedQualifier valuedQualifier) {
        return valuedQualifier.isEditable();
    }

    protected void add(boolean all) {
        if (all) {
            ValuedQualifier[] qualifiers2 = new ValuedQualifier[this.qualifiers.size()];
            this.qualifiers.toArray(qualifiers2);
            this.moveAll(qualifiers2, true);
        } else {
            this.moveAll(this.getAvailableSelection(), true);
        }
    }

    protected void remove(boolean all) {
        if (all) {
            ArrayList<ValuedQualifier> list = new ArrayList<ValuedQualifier>();
            list.addAll(this.deployed);
            ValuedQualifier[] qualifiers2 = new ValuedQualifier[list.size()];
            list.toArray(qualifiers2);
            this.moveAll(qualifiers2, false);
        } else {
            this.moveAll(this.getDeployedSelection(), false);
        }
    }

    protected void moveAll(ValuedQualifier[] mods, boolean add2) {
        ArrayList<ValuedQualifier> list = new ArrayList<ValuedQualifier>();
        ValuedQualifier[] valuedQualifierArray = mods;
        int n = mods.length;
        int n2 = 0;
        while (n2 < n) {
            ValuedQualifier qualifier = valuedQualifierArray[n2];
            if (!this.contains(list, qualifier)) {
                list.add(qualifier);
            }
            ++n2;
        }
        for (ValuedQualifier qualifier : list) {
            if (add2) {
                this.qualifiers.remove(qualifier);
                this.deployed.add(qualifier);
                this.availableTableViewer.remove((Object)qualifier);
                this.deployedTableViewer.add((Object)qualifier);
                continue;
            }
            this.qualifiers.add(qualifier);
            this.deployed.remove(qualifier);
            this.availableTableViewer.add((Object)qualifier);
            this.deployedTableViewer.remove((Object)qualifier);
        }
        if (this.hasDefaultQualifier) {
            if (this.deployed.isEmpty() || this.namedQualifier != null && this.deployed.size() == 1 && this.deployed.contains(this.namedQualifier)) {
                if (!this.originalQualifiers.contains(this.defaultQualifier)) {
                    this.originalQualifiers.add(this.defaultQualifier);
                    this.deployedTableViewer.add((Object)this.defaultQualifier);
                }
            } else if (this.originalQualifiers.contains(this.defaultQualifier)) {
                this.originalQualifiers.remove(this.defaultQualifier);
                this.deployedTableViewer.remove((Object)this.defaultQualifier);
            }
        }
        this.setEnablement();
        this.page.setDeployedQualifiers(this.getDeployedQualifiers());
    }

    public ArrayList<ValuedQualifier> getQualifiersToRemove() {
        ArrayList<ValuedQualifier> list = new ArrayList<ValuedQualifier>();
        for (ValuedQualifier qualifier : this.originalQualifiers) {
            if (this.contains(this.deployed, qualifier)) continue;
            list.add(qualifier);
        }
        return list;
    }

    public ArrayList<ValuedQualifier> getQualifiersToAdd() {
        ArrayList<ValuedQualifier> list = new ArrayList<ValuedQualifier>();
        for (ValuedQualifier qualifier : this.deployed) {
            if (this.contains(this.originalQualifiers, qualifier)) continue;
            list.add(qualifier);
        }
        return list;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public ArrayList<ValuedQualifier> getDeployedQualifiers() {
        ArrayList<ValuedQualifier> total = new ArrayList<ValuedQualifier>();
        total.addAll(this.originalQualifiers);
        total.addAll(this.deployed);
        return total;
    }

    public void deploy(ValuedQualifier qualifier) {
        ValuedQualifier[] qualifiers = new ValuedQualifier[]{qualifier};
        this.moveAll(qualifiers, true);
    }

    public void remove(ValuedQualifier qualifier) {
        ValuedQualifier[] qualifiers = new ValuedQualifier[]{qualifier};
        this.moveAll(qualifiers, false);
    }

    public ArrayList<IQualifier> getAvailableQualifiers() {
        ArrayList<IQualifier> result = new ArrayList<IQualifier>();
        for (ValuedQualifier vq : this.qualifiers) {
            result.add(vq.getQualifier());
        }
        return result;
    }

    public class QualifierFilter
    extends ViewerFilter {
        SearchPattern patternMatcher = new SearchPattern();

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ValuedQualifier) {
                int lastIndex;
                String pattern;
                String qualifierTypeName = ((ValuedQualifier)element).getQualifier().getSourceType().getFullyQualifiedName();
                if (AddQualifiersToBeanComposite.this.pattern.getText().isEmpty()) {
                    this.patternMatcher.setPattern("*");
                } else {
                    this.patternMatcher.setPattern(AddQualifiersToBeanComposite.this.pattern.getText());
                }
                boolean result = this.patternMatcher.matches(qualifierTypeName);
                if (!result && (pattern = this.patternMatcher.getPattern()).indexOf(".") < 0 && (lastIndex = qualifierTypeName.lastIndexOf(".")) >= 0 && lastIndex + 1 < qualifierTypeName.length()) {
                    return this.patternMatcher.matches(qualifierTypeName.substring(lastIndex + 1));
                }
                return result;
            }
            return false;
        }
    }

    class QualifiersListContentProvider
    implements IStructuredContentProvider {
        QualifiersListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class QualifiersListLabelProvider
    implements ILabelProvider,
    IColorProvider {
        QualifiersListLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof ValuedQualifier) {
                return CDIImages.getImageByElement((ICDIElement)((ValuedQualifier)element).getQualifier());
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ValuedQualifier) {
                ValuedQualifier vq = (ValuedQualifier)element;
                String qualifierTypeName = vq.getQualifier().getSourceType().getFullyQualifiedName();
                String qualifierPackage = qualifierTypeName.substring(0, qualifierTypeName.lastIndexOf("."));
                String name = vq.getQualifier().getSourceType().getElementName();
                return String.valueOf(name) + " - " + qualifierPackage;
            }
            return "";
        }

        public Color getForeground(Object element) {
            if (element instanceof ValuedQualifier && AddQualifiersToBeanComposite.this.contains(AddQualifiersToBeanComposite.this.originalQualifiers, (ValuedQualifier)element)) {
                return ColorConstants.lightGray;
            }
            return ColorConstants.black;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    static class ValueDialog
    extends MessageDialog {
        String value;
        Text text;

        public ValueDialog(Shell shell, String value) {
            super(shell, "Edit Qualifier Annotation Value", null, "", 0, new String[]{"OK", "Cancel"}, 0);
            this.value = value;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 5;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Label label = new Label(composite, 0);
            label.setText("Qualifier annotation value:");
            this.text = new Text(composite, 2048);
            GridData data = new GridData(768);
            this.text.setLayoutData((Object)data);
            this.text.setText(this.value);
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ValueDialog.this.value = ValueDialog.this.text.getText();
                }
            });
            return composite;
        }

        public String getValue() {
            return this.value;
        }
    }
}

