/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.core.classpath;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.common.core.classpath.AbstractClasspathContainer;
import org.jboss.tools.common.core.classpath.ClasspathDecorations;
import org.jboss.tools.common.core.classpath.ClasspathDecorationsManager;

public abstract class AbstractClasspathContainerInitializer
extends ClasspathContainerInitializer {
    protected IJavaProject javaProject;

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        this.javaProject = project;
        int size = containerPath.segmentCount();
        if (size > 0) {
            AbstractClasspathContainer container = this.createClasspathContainer(containerPath);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    protected abstract AbstractClasspathContainer createClasspathContainer(IPath var1);

    protected abstract String getClasspathContainerID();

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer sg) throws CoreException {
        String key = AbstractClasspathContainer.getDecorationManagerKey(containerPath.toString());
        IClasspathEntry[] entries = sg.getClasspathEntries();
        ClasspathDecorationsManager decorations = AbstractClasspathContainer.getDecorationsManager();
        decorations.clearAllDecorations(key);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IPath srcpath = entry.getSourceAttachmentPath();
            IPath srcrootpath = entry.getSourceAttachmentRootPath();
            IClasspathAttribute[] attrs = entry.getExtraAttributes();
            String eid = entry.getPath().toString();
            ClasspathDecorations dec = new ClasspathDecorations();
            dec.setSourceAttachmentPath(srcpath);
            dec.setSourceAttachmentRootPath(srcrootpath);
            dec.setExtraAttributes(attrs);
            decorations.setDecorations(key, eid, dec);
            ++i;
        }
        decorations.save();
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)project);
        ((AbstractClasspathContainer)container).refresh();
    }
}

