/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.core.jandex;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.tools.common.core.CommonCorePlugin;

public class JandexUtil {
    static Index createJarIndex(File jarFile, Indexer indexer) throws IOException {
        JarFile jar = new JarFile(jarFile);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                try {
                    InputStream stream = jar.getInputStream(entry);
                    try {
                        indexer.index(stream);
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    CommonCorePlugin.getPluginLog().logError(e);
                }
            }
            Index index = indexer.complete();
            return index;
        }
        finally {
            JandexUtil.safeClose(jar);
        }
    }

    private static void safeClose(Closeable close) {
        try {
            close.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAnnotation(File jarFile, IAnnotationCheck check) {
        try {
            Indexer indexer = new Indexer();
            Index index = JandexUtil.createJarIndex(jarFile, indexer);
            Iterator iterator = index.getKnownClasses().iterator();
            block2: while (true) {
                Map.Entry es;
                String typeName;
                if (!iterator.hasNext()) {
                    return false;
                }
                ClassInfo cls = (ClassInfo)iterator.next();
                Iterator iterator2 = cls.annotations().entrySet().iterator();
                do {
                    if (!iterator2.hasNext()) continue block2;
                } while (!check.isRelevant(typeName = ((DotName)(es = iterator2.next()).getKey()).toString()));
                break;
            }
            return true;
        }
        catch (IOException e) {
            CommonCorePlugin.getPluginLog().logError(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasSubtypes(File jarFile, List<String> classes, List<String> interfaces) {
        try {
            Indexer indexer = new Indexer();
            Index index = JandexUtil.createJarIndex(jarFile, indexer);
            for (String className : classes) {
                if (index.getAllKnownSubclasses(DotName.createSimple((String)className)).isEmpty()) continue;
                return true;
            }
            for (String className : interfaces) {
                if (index.getAllKnownImplementors(DotName.createSimple((String)className)).isEmpty()) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            CommonCorePlugin.getPluginLog().logError(e);
        }
        return false;
    }

    public static interface IAnnotationCheck {
        public boolean isRelevant(String var1);
    }
}

