/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.java.impl;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.core.CommonCorePlugin;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class JavaAnnotation
implements IJavaAnnotation {
    IAnnotation annotation;
    String annotationTypeName;

    public JavaAnnotation(IAnnotation annotation, IType declaringType) {
        this.annotation = annotation;
        String name = annotation.getElementName();
        this.annotationTypeName = EclipseJavaUtil.resolveType(declaringType, name);
    }

    @Override
    public IResource getResource() {
        return this.annotation.getResource();
    }

    @Override
    public String getTypeName() {
        return this.annotationTypeName;
    }

    @Override
    public IType getType() {
        try {
            return EclipseJavaUtil.findType(this.annotation.getJavaProject(), this.annotationTypeName);
        }
        catch (JavaModelException e) {
            CommonCorePlugin.getDefault().logError(e);
            return null;
        }
    }

    @Override
    public int getLength() {
        try {
            ISourceRange range = this.annotation.getSourceRange();
            if (range != null) {
                return range.getLength();
            }
        }
        catch (JavaModelException e) {
            CommonCorePlugin.getDefault().logError(e);
        }
        return 0;
    }

    @Override
    public int getStartPosition() {
        try {
            ISourceRange range = this.annotation.getSourceRange();
            if (range != null) {
                return range.getOffset();
            }
        }
        catch (JavaModelException e) {
            CommonCorePlugin.getDefault().logError(e);
        }
        return 0;
    }

    @Override
    public IMember getParentMember() {
        IJavaElement ancestor = this.annotation.getParent();
        while (ancestor != null) {
            if (ancestor instanceof IMember) {
                return (IMember)ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    @Override
    public IJavaElement getParentElement() {
        return this.annotation.getParent();
    }

    @Override
    public IMemberValuePair[] getMemberValuePairs() {
        try {
            return this.annotation.getMemberValuePairs();
        }
        catch (JavaModelException e) {
            CommonCorePlugin.getDefault().logError(e);
            return new IMemberValuePair[0];
        }
    }

    public IAnnotation getAnnotation() {
        return this.annotation;
    }
}

