/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.log;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.jboss.tools.common.log.StatusFactory;
import org.osgi.framework.Bundle;

public class LogHelper {
    public static void logError(Plugin plugin, Throwable t) {
        LogHelper.logError(plugin, null, t);
    }

    public static void logError(Plugin plugin, String message) {
        LogHelper.logError(plugin, message, null);
    }

    public static void logError(Plugin plugin, String message, Throwable t) {
        IStatus status = StatusFactory.getInstance(4, plugin.getBundle().getSymbolicName(), message, t);
        LogHelper.logStatus(plugin, status);
    }

    public static void logError(String pluginId, Throwable t) {
        LogHelper.logError(pluginId, null, t);
    }

    public static void logError(String pluginId, String message) {
        LogHelper.logError(pluginId, message, null);
    }

    public static void logError(String pluginId, String message, Throwable t) {
        IStatus status = StatusFactory.getInstance(4, pluginId, message, t);
        LogHelper.logStatus(pluginId, status);
    }

    public static void logWarning(Plugin plugin, Throwable t) {
        LogHelper.logWarning(plugin, null, t);
    }

    public static void logWarning(Plugin plugin, String message) {
        LogHelper.logWarning(plugin, message, null);
    }

    public static void logWarning(Plugin plugin, String message, Throwable t) {
        IStatus status = StatusFactory.getInstance(2, plugin.getBundle().getSymbolicName(), message, t);
        LogHelper.logStatus(plugin, status);
    }

    public static void logWarning(String pluginId, Throwable t) {
        LogHelper.logWarning(pluginId, null, t);
    }

    public static void logWarning(String pluginId, String message) {
        LogHelper.logWarning(pluginId, message, null);
    }

    public static void logWarning(String pluginId, String message, Throwable t) {
        IStatus status = StatusFactory.getInstance(2, pluginId, message, t);
        LogHelper.logStatus(pluginId, status);
    }

    public static void logInfo(Plugin plugin, String message, Throwable t) {
        IStatus status = StatusFactory.getInstance(1, plugin.getBundle().getSymbolicName(), message, t);
        LogHelper.logStatus(plugin, status);
    }

    public static void logInfo(Plugin plugin, String message) {
        IStatus status = StatusFactory.getInstance(1, plugin.getBundle().getSymbolicName(), message);
        LogHelper.logStatus(plugin, status);
    }

    public static void logInfo(String pluginId, String message, Throwable t) {
        IStatus status = StatusFactory.getInstance(1, pluginId, message, t);
        LogHelper.logStatus(pluginId, status);
    }

    public static void logInfo(String pluginId, String message) {
        IStatus status = StatusFactory.getInstance(1, pluginId, message);
        LogHelper.logStatus(pluginId, status);
    }

    public static void log(int severity, String pluginId, int code, String message, Throwable t) {
        IStatus status = StatusFactory.getInstance(severity, pluginId, code, message, t);
        LogHelper.logStatus(pluginId, status);
    }

    public static void logStatus(Plugin plugin, IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logStatus(String pluginId, IStatus status) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        LogHelper.logStatus(bundle, status);
    }

    public static void logStatus(Bundle bundle, IStatus status) {
        ILog log = Platform.getLog((Bundle)bundle);
        log.log(status);
    }
}

